/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.image.j9;

import com.ibm.dtfj.image.j9.IFileLocationResolver;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class ZipExtractionResolver
implements IFileLocationResolver {
    private ZipFile _container;
    private Map _openFilesByName = new HashMap();

    public ZipExtractionResolver(ZipFile zipFile) {
        this._container = zipFile;
    }

    public File findFileWithFullPath(String string) throws FileNotFoundException {
        String string2 = new File(string).getName();
        File file = (File)this._openFilesByName.get(string);
        if (null == file) {
            ZipEntry zipEntry = this._container.getEntry(string);
            if (null == zipEntry) {
                zipEntry = this._container.getEntry(string2);
            }
            if (null == zipEntry) {
                throw new FileNotFoundException("No ZIP entry with name: \"" + string + "\"");
            }
            try {
                File file2 = File.createTempFile(string2, "dtfj");
                file2.deleteOnExit();
                InputStream inputStream = this._container.getInputStream(zipEntry);
                FileOutputStream fileOutputStream = new FileOutputStream(file2);
                byte[] byArray = new byte[4096];
                int n = inputStream.read(byArray);
                do {
                    fileOutputStream.write(byArray, 0, n);
                } while ((n = inputStream.read(byArray)) > 0);
                fileOutputStream.close();
                this._openFilesByName.put(string, file2);
                file = file2;
            }
            catch (IOException iOException) {
                throw new FileNotFoundException("Unable to open \"" + string + "\" due to no temporary unzip location");
            }
        }
        return file;
    }

    public File decompressCoreFile() throws FileNotFoundException {
        String string = this._baseCoreName();
        if (null != string) {
            return this.findFileWithFullPath(string);
        }
        throw new FileNotFoundException("Couldn't find a file resembling a core file inside the zip");
    }

    private String _baseCoreName() {
        String string = null;
        Enumeration<? extends ZipEntry> enumeration = this._container.entries();
        String string2 = this._container.getName();
        while (null == string && enumeration.hasMoreElements()) {
            ZipEntry zipEntry = enumeration.nextElement();
            String string3 = zipEntry.getName();
            if (string2.equals(string3 + ".zip")) {
                string = string3;
                continue;
            }
            ZipEntry zipEntry2 = this._container.getEntry(string3 + ".xml");
            if (null == zipEntry2) continue;
            string = string3;
        }
        return string;
    }

    public InputStream decompressMetaDataStream() throws IOException, FileNotFoundException {
        InputStream inputStream = null;
        String string = this._baseCoreName();
        if (null == string) {
            throw new FileNotFoundException("Couldn't find a file resembling a JExtract XML index file inside the zip");
        }
        inputStream = this._container.getInputStream(this._container.getEntry(string + ".xml"));
        return inputStream;
    }
}

