/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.image.j9;

import com.ibm.dtfj.image.CorruptDataException;
import com.ibm.dtfj.image.DataUnavailable;
import com.ibm.dtfj.image.ImageModule;
import com.ibm.dtfj.image.ImagePointer;
import com.ibm.dtfj.image.ImageProcess;
import com.ibm.dtfj.image.ImageSymbol;
import com.ibm.dtfj.image.j9.CorruptData;
import com.ibm.dtfj.image.j9.ImageAddressSpace;
import java.util.Iterator;

public class ImageStackFrame
implements com.ibm.dtfj.image.ImageStackFrame {
    private ImageAddressSpace _space;
    private String _procedureName = null;
    private ImagePointer _procedureAddress;
    private ImagePointer _basePointer;

    public ImageStackFrame(ImageAddressSpace imageAddressSpace, ImagePointer imagePointer, ImagePointer imagePointer2) {
        this._space = imageAddressSpace;
        this._procedureAddress = imagePointer;
        this._basePointer = imagePointer2;
    }

    public ImagePointer getProcedureAddress() throws CorruptDataException {
        return this._procedureAddress;
    }

    public ImagePointer getBasePointer() throws CorruptDataException {
        return this._basePointer;
    }

    public String getProcedureName() throws CorruptDataException {
        if (null == this._procedureName) {
            ImageProcess imageProcess = this._space.getCurrentProcess();
            if (null != imageProcess && this._procedureAddress.getAddress() != (1L << imageProcess.getPointerSize()) - 1L) {
                ImageModule imageModule;
                ImageSymbol imageSymbol = null;
                ImageModule imageModule2 = null;
                try {
                    imageModule = imageProcess.getExecutable();
                    if (null != imageModule && null != (imageSymbol = this.closestSymbolFrom(imageModule, imageSymbol))) {
                        imageModule2 = imageModule;
                    }
                }
                catch (DataUnavailable dataUnavailable) {
                    // empty catch block
                }
                try {
                    imageModule = imageSymbol;
                    Iterator iterator = imageProcess.getLibraries();
                    while (iterator.hasNext()) {
                        ImageModule imageModule3 = (ImageModule)iterator.next();
                        imageSymbol = this.closestSymbolFrom(imageModule3, (ImageSymbol)imageModule);
                        if (imageModule != imageSymbol) {
                            imageModule2 = imageModule3;
                        }
                        imageModule = imageSymbol;
                    }
                }
                catch (DataUnavailable dataUnavailable) {
                    // empty catch block
                }
                if (null != imageModule2 && null != imageSymbol) {
                    this._procedureName = imageModule2.getName() + "::" + imageSymbol.getName();
                } else if (null != imageSymbol) {
                    this._procedureName = imageSymbol.getName();
                }
            }
            if (null == this._procedureName) {
                this._procedureName = "<unknown location>";
            }
        }
        return this._procedureName;
    }

    private ImageSymbol closestSymbolFrom(ImageModule imageModule, ImageSymbol imageSymbol) {
        long l = this._procedureAddress.getAddress();
        long l2 = Long.MAX_VALUE;
        if (null != imageSymbol) {
            l2 = l - imageSymbol.getAddress().getAddress();
        }
        ImageSymbol imageSymbol2 = imageSymbol;
        Iterator iterator = imageModule.getSymbols();
        while (iterator.hasNext()) {
            ImageSymbol imageSymbol3;
            long l3;
            Object e = iterator.next();
            if (e instanceof CorruptData || (l3 = (imageSymbol3 = (ImageSymbol)e).getAddress().getAddress()) > l || l - l3 >= l2) continue;
            l2 = l - l3;
            imageSymbol2 = imageSymbol3;
        }
        return imageSymbol2;
    }
}

