/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.corereaders;

import com.ibm.dtfj.addressspace.DumpReaderAddressSpace;
import com.ibm.dtfj.addressspace.IAbstractAddressSpace;
import com.ibm.dtfj.corereaders.Builder;
import com.ibm.dtfj.corereaders.ClosingFileReader;
import com.ibm.dtfj.corereaders.DumpReader;
import com.ibm.dtfj.corereaders.ICoreFileReader;
import com.ibm.dtfj.corereaders.MemoryAccessException;
import com.ibm.dtfj.corereaders.MemoryRange;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;

public class NewZosDump
implements ICoreFileReader {
    private static final int DR1 = -992349888;
    private static final int DR2 = -992349632;
    private static final int RECORD_HEADER_LEN = 64;
    private static final int RECORD_BODY_LEN = 4096;
    private static final int RECORD_LEN = 4160;
    private List _memoryRanges = new ArrayList();
    private List _additionalFileNames = new ArrayList();
    private IAbstractAddressSpace _space;
    private ClosingFileReader _file;
    private boolean _is64Bit;
    private static final int CPU_ASID = 50149;

    private NewZosDump(ClosingFileReader closingFileReader) {
        this._file = closingFileReader;
        this._is64Bit = false;
        this.readTDUMP();
        int n = this.findAsidWithJ9RASEyeCatcher();
        if (-1 != n) {
            this.keepMemoryRangesWithAsid(n);
        }
    }

    private void keepMemoryRangesWithAsid(int n) {
        ArrayList<MemoryRange> arrayList = new ArrayList<MemoryRange>();
        for (MemoryRange memoryRange : this._memoryRanges) {
            if (memoryRange.getAsid() != n) continue;
            arrayList.add(memoryRange);
        }
        this._memoryRanges = arrayList;
    }

    private int findAsidWithJ9RASEyeCatcher() {
        try {
            byte[] byArray = new byte[4096];
            for (MemoryRange memoryRange : this._memoryRanges) {
                long l = memoryRange.getFileOffset();
                for (long i = 0L; i < memoryRange.getSize(); i += 4096L) {
                    this._file.seek(l);
                    l += 4160L;
                    this._file.readFully(byArray);
                    if (!this.bufferHasJ9RASEyeCatcher(byArray)) continue;
                    return memoryRange.getAsid();
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return -1;
    }

    private boolean bufferHasJ9RASEyeCatcher(byte[] byArray) {
        byte[] byArray2 = new byte[]{74, 57, 86, 77, 82, 65, 83, 0};
        for (int i = 0; i < byArray.length; i += 8) {
            boolean bl = true;
            for (int j = 0; j < byArray2.length; ++j) {
                if (byArray[i + j] == byArray2[j]) continue;
                bl = false;
            }
            if (!bl) continue;
            return true;
        }
        return false;
    }

    public Iterator getAdditionalFileNames() {
        return this._additionalFileNames.iterator();
    }

    public void extract(Builder builder) {
        Object object = builder.buildAddressSpace("z/OS Address Space", 0);
        Properties properties = new Properties();
        List<Object> list = Collections.singletonList(builder.buildCorruptData(object, "unable to extract thread information", 0L));
        List list2 = Collections.EMPTY_LIST;
        builder.setExecutableUnavailable("unable to extract executable information");
        builder.buildProcess(object, "0", "", properties, null, list.iterator(), null, list2.iterator(), this._is64Bit ? 64 : 32);
        builder.setCPUSubType("");
    }

    protected MemoryRange[] getMemoryRangesAsArray() {
        return this._memoryRanges.toArray(new MemoryRange[this._memoryRanges.size()]);
    }

    public static boolean isSupportedDump(ClosingFileReader closingFileReader) throws IOException {
        closingFileReader.seek(0L);
        int n = closingFileReader.readInt();
        return n == -992349888 || n == -992349632;
    }

    public static ICoreFileReader dumpFromFile(ClosingFileReader closingFileReader) throws IOException {
        assert (NewZosDump.isSupportedDump(closingFileReader));
        return new NewZosDump(closingFileReader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void readTDUMP() {
        block13: {
            MemoryRange memoryRange = null;
            long l = 0L;
            long l2 = 0L;
            try {
                try {
                    while (true) {
                        MemoryRange memoryRange2 = this.readRecord(l2);
                        l2 += 4160L;
                        if (null == memoryRange2 || memoryRange2.getAsid() == 0 || memoryRange2.getVirtualAddress() == 0L) continue;
                        if (memoryRange == null) {
                            memoryRange = memoryRange2;
                        }
                        if (memoryRange.getAsid() != memoryRange2.getAsid() || memoryRange.getVirtualAddress() + l != memoryRange2.getVirtualAddress()) {
                            MemoryRange memoryRange3 = null;
                            try {
                                memoryRange3 = new MemoryRange(memoryRange.getVirtualAddress(), memoryRange.getFileOffset(), l, memoryRange.getAsid(), memoryRange.isShared(), memoryRange.isReadOnly(), memoryRange.isExecutable());
                            }
                            catch (MemoryAccessException memoryAccessException) {
                                memoryRange3 = new MemoryRange(memoryRange.getVirtualAddress(), memoryRange.getFileOffset(), l, memoryRange.getAsid());
                            }
                            this._memoryRanges.add(memoryRange3);
                            memoryRange = memoryRange2;
                            l = 0L;
                        }
                        l += memoryRange2.getSize();
                    }
                }
                catch (IOException iOException) {
                    Object var10_8 = null;
                    if (memoryRange == null) break block13;
                    MemoryRange memoryRange4 = null;
                    try {
                        memoryRange4 = new MemoryRange(memoryRange.getVirtualAddress(), memoryRange.getFileOffset(), l, memoryRange.getAsid(), memoryRange.isShared(), memoryRange.isReadOnly(), memoryRange.isExecutable());
                    }
                    catch (MemoryAccessException memoryAccessException) {
                        memoryRange4 = new MemoryRange(memoryRange.getVirtualAddress(), memoryRange.getFileOffset(), l, memoryRange.getAsid());
                    }
                    this._memoryRanges.add(memoryRange4);
                }
            }
            catch (Throwable throwable) {
                Object var10_9 = null;
                if (memoryRange != null) {
                    MemoryRange memoryRange5 = null;
                    try {
                        memoryRange5 = new MemoryRange(memoryRange.getVirtualAddress(), memoryRange.getFileOffset(), l, memoryRange.getAsid(), memoryRange.isShared(), memoryRange.isReadOnly(), memoryRange.isExecutable());
                    }
                    catch (MemoryAccessException memoryAccessException) {
                        memoryRange5 = new MemoryRange(memoryRange.getVirtualAddress(), memoryRange.getFileOffset(), l, memoryRange.getAsid());
                    }
                    this._memoryRanges.add(memoryRange5);
                }
                throw throwable;
            }
        }
    }

    protected MemoryRange readRecord(long l) throws IOException {
        this._file.seek(l);
        int n = this._file.readInt();
        if (n != -992349888 && n != -992349632) {
            throw new IOException("Unrecognized dump record");
        }
        int n2 = this._file.readShort() & 0xFFFF;
        if (50149 != n2) {
            return null;
        }
        this._file.seek(l + 12L);
        int n3 = this._file.readInt();
        this._file.seek(l + 20L);
        long l2 = this._file.readLong();
        if (l2 > 0xFFFFFFFFL) {
            this._is64Bit = true;
        }
        return new MemoryRange(l2, l + 64L, 4096L, n3, false, false, true);
    }

    public IAbstractAddressSpace getAddressSpace() {
        if (null == this._space) {
            this._space = new MVSAddressSpace();
        }
        return this._space;
    }

    private class MVSAddressSpace
    extends DumpReaderAddressSpace {
        MVSAddressSpace() {
            super(NewZosDump.this.getMemoryRangesAsArray(), new DumpReader(NewZosDump.this._file, NewZosDump.this._is64Bit), false, NewZosDump.this._is64Bit);
        }

        private MemoryRange _findMemoryRange(int n, long l) throws MemoryAccessException {
            Iterator iterator = this.getMemoryRanges();
            while (iterator.hasNext()) {
                MemoryRange memoryRange = (MemoryRange)iterator.next();
                if (!memoryRange.contains(l)) continue;
                return memoryRange;
            }
            throw new MemoryAccessException(n, l);
        }

        protected long _translateAddress(int n, long l) throws MemoryAccessException {
            MemoryRange memoryRange = this._findMemoryRange(n, l);
            long l2 = l - memoryRange.getVirtualAddress();
            int n2 = (int)(l2 / 4096L);
            return memoryRange.getFileOffset() + (long)(n2 * 64) + l2;
        }

        public int getBytesAt(int n, long l, byte[] byArray) throws MemoryAccessException {
            MemoryRange memoryRange = this._findMemoryRange(n, l);
            long l2 = l - memoryRange.getVirtualAddress();
            int n2 = (int)(l2 / 4096L);
            int n3 = (int)((l2 + (long)byArray.length) / 4096L) - n2;
            int n4 = (int)(l2 - (long)(n2 * 4096));
            long l3 = memoryRange.getFileOffset() + (long)(n2 * 64) + l2;
            long l4 = l3 + (long)(n3 * 64) + (long)byArray.length;
            long l5 = Math.min(l3 + (long)(4096 - n4), l4);
            int n5 = 0;
            while (l3 < l4) {
                try {
                    int n6 = (int)(l5 - l3);
                    NewZosDump.this._file.seek(l3);
                    byte[] byArray2 = new byte[n6];
                    NewZosDump.this._file.readFully(byArray2);
                    System.arraycopy(byArray2, 0, byArray, n5, byArray2.length);
                    n5 += byArray2.length;
                    if (n6 != byArray2.length) break;
                    l3 = l5 + 64L;
                    l5 = Math.min(l3 + 4096L, l4);
                }
                catch (IOException iOException) {
                    throw new MemoryAccessException(n, l);
                }
            }
            return n5;
        }
    }
}

