/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.corereaders;

import com.ibm.dtfj.corereaders.Builder;
import com.ibm.dtfj.corereaders.ClosingFileReader;
import com.ibm.dtfj.corereaders.CoreReaderSupport;
import com.ibm.dtfj.corereaders.DumpReader;
import com.ibm.dtfj.corereaders.ICoreFileReader;
import com.ibm.dtfj.corereaders.LittleEndianDumpReader;
import com.ibm.dtfj.corereaders.MemoryAccessException;
import com.ibm.dtfj.corereaders.MemoryRange;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import java.util.Vector;

public class NewElfDump
extends CoreReaderSupport {
    private static final int ELF_NOTE_HEADER_SIZE = 12;
    private static final int EI_NIDENT = 16;
    private static final int ELF_PRARGSZ = 80;
    private static final int ELFCLASS32 = 1;
    private static final int ELFCLASS64 = 2;
    private static final int ELFDATA2LSB = 1;
    private static final int ELFDATA2MSB = 2;
    private static final int ARCH_IA32 = 3;
    private static final int ARCH_PPC32 = 20;
    private static final int ARCH_PPC64 = 21;
    private static final int ARCH_S390 = 22;
    private static final int ARCH_IA64 = 50;
    private static final int ARCH_AMD64 = 62;
    private static final int DT_NULL = 0;
    private static final int DT_DEBUG = 21;
    private static final int NT_PRSTATUS = 1;
    private static final int NT_PRPSINFO = 3;
    private static final int NT_AUXV = 6;
    private static final int AT_NULL = 0;
    private static final int AT_ENTRY = 9;
    private static final int AT_PLATFORM = 15;
    private static final int AT_HWCAP = 16;
    private List _memoryRanges = new ArrayList();
    private List _additionalFileNames = new ArrayList();
    private long _platformIdAddress = 0L;
    private ElfFile _file;
    private boolean _isLittleEndian;
    private boolean _is64Bit;
    private static final long SHT_STRTAB = 3L;

    private Object readProcess(DataEntry dataEntry, Builder builder, Object object, List list) throws IOException, MemoryAccessException {
        this._file.seek(dataEntry.offset);
        this._file.readByte();
        this._file.readByte();
        this._file.readByte();
        this._file.readByte();
        this._file.seek(dataEntry.offset + this._file.padToWordBoundary(4L));
        this._file.readElfWord();
        this.readUID();
        this.readUID();
        long l = (long)this._file.readInt() & 0xFFFFFFFFL;
        this._file.readInt();
        this._file.readInt();
        this._file.readInt();
        this._file.seek(dataEntry.offset + dataEntry.size - 96L);
        this._file.readBytes(16);
        String string = new String(this._file.readBytes(80), "ASCII").trim();
        int n = string.indexOf(" ");
        String string2 = string;
        if (0 < n) {
            string2 = string2.substring(0, n);
        }
        return this.buildProcess(builder, object, String.valueOf(l), string, this.getEnvironmentVariables(builder), list.get(0), list.iterator(), string2);
    }

    private Object buildProcess(Builder builder, Object object, String string, String string2, Properties properties, Object object2, Iterator iterator, String string3) throws IOException, MemoryAccessException {
        List list = this.readModules(builder, object, string3);
        Iterator iterator2 = list.iterator();
        Object var11_11 = null;
        if (iterator2.hasNext()) {
            var11_11 = iterator2.next();
        }
        return builder.buildProcess(object, string, string2, properties, object2, iterator, var11_11, iterator2, this._file.addressSize());
    }

    private List readModules(Builder builder, Object object, String string) throws IOException, MemoryAccessException {
        ClosingFileReader closingFileReader = builder.openFile(string);
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (null != closingFileReader) {
            ElfFile elfFile = this.elfFileFrom(closingFileReader);
            if (null != elfFile) {
                ProgramHeaderEntry programHeaderEntry = null;
                Object object2 = elfFile.programHeaderEntries();
                while (null == programHeaderEntry && object2.hasNext()) {
                    ProgramHeaderEntry programHeaderEntry2 = (ProgramHeaderEntry)object2.next();
                    if (!programHeaderEntry2.isDynamic()) continue;
                    programHeaderEntry = programHeaderEntry2;
                }
                if (null != programHeaderEntry) {
                    object2 = NewElfDump.readSymbolsFrom(builder, object, elfFile, programHeaderEntry.virtualAddress);
                    long l = programHeaderEntry.virtualAddress;
                    if (this.isValidAddress(l)) {
                        Iterator iterator = this._buildModuleSections(builder, object, elfFile, programHeaderEntry.virtualAddress);
                        Properties properties = elfFile.getProperties();
                        arrayList.add(builder.buildModule(string, properties, iterator, object2.iterator()));
                        arrayList.addAll(this.readLibrariesAt(builder, object, l));
                        this._additionalFileNames.add(string);
                    }
                }
            } else {
                builder.setExecutableUnavailable("Executable file \"" + string + "\" not found");
            }
        } else {
            builder.setExecutableUnavailable("File \"" + string + "\" not found");
        }
        return arrayList;
    }

    private Iterator _buildModuleSections(Builder builder, Object object, ElfFile elfFile, long l) throws IOException {
        Object object2;
        Object object3;
        SectionHeaderEntry sectionHeaderEntry;
        Vector<Object> vector = new Vector<Object>();
        Iterator iterator = elfFile.sectionHeaderEntries();
        Object object4 = null;
        while (iterator.hasNext()) {
            sectionHeaderEntry = (SectionHeaderEntry)iterator.next();
            if (3L != sectionHeaderEntry._type) continue;
            elfFile.seek(sectionHeaderEntry.offset);
            object3 = elfFile.readBytes((int)sectionHeaderEntry.size);
            object2 = NewElfDump.stringFromBytesAt((byte[])object3, (int)sectionHeaderEntry._name);
            if (!((String)object2).equals(".shstrtab")) continue;
            object4 = object3;
        }
        iterator = elfFile.sectionHeaderEntries();
        while (iterator.hasNext()) {
            sectionHeaderEntry = (SectionHeaderEntry)iterator.next();
            object3 = "";
            if (null != object4) {
                object3 = NewElfDump.stringFromBytesAt(object4, (int)sectionHeaderEntry._name);
            }
            object2 = builder.buildModuleSection(object, (String)object3, l + sectionHeaderEntry.offset, l + sectionHeaderEntry.offset + sectionHeaderEntry.size);
            vector.add(object2);
        }
        return vector.iterator();
    }

    private boolean isValidAddress(long l) {
        Iterator iterator = this._file.programHeaderEntries();
        while (iterator.hasNext()) {
            ProgramHeaderEntry programHeaderEntry = (ProgramHeaderEntry)iterator.next();
            if (!programHeaderEntry.contains(l)) continue;
            return true;
        }
        return false;
    }

    private List readLibrariesAt(Builder builder, Object object, long l) throws MemoryAccessException, IOException {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        this.seekToAddress(l);
        long l2 = this._file.readElfWord();
        while (0L != l2 && 21L != l2) {
            this._file.readElfWord();
            l2 = this._file.readElfWord();
        }
        if (21L == l2) {
            long l3 = this._file.readElfWord();
            this.seekToAddress(l3);
            this._file.readElfWord();
            long l4 = this._file.readElfWord();
            while (0L != l4) {
                this.seekToAddress(l4);
                long l5 = this._file.readElfWord();
                long l6 = this._file.readElfWord();
                this._file.readElfWord();
                l4 = this._file.readElfWord();
                if (0L == l5) continue;
                MemoryRange memoryRange = this.memoryRangeFor(l5);
                Properties properties = new Properties();
                List<Object> list = new ArrayList<Object>();
                String string = this.readStringAt(l6);
                Iterator iterator = new Vector().iterator();
                if (null != memoryRange && memoryRange.getVirtualAddress() == l5) {
                    ClosingFileReader closingFileReader = builder.openFile(string);
                    ElfFile elfFile = null;
                    if (null != closingFileReader) {
                        elfFile = this.elfFileFrom(closingFileReader);
                        this._additionalFileNames.add(string);
                        if (null != elfFile) {
                            list = NewElfDump.readSymbolsFrom(builder, object, elfFile, l5);
                            properties = elfFile.getProperties();
                            iterator = this._buildModuleSections(builder, object, elfFile, l5);
                        } else {
                            list.add(builder.buildCorruptData(object, "unable to find module " + string, l5));
                        }
                    }
                }
                arrayList.add(builder.buildModule(string, properties, iterator, list.iterator()));
            }
        }
        return arrayList;
    }

    private MemoryRange memoryRangeFor(long l) {
        Iterator iterator = this._memoryRanges.iterator();
        MemoryRange memoryRange = null;
        while (null == memoryRange && iterator.hasNext()) {
            MemoryRange memoryRange2 = (MemoryRange)iterator.next();
            if (!memoryRange2.contains(l)) continue;
            memoryRange = memoryRange2;
        }
        return memoryRange;
    }

    private void seekToAddress(long l) throws IOException {
        Iterator iterator = this._file.programHeaderEntries();
        while (iterator.hasNext()) {
            ProgramHeaderEntry programHeaderEntry = (ProgramHeaderEntry)iterator.next();
            if (!programHeaderEntry.contains(l)) continue;
            this.coreSeek(programHeaderEntry.fileOffset + (l - programHeaderEntry.virtualAddress));
        }
    }

    private static List readSymbolsFrom(Builder builder, Object object, ElfFile elfFile, long l) throws IOException {
        ArrayList arrayList = new ArrayList();
        Iterator iterator = elfFile.sectionHeaderEntries();
        while (iterator.hasNext()) {
            SectionHeaderEntry sectionHeaderEntry = (SectionHeaderEntry)iterator.next();
            if (!sectionHeaderEntry.isSymbolTable()) continue;
            arrayList.addAll(NewElfDump.readSymbolsFrom(builder, object, elfFile, sectionHeaderEntry, l));
        }
        return arrayList;
    }

    private static List readSymbolsFrom(Builder builder, Object object, ElfFile elfFile, SectionHeaderEntry sectionHeaderEntry, long l) throws IOException {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        SectionHeaderEntry sectionHeaderEntry2 = elfFile.sectionHeaderEntryAt((int)sectionHeaderEntry.link);
        elfFile.seek(sectionHeaderEntry2.offset);
        byte[] byArray = elfFile.readBytes((int)sectionHeaderEntry2.size);
        Iterator iterator = elfFile.readSymbolsAt(sectionHeaderEntry);
        while (iterator.hasNext()) {
            String string;
            Symbol symbol = (Symbol)iterator.next();
            if (!symbol.isFunction() || null == (string = NewElfDump.stringFromBytesAt(byArray, (int)symbol.name)) || 0L == symbol.value) continue;
            arrayList.add(builder.buildSymbol(object, string, l + symbol.value));
        }
        return arrayList;
    }

    private static String stringFromBytesAt(byte[] byArray, int n) {
        try {
            for (int i = n; i < byArray.length; ++i) {
                if (0 != byArray[i]) continue;
                return new String(byArray, n, i - n, "ASCII");
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return null;
    }

    private Properties getEnvironmentVariables(Builder builder) throws MemoryAccessException, IOException {
        long l = builder.getEnvironmentAddress();
        if (0L == l) {
            return null;
        }
        ArrayList<Address> arrayList = new ArrayList<Address>();
        this.seekToAddress(l);
        Address address = this._file.readElfWordAsAddress();
        this.seekToAddress(address.getValue());
        address = this._file.readElfWordAsAddress();
        while (!address.isNil()) {
            arrayList.add(address);
            address = this._file.readElfWordAsAddress();
        }
        Properties properties = new Properties();
        for (Address address2 : arrayList) {
            StringBuffer stringBuffer = new StringBuffer();
            this.seekToAddress(address2.getValue());
            byte by = this.coreReadByte();
            while (0 != by) {
                stringBuffer.append(new String(new byte[]{by}, "ASCII"));
                by = this.coreReadByte();
            }
            String string = stringBuffer.toString();
            int n = string.indexOf(61);
            String string2 = string.substring(0, n);
            String string3 = string.substring(n + 1);
            properties.put(string2, string3);
        }
        return properties;
    }

    private long readUID() throws IOException {
        return this._file.readUID();
    }

    private Object readThread(DataEntry dataEntry, Builder builder, Object object) throws IOException, MemoryAccessException {
        this._file.seek(dataEntry.offset);
        int n = this._file.readInt();
        this._file.readInt();
        this._file.readInt();
        this._file.readShort();
        this._file.readShort();
        this._file.readElfWord();
        this._file.readElfWord();
        long l = (long)this._file.readInt() & 0xFFFFFFFFL;
        this._file.readInt();
        this._file.readInt();
        this._file.readInt();
        this._file.readElfWord();
        this._file.readElfWord();
        this._file.readElfWord();
        this._file.readElfWord();
        this._file.readElfWord();
        this._file.readElfWord();
        this._file.readElfWord();
        this._file.readElfWord();
        Map map = this._file.readRegisters(builder, object);
        Properties properties = new Properties();
        return this.buildThread(builder, object, String.valueOf(l), map, properties, n);
    }

    private Object buildThread(Builder builder, Object object, String string, Map map, Properties properties, int n) throws MemoryAccessException, IOException {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        long l = this._file.getStackPointerFrom(map).getValue();
        long l2 = this._file.getBasePointerFrom(map).getValue();
        long l3 = this._file.getInstructionPointerFrom(map).getValue();
        if (0L == l3 || !this.isValidAddress(l3)) {
            l3 = this._file.getLinkRegisterFrom(map).getValue();
        }
        if (0L != l3 && 0L != l2 && this.isValidAddress(l3)) {
            MemoryRange memoryRange = this.memoryRangeFor(l);
            arrayList2.add(builder.buildStackSection(object, memoryRange.getVirtualAddress(), memoryRange.getVirtualAddress() + memoryRange.getSize()));
            arrayList.add(builder.buildStackFrame(object, l2, l3));
            while (memoryRange.contains(l2)) {
                this.seekToAddress(l2);
                l2 = this.coreReadAddress();
                l3 = this.coreReadAddress();
                arrayList.add(builder.buildStackFrame(object, l2, l3));
            }
        }
        return builder.buildThread(string, this.registersAsList(builder, map).iterator(), arrayList2.iterator(), arrayList.iterator(), properties, n);
    }

    private List registersAsList(Builder builder, Map map) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (Map.Entry entry : map.entrySet()) {
            Address address = (Address)entry.getValue();
            arrayList.add(builder.buildRegister((String)entry.getKey(), address.asNumber()));
        }
        return arrayList;
    }

    private NewElfDump(ElfFile elfFile, DumpReader dumpReader, boolean bl, boolean bl2) {
        super(dumpReader);
        this._file = elfFile;
        this._isLittleEndian = bl;
        this._is64Bit = bl2;
        TreeMap<Long, MemoryRange> treeMap = new TreeMap<Long, MemoryRange>();
        Iterator iterator = this._file.programHeaderEntries();
        while (iterator.hasNext()) {
            ProgramHeaderEntry programHeaderEntry = (ProgramHeaderEntry)iterator.next();
            if (programHeaderEntry.isEmpty()) continue;
            treeMap.put(new Long(programHeaderEntry.virtualAddress), programHeaderEntry.asMemoryRange());
        }
        this._memoryRanges.addAll(treeMap.values());
    }

    private ElfFile elfFileFrom(ClosingFileReader closingFileReader) throws IOException {
        DumpReader dumpReader;
        ElfFile elfFile;
        closingFileReader.seek(0L);
        byte[] byArray = new byte[16];
        closingFileReader.readFully(byArray);
        if (-1 != new String(byArray).toLowerCase().indexOf("elf") && (elfFile = NewElfDump.fileForClass(byArray[4], dumpReader = NewElfDump.readerForEndianess(byArray[5], byArray[4], closingFileReader))).getClass().isInstance(this._file)) {
            return elfFile;
        }
        return null;
    }

    private static DumpReader readerForEndianess(byte by, byte by2, ClosingFileReader closingFileReader) throws IOException {
        boolean bl;
        boolean bl2 = bl = 2 == by2;
        if (!bl && 1 != by2) {
            throw new IOException("Unexpected class flag " + by2 + " detected in ELF file.");
        }
        if (1 == by) {
            return new LittleEndianDumpReader(closingFileReader, bl);
        }
        if (2 == by) {
            return new DumpReader(closingFileReader, bl);
        }
        throw new IOException("Unknown endianess flag " + by + " in ELF core file");
    }

    private static ElfFile fileForClass(byte by, DumpReader dumpReader) throws IOException {
        if (1 == by) {
            return new Elf32File(dumpReader);
        }
        if (2 == by) {
            return new Elf64File(dumpReader);
        }
        throw new IOException("Unexpected class flag " + by + " detected in ELF file.");
    }

    public void extract(Builder builder) {
        try {
            DataEntry dataEntry;
            Object object;
            Object object2 = builder.buildAddressSpace("ELF Address Space", 0);
            ArrayList<Object> arrayList = new ArrayList<Object>();
            Object object3 = this._file.threadEntries();
            while (object3.hasNext()) {
                object = (DataEntry)object3.next();
                arrayList.add(this.readThread((DataEntry)object, builder, object2));
            }
            object3 = new ArrayList();
            object = this._file.processEntries();
            while (object.hasNext()) {
                dataEntry = (DataEntry)object.next();
                object3.add(this.readProcess(dataEntry, builder, object2, arrayList));
            }
            object = this._file.auxiliaryVectorEntries();
            while (object.hasNext()) {
                dataEntry = (DataEntry)object.next();
                this.readAuxiliaryVector(dataEntry);
            }
            builder.setCPUSubType(this.readStringAt(this._platformIdAddress));
        }
        catch (IOException iOException) {
        }
        catch (MemoryAccessException memoryAccessException) {
            // empty catch block
        }
    }

    private void readAuxiliaryVector(DataEntry dataEntry) throws IOException {
        this._file.seek(dataEntry.offset);
        if (0L != dataEntry.size) {
            long l = this._file.readElfWord();
            while (0L != l) {
                if (15L == l) {
                    this._platformIdAddress = this._file.readElfWord();
                } else if (9L == l) {
                    this._file.readElfWord();
                } else if (16L == l) {
                    this._file.readElfWord();
                } else {
                    this._file.readElfWord();
                }
                l = this._file.readElfWord();
            }
        }
    }

    private String readStringAt(long l) throws IOException {
        if (this.isValidAddress(l)) {
            StringBuffer stringBuffer = new StringBuffer();
            this.seekToAddress(l);
            byte by = this.coreReadByte();
            long l2 = 1L;
            while (0 != by) {
                stringBuffer.append(new String(new byte[]{by}, "ASCII"));
                by = this.coreReadByte();
                ++l2;
            }
            return stringBuffer.toString();
        }
        return "";
    }

    public static boolean isSupportedDump(ClosingFileReader closingFileReader) throws IOException {
        closingFileReader.seek(0L);
        byte[] byArray = new byte[16];
        closingFileReader.readFully(byArray);
        return -1 != new String(byArray).toLowerCase().indexOf("elf");
    }

    public static ICoreFileReader dumpFromFile(ClosingFileReader closingFileReader) throws IOException {
        assert (NewElfDump.isSupportedDump(closingFileReader));
        closingFileReader.seek(0L);
        byte[] byArray = new byte[16];
        closingFileReader.readFully(byArray);
        boolean bl = 1 == byArray[5];
        boolean bl2 = 2 == byArray[4];
        DumpReader dumpReader = NewElfDump.readerForEndianess(byArray[5], byArray[4], closingFileReader);
        ElfFile elfFile = NewElfDump.fileForClass(byArray[4], dumpReader);
        return new NewElfDump(elfFile, dumpReader, bl, bl2);
    }

    public Iterator getAdditionalFileNames() {
        return this._additionalFileNames.iterator();
    }

    protected MemoryRange[] getMemoryRangesAsArray() {
        return this._memoryRanges.toArray(new MemoryRange[this._memoryRanges.size()]);
    }

    protected boolean isLittleEndian() {
        return this._isLittleEndian;
    }

    protected boolean is64Bit() {
        return this._is64Bit;
    }

    private static class Elf64File
    extends ElfFile {
        Elf64File(DumpReader dumpReader) throws IOException {
            super(dumpReader);
            this.readFile();
        }

        protected ProgramHeaderEntry readProgramHeaderEntry() throws IOException {
            int n = this.readInt();
            int n2 = this.readInt();
            long l = this.readLong();
            long l2 = this.readLong();
            long l3 = this.readLong();
            long l4 = this.readLong();
            long l5 = this.readLong();
            long l6 = this.readLong();
            return new ProgramHeaderEntry(n, l, l4, l2, l3, l5, n2, l6);
        }

        protected long padToWordBoundary(long l) {
            return (l + 7L) / 8L * 8L;
        }

        protected long readElfWord() throws IOException {
            return this.readLong();
        }

        protected Address readElfWordAsAddress() throws IOException {
            return new Address64(this.readLong());
        }

        int addressSize() {
            return 64;
        }

        Iterator readSymbolsAt(SectionHeaderEntry sectionHeaderEntry) throws IOException {
            this.seek(sectionHeaderEntry.offset);
            ArrayList<Symbol> arrayList = new ArrayList<Symbol>();
            long l = sectionHeaderEntry.size / 24L;
            for (long i = 0L; i < l; ++i) {
                long l2 = (long)this.readInt() & 0xFFFFFFFFL;
                byte by = this.readByte();
                byte by2 = this.readByte();
                int n = this.readShort() & 0xFFFF;
                long l3 = this.readLong();
                long l4 = this.readLong();
                arrayList.add(new Symbol(l2, l3, l4, by, by2, n));
            }
            return arrayList.iterator();
        }
    }

    private static class Elf32File
    extends ElfFile {
        protected Arch architectureFor(short s) {
            if (22 == s) {
                return new ArchS390_32();
            }
            return super.architectureFor(s);
        }

        Elf32File(DumpReader dumpReader) throws IOException {
            super(dumpReader);
            this.readFile();
        }

        protected ProgramHeaderEntry readProgramHeaderEntry() throws IOException {
            int n = this.readInt();
            long l = this.unsigned(this.readInt());
            long l2 = this.unsigned(this.readInt());
            long l3 = this.unsigned(this.readInt());
            long l4 = this.unsigned(this.readInt());
            long l5 = this.unsigned(this.readInt());
            int n2 = this.readInt();
            long l6 = this.unsigned(this.readInt());
            return new ProgramHeaderEntry(n, l, l4, l2, l3, l5, n2, l6);
        }

        private long unsigned(int n) {
            return (long)n & 0xFFFFFFFFL;
        }

        protected long padToWordBoundary(long l) {
            return (l + 3L) / 4L * 4L;
        }

        protected long readElfWord() throws IOException {
            return (long)this.readInt() & 0xFFFFFFFFL;
        }

        protected Address readElfWordAsAddress() throws IOException {
            return new Address32(this.readInt());
        }

        int addressSize() {
            return 32;
        }

        Iterator readSymbolsAt(SectionHeaderEntry sectionHeaderEntry) throws IOException {
            this.seek(sectionHeaderEntry.offset);
            ArrayList<Symbol> arrayList = new ArrayList<Symbol>();
            long l = sectionHeaderEntry.size / 16L;
            for (long i = 0L; i < l; ++i) {
                long l2 = (long)this.readInt() & 0xFFFFFFFFL;
                long l3 = (long)this.readInt() & 0xFFFFFFFFL;
                long l4 = (long)this.readInt() & 0xFFFFFFFFL;
                byte by = this.readByte();
                byte by2 = this.readByte();
                int n = this.readShort() & 0xFFFF;
                arrayList.add(new Symbol(l2, l3, l4, by, by2, n));
            }
            return arrayList.iterator();
        }
    }

    private static abstract class ElfFile {
        private DumpReader _reader;
        private Arch _arch = null;
        private long _programHeaderOffset = -1L;
        private long _sectionHeaderOffset = -1L;
        private short _programHeaderEntrySize = 0;
        private short _programHeaderCount = 0;
        private short _sectionHeaderEntrySize = 0;
        private short _sectionHeaderCount = 0;
        private List _processEntries = new ArrayList();
        private List _threadEntries = new ArrayList();
        private List _auxiliaryVectorEntries = new ArrayList();
        private List _programHeaderEntries = new ArrayList();
        private List _sectionHeaderEntries = new ArrayList();
        private short _objectType = 0;
        private int _version = 0;
        private int _e_flags = 0;
        private static final short ET_NONE = 0;
        private static final short ET_REL = 1;
        private static final short ET_EXEC = 2;
        private static final short ET_DYN = 3;
        private static final short ET_CORE = 4;
        private static final short ET_NUM = 5;
        private static final int ET_LOOS = 65024;
        private static final int ET_HIOS = 65279;
        private static final int ET_LOPROC = 65280;
        private static final int ET_HIPROC = 65535;

        protected abstract long padToWordBoundary(long var1);

        protected abstract ProgramHeaderEntry readProgramHeaderEntry() throws IOException;

        protected abstract long readElfWord() throws IOException;

        protected abstract Address readElfWordAsAddress() throws IOException;

        ElfFile(DumpReader dumpReader) {
            this._reader = dumpReader;
        }

        Iterator processEntries() {
            return this._processEntries.iterator();
        }

        Iterator threadEntries() {
            return this._threadEntries.iterator();
        }

        Iterator auxiliaryVectorEntries() {
            return this._auxiliaryVectorEntries.iterator();
        }

        Iterator programHeaderEntries() {
            return this._programHeaderEntries.iterator();
        }

        Iterator sectionHeaderEntries() {
            return this._sectionHeaderEntries.iterator();
        }

        SectionHeaderEntry sectionHeaderEntryAt(int n) {
            return (SectionHeaderEntry)this._sectionHeaderEntries.get(n);
        }

        protected void readFile() throws IOException {
            this.seek(0L);
            this.readHeader();
            this.readSectionHeader();
            this.readProgramHeader();
        }

        private void readHeader() throws IOException {
            this.readBytes(16);
            this._objectType = this.readShort();
            short s = this.readShort();
            this._arch = this.architectureFor(s);
            this._version = this.readInt();
            this.readElfWord();
            this._programHeaderOffset = this.readElfWord();
            this._sectionHeaderOffset = this.readElfWord();
            this._e_flags = this.readInt();
            this.readShort();
            this._programHeaderEntrySize = this.readShort();
            this._programHeaderCount = this.readShort();
            this._sectionHeaderEntrySize = this.readShort();
            this._sectionHeaderCount = this.readShort();
            this.readShort();
        }

        protected Arch architectureFor(short s) {
            switch (s) {
                case 20: 
                case 21: {
                    return new ArchPPC();
                }
                case 50: {
                    return new ArchIA64();
                }
                case 22: {
                    return new ArchS390();
                }
                case 3: {
                    return new ArchIA32();
                }
                case 62: {
                    return new ArchAMD64();
                }
            }
            return null;
        }

        private SectionHeaderEntry readSectionHeaderEntry() throws IOException {
            long l = (long)this.readInt() & 0xFFFFFFFFL;
            long l2 = (long)this.readInt() & 0xFFFFFFFFL;
            long l3 = this.readElfWord();
            long l4 = this.readElfWord();
            long l5 = this.readElfWord();
            long l6 = this.readElfWord();
            long l7 = (long)this.readInt() & 0xFFFFFFFFL;
            long l8 = (long)this.readInt() & 0xFFFFFFFFL;
            return new SectionHeaderEntry(l, l2, l3, l4, l5, l6, l7, l8);
        }

        private void readSectionHeader() throws IOException {
            for (int i = 0; i < this._sectionHeaderCount; ++i) {
                this.seek(this._sectionHeaderOffset + (long)(i * this._sectionHeaderEntrySize));
                SectionHeaderEntry sectionHeaderEntry = this.readSectionHeaderEntry();
                this._sectionHeaderEntries.add(sectionHeaderEntry);
            }
        }

        private void readProgramHeader() throws IOException {
            for (int i = 0; i < this._programHeaderCount; ++i) {
                this.seek(this._programHeaderOffset + (long)(i * this._programHeaderEntrySize));
                this._programHeaderEntries.add(this.readProgramHeaderEntry());
            }
            for (ProgramHeaderEntry programHeaderEntry : this._programHeaderEntries) {
                if (!programHeaderEntry.isNote()) continue;
                this.readNotes(programHeaderEntry);
            }
        }

        private void readNotes(ProgramHeaderEntry programHeaderEntry) throws IOException {
            long l = programHeaderEntry.fileOffset;
            long l2 = l + programHeaderEntry.fileSize;
            while (l < l2) {
                l = this.readNote(l);
            }
        }

        private long readNote(long l) throws IOException {
            this.seek(l);
            long l2 = this.padToWordBoundary(this.readInt());
            long l3 = this.readInt();
            long l4 = this.readInt();
            this.readBytes((int)l2);
            long l5 = l + 12L + l2;
            if (1L == l4) {
                this.addThreadEntry(l5, l3);
            } else if (3L == l4) {
                this.addProcessEntry(l5, l3);
            } else if (6L == l4) {
                this.addAuxiliaryVectorEntry(l5, l3);
            }
            return l5 + this.padToWordBoundary(l3);
        }

        protected void addProcessEntry(long l, long l2) {
            this._processEntries.add(new DataEntry(l, l2));
        }

        protected void addThreadEntry(long l, long l2) {
            this._threadEntries.add(new DataEntry(l, l2));
        }

        private void addAuxiliaryVectorEntry(long l, long l2) {
            this._auxiliaryVectorEntries.add(new DataEntry(l, l2));
        }

        protected byte readByte() throws IOException {
            return this._reader.readByte();
        }

        protected byte[] readBytes(int n) throws IOException {
            return this._reader.readBytes(n);
        }

        protected int readInt() throws IOException {
            return this._reader.readInt();
        }

        protected long readLong() throws IOException {
            return this._reader.readLong();
        }

        protected short readShort() throws IOException {
            return this._reader.readShort();
        }

        protected void seek(long l) throws IOException {
            this._reader.seek(l);
        }

        long readUID() throws IOException {
            return this._arch.readUID(this);
        }

        Address getStackPointerFrom(Map map) {
            return this._arch.getStackPointerFrom(map);
        }

        Address getBasePointerFrom(Map map) {
            return this._arch.getBasePointerFrom(map);
        }

        Address getInstructionPointerFrom(Map map) {
            return this._arch.getInstructionPointerFrom(map);
        }

        Address getLinkRegisterFrom(Map map) {
            return this._arch.getLinkRegisterFrom(map);
        }

        Map readRegisters(Builder builder, Object object) throws IOException {
            return this._arch.readRegisters(this, builder, object);
        }

        abstract Iterator readSymbolsAt(SectionHeaderEntry var1) throws IOException;

        abstract int addressSize();

        public Properties getProperties() {
            Properties properties = new Properties();
            properties.setProperty("Object file type", this._nameForFileType(this._objectType));
            properties.setProperty("Object file version", Integer.toHexString(this._version));
            properties.setProperty("Processor-specific flags", Integer.toHexString(this._e_flags));
            return properties;
        }

        private String _nameForFileType(short s) {
            String string = "Unknown";
            int n = 0xFFFF & s;
            if (0 == s) {
                string = "No file type";
            } else if (1 == s) {
                string = "Relocatable file";
            } else if (2 == s) {
                string = "Executable file";
            } else if (3 == s) {
                string = "Shared object file";
            } else if (4 == s) {
                string = "Core file";
            } else if (5 == s) {
                string = "Number of defined types";
            } else if (65024 <= n && n <= 65279) {
                string = "OS-specific (" + Integer.toHexString(n) + ")";
            } else if (65280 <= n && n <= 65535) {
                string = "Processor-specific (" + Integer.toHexString(n) + ")";
            }
            return string;
        }
    }

    private static class ProgramHeaderEntry {
        private static final int PT_DYNAMIC = 2;
        private static final int PT_NOTE = 4;
        private static final int PF_X = 1;
        private static final int PF_W = 2;
        private int _type;
        final long fileOffset;
        final long fileSize;
        final long virtualAddress;
        final long memorySize;
        private int _flags;

        ProgramHeaderEntry(int n, long l, long l2, long l3, long l4, long l5, int n2, long l6) {
            this._type = n;
            this.fileOffset = l;
            this.fileSize = l2;
            this.virtualAddress = l3;
            this.memorySize = l5;
            this._flags = n2;
        }

        boolean isEmpty() {
            return 0L == this.memorySize;
        }

        boolean isDynamic() {
            return 2 == this._type;
        }

        boolean isNote() {
            return 4 == this._type;
        }

        MemoryRange asMemoryRange() {
            boolean bl = (this._flags & 2) != 0;
            boolean bl2 = (this._flags & 1) != 0;
            return new MemoryRange(this.virtualAddress, this.fileOffset, this.memorySize, 0, false, !bl, bl2);
        }

        boolean contains(long l) {
            return false == this.isEmpty() && this.virtualAddress <= l && l < this.virtualAddress + this.memorySize;
        }
    }

    private static class SectionHeaderEntry {
        private static final int SHT_SYMTAB = 2;
        private static final int SHT_DYNSYM = 11;
        private long _name;
        private long _type;
        final long offset;
        final long size;
        final long link;

        SectionHeaderEntry(long l, long l2, long l3, long l4, long l5, long l6, long l7, long l8) {
            this._name = l;
            this._type = l2;
            this.offset = l5;
            this.size = l6;
            this.link = l7;
        }

        boolean isSymbolTable() {
            return 2L == this._type || 11L == this._type;
        }
    }

    private static class Symbol {
        private static final byte STT_FUNC = 2;
        private static final byte ST_TYPE_MASK = 15;
        final long name;
        final long value;
        private byte _info;

        Symbol(long l, long l2, long l3, byte by, byte by2, int n) {
            this.name = l;
            this.value = l2;
            this._info = by;
        }

        boolean isFunction() {
            return 2 == (this._info & 0xF);
        }
    }

    private static class DataEntry {
        final long offset;
        final long size;

        DataEntry(long l, long l2) {
            this.offset = l;
            this.size = l2;
        }
    }

    private static class ArchAMD64
    implements Arch {
        private ArchAMD64() {
        }

        public Map readRegisters(ElfFile elfFile, Builder builder, Object object) throws IOException {
            int n;
            String[] stringArray = new String[]{"r15", "r14", "r13", "r12", "rbp", "rbx", "r11", "r10", "r9", "r8", "rax", "rcx", "rdx", "rsi", "rdi"};
            String[] stringArray2 = new String[]{"rip", "cs", "eflags", "rsp", "ss", "fs_base", "gs_base", "ds", "es", "fs", "gs"};
            TreeMap<String, Address64> treeMap = new TreeMap<String, Address64>();
            for (n = 0; n < stringArray.length; ++n) {
                treeMap.put(stringArray[n], new Address64(elfFile.readLong()));
            }
            elfFile.readLong();
            for (n = 0; n < stringArray2.length; ++n) {
                treeMap.put(stringArray2[n], new Address64(elfFile.readLong()));
            }
            return treeMap;
        }

        public Address getStackPointerFrom(Map map) {
            return (Address)map.get("rsp");
        }

        public Address getBasePointerFrom(Map map) {
            return (Address)map.get("rbp");
        }

        public Address getInstructionPointerFrom(Map map) {
            return (Address)map.get("rip");
        }

        public Address getLinkRegisterFrom(Map map) {
            return new Address64(0L);
        }

        public long readUID(ElfFile elfFile) throws IOException {
            return (long)elfFile.readInt() & 0xFFFFFFFFL;
        }
    }

    private static class ArchIA64
    implements Arch {
        private ArchIA64() {
        }

        public Map readRegisters(ElfFile elfFile, Builder builder, Object object) throws IOException {
            for (int i = 0; i < 32; ++i) {
                elfFile.readLong();
            }
            TreeMap<String, Address64> treeMap = new TreeMap<String, Address64>();
            treeMap.put("nat", new Address64(elfFile.readLong()));
            treeMap.put("pr", new Address64(elfFile.readLong()));
            for (int i = 0; i < 8; ++i) {
                elfFile.readLong();
            }
            String[] stringArray = new String[]{"ip", "cfm", "psr", "rsc", "bsp", "bspstore", "rnat", "ccv", "unat", "fpsr", "pfs", "lc", "ec"};
            for (int i = 0; i < stringArray.length; ++i) {
                treeMap.put(stringArray[i], new Address64(elfFile.readLong()));
            }
            return treeMap;
        }

        public Address getStackPointerFrom(Map map) {
            return new Address64(0L);
        }

        public Address getBasePointerFrom(Map map) {
            return new Address64(0L);
        }

        public Address getInstructionPointerFrom(Map map) {
            return new Address64(0L);
        }

        public Address getLinkRegisterFrom(Map map) {
            return new Address64(0L);
        }

        public long readUID(ElfFile elfFile) throws IOException {
            return (long)elfFile.readInt() & 0xFFFFFFFFL;
        }
    }

    private static class ArchIA32
    implements Arch {
        private ArchIA32() {
        }

        public Map readRegisters(ElfFile elfFile, Builder builder, Object object) throws IOException {
            int n;
            String[] stringArray = new String[]{"ebx", "ecx", "edx", "esi", "edi", "ebp", "eax", "ds", "es", "fs", "gs"};
            String[] stringArray2 = new String[]{"eip", "cs", "efl", "esp", "ss"};
            TreeMap<String, Address32> treeMap = new TreeMap<String, Address32>();
            for (n = 0; n < stringArray.length; ++n) {
                treeMap.put(stringArray[n], new Address32(elfFile.readInt()));
            }
            elfFile.readInt();
            for (n = 0; n < stringArray2.length; ++n) {
                treeMap.put(stringArray2[n], new Address32(elfFile.readInt()));
            }
            return treeMap;
        }

        public Address getStackPointerFrom(Map map) {
            return (Address)map.get("esp");
        }

        public Address getBasePointerFrom(Map map) {
            return (Address)map.get("ebp");
        }

        public Address getInstructionPointerFrom(Map map) {
            return (Address)map.get("eip");
        }

        public Address getLinkRegisterFrom(Map map) {
            return new Address32(0);
        }

        public long readUID(ElfFile elfFile) throws IOException {
            return (long)elfFile.readShort() & 0xFFFFL;
        }
    }

    private static class ArchS390_32
    extends ArchS390 {
        private ArchS390_32() {
        }

        public Map readRegisters(ElfFile elfFile, Builder builder, Object object) throws IOException {
            Map map = super.readRegisters(elfFile, builder, object);
            map.put("old_ilc", elfFile.readElfWordAsAddress());
            return map;
        }

        public long readUID(ElfFile elfFile) throws IOException {
            return (long)elfFile.readShort() & 0xFFFFL;
        }
    }

    private static class ArchS390
    implements Arch {
        private ArchS390() {
        }

        public Map readRegisters(ElfFile elfFile, Builder builder, Object object) throws IOException {
            int n;
            TreeMap<String, Address> treeMap = new TreeMap<String, Address>();
            treeMap.put("mask", elfFile.readElfWordAsAddress());
            treeMap.put("addr", elfFile.readElfWordAsAddress());
            for (n = 0; n < 16; ++n) {
                treeMap.put("gpr" + n, elfFile.readElfWordAsAddress());
            }
            for (n = 0; n < 16; ++n) {
                treeMap.put("acr" + n, elfFile.readElfWordAsAddress());
            }
            treeMap.put("origgpr2", elfFile.readElfWordAsAddress());
            treeMap.put("trap", elfFile.readElfWordAsAddress());
            return treeMap;
        }

        public Address getStackPointerFrom(Map map) {
            return (Address)map.get("gpr15");
        }

        public Address getBasePointerFrom(Map map) {
            return this.getStackPointerFrom(map);
        }

        public Address getInstructionPointerFrom(Map map) {
            return (Address)map.get("addr");
        }

        public Address getLinkRegisterFrom(Map map) {
            return this.nil(map);
        }

        public long readUID(ElfFile elfFile) throws IOException {
            return (long)elfFile.readInt() & 0xFFFFFFFFL;
        }

        private Address nil(Map map) {
            Address address = (Address)map.get("gpr15");
            return address.nil();
        }
    }

    private static class ArchPPC
    implements Arch {
        private ArchPPC() {
        }

        public Map readRegisters(ElfFile elfFile, Builder builder, Object object) throws IOException {
            TreeMap<String, Address> treeMap = new TreeMap<String, Address>();
            for (int i = 0; i < 32; ++i) {
                treeMap.put("gpr" + i, elfFile.readElfWordAsAddress());
            }
            String[] stringArray = new String[]{"nat", "pr", "ip", "cfm", "psr", "rsc", "bsp", "bspstore", "rnat", "ccv", "unat", "fpsr", "pfs", "lc", "ec", "fpvalid"};
            for (int i = 0; i < stringArray.length; ++i) {
                treeMap.put(stringArray[i], elfFile.readElfWordAsAddress());
            }
            return treeMap;
        }

        public Address getStackPointerFrom(Map map) {
            return (Address)map.get("gpr1");
        }

        public Address getBasePointerFrom(Map map) {
            return this.getStackPointerFrom(map);
        }

        public Address getInstructionPointerFrom(Map map) {
            return (Address)map.get("nat");
        }

        public Address getLinkRegisterFrom(Map map) {
            return (Address)map.get("psr");
        }

        public long readUID(ElfFile elfFile) throws IOException {
            return (long)elfFile.readInt() & 0xFFFFFFFFL;
        }
    }

    private static interface Arch {
        public Map readRegisters(ElfFile var1, Builder var2, Object var3) throws IOException;

        public long readUID(ElfFile var1) throws IOException;

        public Address getStackPointerFrom(Map var1);

        public Address getBasePointerFrom(Map var1);

        public Address getInstructionPointerFrom(Map var1);

        public Address getLinkRegisterFrom(Map var1);
    }

    private static class Address64
    extends Address {
        Address64(long l) {
            super(l);
        }

        Address add(long l) {
            return new Address64(this.getValue() + l);
        }

        Number asNumber() {
            return new Long(this.getValue());
        }

        Address nil() {
            return new Address64(0L);
        }
    }

    private static class Address32
    extends Address {
        Address32(int n) {
            super((long)n & 0xFFFFFFFFL);
        }

        Address add(long l) {
            long l2 = this.getValue() + l;
            return new Address32((int)l2);
        }

        Number asNumber() {
            return new Integer((int)this.getValue());
        }

        Address nil() {
            return new Address32(0);
        }
    }

    private static abstract class Address {
        private long _value;

        private Address(long l) {
            this._value = l;
        }

        long getValue() {
            return this._value;
        }

        abstract Address add(long var1);

        boolean isNil() {
            return 0L == this.getValue();
        }

        abstract Number asNumber();

        abstract Address nil();
    }
}

