/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.addressspace;

import com.ibm.dtfj.addressspace.CommonAddressSpace;
import com.ibm.dtfj.corereaders.DumpReader;
import com.ibm.dtfj.corereaders.MemoryAccessException;
import com.ibm.dtfj.corereaders.MemoryRange;
import java.io.IOException;
import java.util.Iterator;

public class DumpReaderAddressSpace
extends CommonAddressSpace {
    private DumpReader _reader;

    public DumpReaderAddressSpace(MemoryRange[] memoryRangeArray, DumpReader dumpReader, boolean bl, boolean bl2) {
        super(memoryRangeArray, false, bl2);
        this._reader = dumpReader;
    }

    public boolean isExecutable(int n, long l) throws MemoryAccessException {
        return false;
    }

    public boolean isReadOnly(int n, long l) throws MemoryAccessException {
        return false;
    }

    public boolean isShared(int n, long l) throws MemoryAccessException {
        return false;
    }

    protected long _translateAddress(int n, long l) throws MemoryAccessException {
        MemoryRange memoryRange = null;
        Iterator iterator = this.getMemoryRanges();
        while (null == memoryRange && iterator.hasNext()) {
            MemoryRange memoryRange2 = (MemoryRange)iterator.next();
            if (!memoryRange2.contains(l)) continue;
            memoryRange = memoryRange2;
        }
        if (null != memoryRange) {
            return memoryRange.getFileOffset() + (l - memoryRange.getVirtualAddress());
        }
        throw new MemoryAccessException(n, l);
    }

    public int getBytesAt(int n, long l, byte[] byArray) throws MemoryAccessException {
        long l2 = this._translateAddress(n, l);
        try {
            this._reader.seek(l2);
            byte[] byArray2 = this._reader.readBytes(byArray.length);
            System.arraycopy(byArray2, 0, byArray, 0, byArray2.length);
            return byArray2.length;
        }
        catch (IOException iOException) {
            throw new MemoryAccessException(n, l);
        }
    }

    public long getLongAt(int n, long l) throws MemoryAccessException {
        long l2 = this._translateAddress(n, l);
        try {
            this._reader.seek(l2);
            return this._reader.readLong();
        }
        catch (IOException iOException) {
            throw new MemoryAccessException(n, l);
        }
    }

    public int getIntAt(int n, long l) throws MemoryAccessException {
        long l2 = this._translateAddress(n, l);
        try {
            this._reader.seek(l2);
            return this._reader.readInt();
        }
        catch (IOException iOException) {
            throw new MemoryAccessException(n, l);
        }
    }

    public short getShortAt(int n, long l) throws MemoryAccessException {
        long l2 = this._translateAddress(n, l);
        try {
            this._reader.seek(l2);
            return this._reader.readShort();
        }
        catch (IOException iOException) {
            throw new MemoryAccessException(n, l);
        }
    }

    public byte getByteAt(int n, long l) throws MemoryAccessException {
        long l2 = this._translateAddress(n, l);
        try {
            this._reader.seek(l2);
            return this._reader.readByte();
        }
        catch (IOException iOException) {
            throw new MemoryAccessException(n, l);
        }
    }

    public long getPointerAt(int n, long l) throws MemoryAccessException {
        long l2 = this._translateAddress(n, l);
        try {
            this._reader.seek(l2);
            return this._reader.readAddress();
        }
        catch (IOException iOException) {
            throw new MemoryAccessException(n, l);
        }
    }
}

