package com.ibm.oti.vm;

/**
 * This class models C pointers.
 *
 * <pre>
 * Licensed Materials - Property of IBM
 * (c) Copyright IBM Corp. 1999, 2004  All Rights Reserved
 * US Government Users Restricted Rights - Use, duplication or disclosure
 * restricted by GSA ADP Schedule Contract with IBM Corp.
 * </pre>
 */
class JxeResource {
	private long    pointer;
	private int     size;
	private int     method;

/**
 * Answer a new OSMemory with the given pointer and size.
 */
JxeResource(long pointer, int size, int method) {
	if (pointer == 0 || size < 0)
		throw new IllegalArgumentException();

	this.pointer   = pointer;
	this.size      = size;
	this.method    = method;
}

/**
 * Answer the pointer.
 */
public long getPointer() {
	return pointer;
}

/**
 * Answer the size.
 */
public int getSize() {
	return size;
}

/**
 * Answer the compression method.
 */
public int getMethod() {
	return method;
}

}
