package com.ibm.oti.vm;

/**
 * <p>This class is the exception thrown when errors occur dealing with jxes.
 *
 * <pre>
 * Licensed Materials - Property of IBM
 * (c) Copyright IBM Corp. 1999, 2004  All Rights Reserved
 * US Government Users Restricted Rights - Use, duplication or disclosure
 * restricted by GSA ADP Schedule Contract with IBM Corp.
 * </pre>
 */
public class JxeException extends Exception {

/**
 * Create a new instance of this type.
 *
 * <pre>(c) Copyright IBM Corp 1999</pre>
 */
static public JxeException jxeExceptionFromRelocationReturnCode(int relocationMessageNumber) {
	return new JxeException(JxeUtil.getRelocationMessage(relocationMessageNumber));
}

/**
 * Create a new instance of this type.
 *
 * <pre>(c) Copyright IBM Corp 1999</pre>
 */
public JxeException() {
	super();
}

/**
 * Create a new instance of this type.
 *
 * <pre>(c) Copyright IBM Corp 1999</pre>
 */
public JxeException(String message) {
	super(message);
}

}
