/*
 * @(#)src/tools/pfm/java_md.c, tool, an32142, 20050307 1.2.21.3
 * ===========================================================================
 * Licensed Materials - Property of IBM
 * "Restricted Materials of IBM"
 *
 * IBM SDK, Java(tm) 2 Technology Edition, v1.4.1
 * (C) Copyright IBM Corp. 1998, 2003. All Rights Reserved
 *
 * US Government Users Restricted Rights - Use, duplication or disclosure
 * restricted by GSA ADP Schedule Contract with IBM Corp.
 * ===========================================================================
 */

/*
 * ===========================================================================
 * Copyright 2002 Sun Microsystems, Inc. All rights reserved.
 * ===========================================================================
 */



/*
 * ===========================================================================
 * Change activity:
 *
 * Reason  Date   Origin  Description
 * ------  ----   ------  ----------------------------------------------------
 *   5827  250100 hdece:  Registry key should be 1.3
 * 006553  030300 hdmkv:  Use /DRELEASE for dot release determination
 * 033324  180601 hdajc:  Use full version release for registry key
 *  41302  040302 kwb     Globalize the java launcher
 *  55562  260902 kwb     Map zh_HK and zh_MO to zh_TW
 * 57944.1 270103 smithwil Map default console.encoding to Cp850 ascii
 * 57204   150103 websterm Sidecar launcher
 * 60769   010503 corbin  Fix up ConverterMap for other languages
 * 66874.1 291203 corbin  Change default convertermap
 * 67672   140104 corbin  Improve change made by 66874.1
 * 67741   100502 mbluemel PCR616 - PD Build support
 * 71326   230604 pratunga  Produce correct -X usage text for J9
 * 79867   211204 pratunga Produce -X help text of j9 for sidecar builds
 *
 * ===========================================================================
 * Module Information:
 *
 * DESCRIPTION: Platform dependent routines for java tool
 *
 * ===========================================================================
 */


#include <windows.h>
#include <stdlib.h>
#include <stdio.h>
#include <io.h>
#include <sys/types.h>
#include <sys/stat.h>

#include <jni.h>
#include "java.h"

#if defined(IBM_BUILD_TYPE_dev)                                       /*ibm.49*/
  #define JVM_DLL "jvm.dll"                                           /*ibm@67741*/
  #define JAVA_DLL "java.dll"                                         /*ibm@67741*/
#elif defined(IBM_BUILD_TYPE_col)                                     /*ibm.49*/
  #define JVM_DLL "jvm_g.dll"
  #define JAVA_DLL "java_g.dll"
#else                                                                 /*ibm.49*/
  #define JVM_DLL "jvm.dll"
  #define JAVA_DLL "java.dll"
#endif                                                                /*ibm.49*/

/*
 * Prototypes.
 */
static jboolean
GetPublicJREHome(char *path, jint pathsize);
void __cdecl _setargv(void);                                        /*ibm@1369*/

/* start ibm@1369
 * Expand any wildcards in the command line
 */
void
ExpandCommandLineArgs(void)
{
    _setargv();
}
/* end ibm@1369 */


typedef struct {
    unsigned short  cpID;
    char *  encName;
} convmap_t;

static convmap_t converterMap[] = {
    874,  "MS874",    // Thai
    932,  "MS932",    // Japanese
    936,  "MS936",    // Chinese (Simplified)
    949,  "MS949",    // Korean
    950,  "MS950",    // Chinese (Traditional)
    54936,"GB18030",  // Chinese (GB18030)
    65001,"UTF8",     // Unicode
    852,  "Cp852",    // Czech, Hungarian, Slovakian  //ibm.60769
    857,  "Cp857",    // Turkey                       //ibm.60769
    866,  "Cp866",    // Russian                      //ibm.60769
    0,    "Cp%d",    // Default  ibm@57944.1         //ibm.67672
};

/*
 * Add the console.encoding option
 */
void SetConsoleEncoding(void) {
    char opt [64], *op;
    int  cp;
    convmap_t * tp;

    strcpy(opt, "-Dconsole.encoding=");
    op = opt+strlen(opt);
    cp = GetConsoleCP();
    if (cp==0) {   //ibm.67672
        cp=850;    //ibm.67672
    }              //ibm.67672
    tp = converterMap;
    while (tp->cpID) {
        if (tp->cpID==cp)
            break;
        tp++;
    }
    sprintf(op, tp->encName, cp);
    AddOption(strdup(opt), NULL);
}


/*
 * Load JVM of "jvmtype", and intialize the invocation functions.  Notice that
 * if jvmtype is NULL, we try to load hotspot VM as the default.  Maybe we
 * need an environment variable that dictates the choice of default VM.
 */
jboolean
LoadJavaVM(char *jvmtype, InvocationFunctions *ifn)
{
    char home[MAXPATHLEN], javadll[MAXPATHLEN], jvmdll[MAXPATHLEN];
    HINSTANCE handle;
    struct stat s;
    char *pdOrNot;
    /* Is JRE co-located with the application? */
    if (GetApplicationHome(home, sizeof(home))) {
        sprintf(javadll, "%s\\bin\\" JAVA_DLL, home);
        if (stat(javadll, &s) == 0)
            goto jrefound;
    }

    /* Does this app ship a private JRE in <apphome>\jre directory? */
    sprintf(javadll, "%s\\jre\\bin\\" JAVA_DLL, home);
    if (stat(javadll, &s) == 0) {
        strcat(home, "\\jre");
        goto jrefound;
    }

    /* Look for a public JRE on this machine. */
    if (!GetPublicJREHome(home, sizeof(home))) {
        showMessage(stderr, "No.public.JRE", NULL, NULL, 0);
        return JNI_FALSE;
    }

    /* Now we know where JRE is -- the value in the "home" variable. */
jrefound:

    /*ibm@67741 starts*/
    if (strcmp(jvmtype,"sovPd") == 0) {
        pdOrNot = "\\pd";
        jvmtype = "classic";
    } else {
        pdOrNot = "";
    }
    /*ibm67741 ends*/

    /* Try to load J9 JVM. */
    /* actually, jvmtype is always set by caller, so we look for J9 or classic */
    /*ibm@57204*/
    if (jvmtype != NULL) {
        sprintf(jvmdll, "%s%s\\bin\\%s\\" JVM_DLL, home, pdOrNot, jvmtype);   /*ibm@67741 */
        if (0 != stat(jvmdll, &s))
            jvmtype = NULL;
    }

    /* Determine if Hotspot VM is installed. */
    if (jvmtype == NULL) {
        sprintf(jvmdll, "%s%s\\bin\\classic\\" JVM_DLL, home, pdOrNot);       /*ibm@67741*/
        if (!stat(jvmdll, &s))
            jvmtype = "classic";
    }

    /* We now know what jvmtype should be */
    if (jvmtype)
        sprintf(jvmdll, "%s%s\\bin\\%s\\" JVM_DLL, home, pdOrNot, jvmtype);
    else
        sprintf(jvmdll, "%s%s\\bin\\" JVM_DLL, home, pdOrNot);
    if (debug) {
        printf("Path to JVM is %s\n", jvmdll);
    }

    /* Load the Java VM DLL */
    if ((handle = LoadLibrary(jvmdll)) == 0) {
        showMessage(stderr, "Error.loading", c2jc(jvmdll), NULL, 0);
        return JNI_FALSE;
    }

    /* Now get the function addresses */
    ifn->CreateJavaVM =
        (void *)GetProcAddress(handle, "JNI_CreateJavaVM");
    ifn->GetDefaultJavaVMInitArgs =
        (void *)GetProcAddress(handle, "JNI_GetDefaultJavaVMInitArgs");
/*ibm@71326 start*/
    if (strcmp(jvmtype,"j9vm") == 0) {                       /*ibm@79867*/
    ifn->GetXUsage =
        (void *)GetProcAddress(handle, "GetXUsage");
    }
/*ibm@71326 end*/
    if (ifn->CreateJavaVM == 0 ||
        ifn->GetDefaultJavaVMInitArgs == 0) {
        showMessage(stderr, "JNI.interfaces.not.found", c2jc(jvmdll), NULL, 0);
        return JNI_FALSE;
    }

#ifndef JAVAW
    /*
     * Set the encoding to use for the console.  Do not do this for the
     * javaw which will run in the ANSI codepage.
     */
    SetConsoleEncoding();
#endif

    return JNI_TRUE;
}

/*
 * Get the path to the file that has the usage message for -X options.
 */
void
GetXUsagePath(char *buf, jint bufsize)
{
    GetModuleFileName(GetModuleHandle(JVM_DLL), buf, bufsize);
    *(strrchr(buf, '\\')) = '\0';
    strcat(buf, "\\Xusage.txt");
}

/*
 * If app is "c:\foo\bin\javac", then put "c:\foo" into buf.
 */
jboolean
GetApplicationHome(char *buf, jint bufsize)
{
    char *cp;
    GetModuleFileName(0, buf, bufsize);
    *strrchr(buf, '\\') = '\0'; /* remove .exe file name */
    if ((cp = strrchr(buf, '\\')) == 0) {
        /* This happens if the application is in a drive root, and
         * there is no bin directory. */
        buf[0] = '\0';
        return JNI_FALSE;
    }
    *cp = '\0';  /* remove the bin\ part */
    return JNI_TRUE;
}

#ifdef JAVAW
__declspec(dllimport) char **__initenv;

int WINAPI
WinMain(HINSTANCE inst, HINSTANCE previnst, LPSTR cmdline, int cmdshow)
{
    __initenv = _environ;
    return main(__argc, __argv);
}
#endif

/*
 * Helpers to look in the registry for a public JRE.
 */
#define JRE_KEY     "Software\\IBM\\Java2 Runtime Environment"       /*ibm@613*/

static jboolean
GetStringFromRegistry(HKEY key, const char *name, char *buf, jint bufsize)
{
    DWORD type, size;

    if (RegQueryValueEx(key, name, 0, &type, 0, &size) == 0
        && type == REG_SZ
        && (size < (unsigned int)bufsize)) {
        if (RegQueryValueEx(key, name, 0, 0, buf, &size) == 0) {
            return JNI_TRUE;
        }
    }
    return JNI_FALSE;
}

static jboolean
GetPublicJREHome(char *buf, jint bufsize)
{
    HKEY key, subkey;
    char version[MAXPATHLEN];
    char dotrelease[MAXPATHLEN];                                    /*ibm@6553*/

    /*
     * Determine our current version & releaase from the RELEASE macro  ibm@6553
     * defined at build time. We want <version>.<release> eg 1.3        ibm@6553
     */

    strcpy(dotrelease,RELEASE);       /* Initialise string            ibm@6553*/

    /* Find the current version of the JRE */
    if (RegOpenKeyEx(HKEY_LOCAL_MACHINE, JRE_KEY, 0, KEY_READ, &key) != 0) {
        if (debug) {
            fprintf(stderr, "Error opening registry key '" JRE_KEY "'\n");
        }
        return JNI_FALSE;
    }

    if (!GetStringFromRegistry(key, "CurrentVersion",
                               version, sizeof(version))) {
        if (debug) {
            fprintf(stderr, "Failed reading value of registry key:\n\t"
                JRE_KEY "\\CurrentVersion\n");
        }
        RegCloseKey(key);
        return JNI_FALSE;
    }

    if (strcmp(version, dotrelease) != 0) {                         /*ibm@6553*/
        if (debug) {
            fprintf(stderr, "Registry key '" JRE_KEY "\\CurrentVersion'\nhas "
            "value '%s', but '%s' is required.\n",version,dotrelease); /*ibm@6553*/
        }
        RegCloseKey(key);
        return JNI_FALSE;
    }

    /* Find directory where the current version is installed. */
    if (RegOpenKeyEx(key, version, 0, KEY_READ, &subkey) != 0) {
        if (debug) {
            fprintf(stderr, "Error opening registry key '"
               JRE_KEY "\\%s'\n", version);
        }
        RegCloseKey(key);
        return JNI_FALSE;
    }

    if (!GetStringFromRegistry(subkey, "JavaHome", buf, bufsize)) {
        if (debug) {
            fprintf(stderr, "Failed reading value of registry key:\n\t"
                JRE_KEY "\\%s\\JavaHome\n", version);
        }
        RegCloseKey(key);
        RegCloseKey(subkey);
        return JNI_FALSE;
    }

    if (debug) {
        char micro[MAXPATHLEN];
        if (!GetStringFromRegistry(subkey, "MicroVersion", micro,
                                   sizeof(micro))) {
            printf("Warning: Can't read MicroVersion\n");
            micro[0] = '\0';
        }
        printf("Version major.minor.micro = %s.%s\n", version, micro);
    }

    RegCloseKey(key);
    RegCloseKey(subkey);
    return JNI_TRUE;
}

/*
 * Support for doing cheap, accurate interval timing.
 */
static jboolean counterAvailable = JNI_FALSE;
static jboolean counterInitialized = JNI_FALSE;
static LARGE_INTEGER counterFrequency;

jlong CounterGet()
{
    LARGE_INTEGER count;

    if (!counterInitialized) {
        counterAvailable = QueryPerformanceFrequency(&counterFrequency);
        counterInitialized = JNI_TRUE;
    }
    if (!counterAvailable) {
        return 0;
    }
    QueryPerformanceCounter(&count);
    return (jlong)(count.QuadPart);
}

jlong Counter2Micros(jlong counts)
{
    if (!counterAvailable || !counterInitialized) {
        return 0;
    }
    return (counts * 1000 * 1000)/counterFrequency.QuadPart;
}

/*
 * Get the full platform name for the specified file
 */
char * PlatformName(char * in, char * * cpath) {
    *cpath = ".";
    if (in[0]=='\\' || in[0]=='/' || (*in && in[1]==':')) {
        char nbuf[512];
        char * nptr;
        if (GetFullPathName(in, 512, nbuf, &nptr)) {
            char * out = strdup(nbuf);
            out[nptr-nbuf-1] = 0;
            *cpath = out;
            return out+(nptr-nbuf);
        }
    }
    return in;
}


/*
 * Show a Unicode string in the console encoding.
 */
void ShowUnicode(FILE * f, jchar * str, int len) {
    char * buf;

    buf = malloc(len*3);
    len = WideCharToMultiByte(GetConsoleCP(), 0, (LPCWSTR)str, len,
         (LPSTR)buf, len*3, NULL, NULL);
    fwrite(buf, len, 1, f);
    free(buf);
}


/*
 * Get the message file for this locale
 */
char * GetMessageFile(char *buf, int bufsize) {
    char * cp;
    LCID   lcid;
    char   langname[4];    /* allow for 3 char language */
    char   ctryname[4];

    /* Get the directory one up from that containing the jvm.dll */
    GetModuleFileName(GetModuleHandle(JVM_DLL), buf, bufsize);
    *(strrchr(buf, '\\')) = 0;      /* Get path name          */
    cp = strrchr(buf, '\\');        /* Get previous directory */
    if (!cp) return NULL;
    if (!strcmp(cp, "\\bin"))
        cp += 4;
    strcpy(cp, "\\java_");
    cp += 6;
    if ((bufsize - (cp-buf)) < 24 ) /* Make sure we have space */
        return NULL;

    /* Get the lang and country strings (this does not work on Win95) */
    lcid = GetThreadLocale();
    GetLocaleInfo(lcid, LOCALE_SISO639LANGNAME,  langname, 4);
    GetLocaleInfo(lcid, LOCALE_SISO3166CTRYNAME, ctryname, 4);

    /* Try for java_ll_CC.properties */
    if (*ctryname) {
        strcpy(cp, langname);
        strcat(cp, "_");
        strcat(cp, ctryname);
        strcat(cp, ".properties");
//      printf("try 1: %s\n", buf); fflush(stdout);
        if (!access(buf, 4))
            return buf;
    }

    //ibm.55562  begin
    /* Special case to map traditional chinese */
    if (!strcmp(langname, "zh") &&
        (!strcmp(ctryname, "HK") || !strcmp(ctryname, "MO"))) {
        strcpy(cp, "zh_TW.properties");
        if (!access(buf, 4))
            return buf;
    }
    //ibm.55562  end

    /* Try for java_ll.properties */
    if (*langname) {
        strcpy(cp, langname);
        strcat(cp, ".properties");
//      printf("try 2: %s\n", buf); fflush(stdout);
        if (!access(buf, 4))
            return buf;
    }

    /* Try for java.properties */
    strcpy(cp-1, ".properties");
//  printf("try 3: %s\n", buf); fflush(stdout);
    if (!access(buf, 4))
        return buf;

    return 0;
}
/* ibm.78068 start */
#ifdef JIT_TOY_REPLAY
#include "java_win_replay.inc"
#endif
/* ibm.78068 end */
