/*
 * @(#)src/classes/sov/javax/swing/plaf/PopupMenuUI.java, swing, as142, 20050517 1.12.2.1
 * ===========================================================================
 * Licensed Materials - Property of IBM
 * "Restricted Materials of IBM"
 *
 * IBM SDK, Java(tm) 2 Technology Edition, v1.4.2
 * (C) Copyright IBM Corp. 2003, 2004. All Rights Reserved
 * ===========================================================================
 */

/*
 * ===========================================================================
 * Copyright 2003 Sun Microsystems, Inc. All rights reserved.
 * ===========================================================================
 */
/* 
 *
 * Change activity:
 *
 * Reason  Date   Origin    Description
 * ------  ----   ------    -------------------------------------------------- 
 * 63757  050903 slattery  Add IBM module header; 
 *
 * ===========================================================================
 * Module Information:
 * 
 * DESCRIPTION: IBM.WRITEME
 * ===========================================================================
 */

/*
 * @(#)PopupMenuUI.java	1.15 03/01/23
 *
 */

package javax.swing.plaf;

import java.awt.event.MouseEvent;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.JPopupMenu;

/**
 * Pluggable look and feel interface for JPopupMenu.
 *
 * @version 1.15 01/23/03
 * @author Georges Saab
 * @author David Karlton
 */

public abstract class PopupMenuUI extends ComponentUI {
    /** 
     * @since 1.3
     */
    public boolean isPopupTrigger(MouseEvent e) {
	return e.isPopupTrigger();
    }

    /**
     * Returns the <code>Popup</code> that will be responsible for
     * displaying the <code>JPopupMenu</code>.
     *
     * @param popup JPopupMenu requesting Popup
     * @param x     Screen x location Popup is to be shown at
     * @param y     Screen y location Popup is to be shown at.
     * @return Popup that will show the JPopupMenu
     * @since 1.4
     */
    public Popup getPopup(JPopupMenu popup, int x, int y) {
        PopupFactory popupFactory = PopupFactory.getSharedInstance();

        return popupFactory.getPopup(popup.getInvoker(), popup, x, y);
    }
}

