/*
 * @(#)src/classes/sov/javax/swing/ComponentInputMap.java, swing, as142, 20050517 1.10.2.1
 * ===========================================================================
 * Licensed Materials - Property of IBM
 * "Restricted Materials of IBM"
 *
 * IBM SDK, Java(tm) 2 Technology Edition, v1.4.2
 * (C) Copyright IBM Corp. 2003, 2004. All Rights Reserved
 * ===========================================================================
 */

/*
 * ===========================================================================
 * Copyright 2003 Sun Microsystems, Inc. All rights reserved.
 * ===========================================================================
 */
/* 
 *
 * Change activity:
 *
 * Reason  Date   Origin    Description
 * ------  ----   ------    -------------------------------------------------- 
 * 63757  050903 slattery  Add IBM module header; 
 *
 * ===========================================================================
 * Module Information:
 * 
 * DESCRIPTION: IBM.WRITEME
 * ===========================================================================
 */

/*
 * @(#)ComponentInputMap.java	1.8 03/01/23
 *
 */
package javax.swing;

/**
 * A <code>ComponentInputMap</code> is an <code>InputMap</code>
 * associated with a particular <code>JComponent</code>.
 * The component is automatically notified whenever
 * the <code>ComponentInputMap</code> changes.
 * <code>ComponentInputMap</code>s are used for
 * <code>WHEN_IN_FOCUSED_WINDOW</code> bindings.
 *
 * @version 1.8 01/23/03
 * @author Scott Violet
 */
public class ComponentInputMap extends InputMap {
    /** Component binding is created for. */
    private JComponent          component;

    /**
     * Creates a <code>ComponentInputMap</code> associated with the 
     * specified component.  
     *
     * @param component  a non-null <code>JComponent</code>
     * @throws IllegalArgumentException  if <code>component</code> is null
     */
    public ComponentInputMap(JComponent component) {
	this.component = component;
	if (component == null) {
	    throw new IllegalArgumentException("ComponentInputMaps must be associated with a non-null JComponent");
	}
    }

    /**
     * Sets the parent, which must be a <code>ComponentInputMap</code>
     * associated with the same component as this
     * <code>ComponentInputMap</code>.
     *
     * @param map  a <code>ComponentInputMap</code>
     *           
     * @throws IllegalArgumentException  if <code>map</code>
     *         is not a <code>ComponentInputMap</code>
     *         or is not associated with the same component
     */
    public void setParent(InputMap map) {
	if (getParent() == map) {
	    return;
	}
	if (map != null && (!(map instanceof ComponentInputMap) ||
		 ((ComponentInputMap)map).getComponent() != getComponent())) {
	    throw new IllegalArgumentException("ComponentInputMaps must have a parent ComponentInputMap associated with the same component");
	}
	super.setParent(map);
	getComponent().componentInputMapChanged(this);
    }

    /**
     * Returns the component the <code>InputMap</code> was created for.
     */
    public JComponent getComponent() {
	return component;
    }

    /**
     * Adds a binding for <code>keyStroke</code> to <code>actionMapKey</code>.
     * If <code>actionMapKey</code> is null, this removes the current binding
     * for <code>keyStroke</code>.
     */
    public void put(KeyStroke keyStroke, Object actionMapKey) {
	super.put(keyStroke, actionMapKey);
	if (getComponent() != null) {
	    getComponent().componentInputMapChanged(this);
	}
    }

    /**
     * Removes the binding for <code>key</code> from this object.
     */
    public void remove(KeyStroke key) {
	super.remove(key);
	if (getComponent() != null) {
	    getComponent().componentInputMapChanged(this);
	}
    }

    /**
     * Removes all the mappings from this object.
     */
    public void clear() {
	int oldSize = size();
	super.clear();
	if (oldSize > 0 && getComponent() != null) {
	    getComponent().componentInputMapChanged(this);
	}
    }
}
