/*
 * @(#)src/classes/sov/javax/sound/midi/InvalidMidiDataException.java, audio, as142, 20050517 1.15.2.1
 * ===========================================================================
 * Licensed Materials - Property of IBM
 * "Restricted Materials of IBM"
 *
 * IBM SDK, Java(tm) 2 Technology Edition, v1.4.2
 * (C) Copyright IBM Corp. 1996, 2004. All Rights Reserved
 * ===========================================================================
 */

/*
 * ===========================================================================
 * Copyright 2003 Sun Microsystems, Inc. All rights reserved.
 * ===========================================================================
 */

/* 
 *
 * Change activity:
 *
 * Reason  Date   Origin    Description
 * ------  ----   ------    -------------------------------------------------- 
 * 064453  101003 prakashr  Add IBM module header
 *
 * ===========================================================================
 *
 */

/*
 * @(#)InvalidMidiDataException.java	1.10 03/01/23
 *
 */

package javax.sound.midi;		  


/**
 * An <code>InvalidMidiDataException</code> indicates that inappropriate MIDI 
 * data was encountered. This often means that the data is invalid in and of
 * itself, from the perspective of the MIDI specification.  An example would
 * be an undefined status byte.  However, the exception might simply
 * mean that the data was invalid in the context it was used, or that 
 * the object to which the data was given was unable to parse or use it.
 * For example, a file reader might not be able to parse a Type 2 MIDI file, even
 * though that format is defined in the MIDI specification.
 *
 * @version 1.10, 01/23/03
 * @author Kara Kytle
 */
public class InvalidMidiDataException extends Exception {

    /**
     * Constructs an <code>InvalidMidiDataException</code> with
     * <code>null</code> for its error detail message.
     */
    public InvalidMidiDataException() {

	super();
    }


    /**
     *  Constructs an <code>InvalidMidiDataException</code> with the 
     * specified detail message.
     *
     * @param message the string to display as an error detail message
     */
    public InvalidMidiDataException(String message) {

	super(message);
    }
}
