/*
 * @(#)src/classes/sov/javax/print/event/PrintServiceAttributeListener.java, print, as142, 20050517 1.6.2.1
 * ===========================================================================
 * Licensed Materials - Property of IBM
 * "Restricted Materials of IBM"
 *
 * IBM SDK, Java(tm) 2 Technology Edition, v1.4.2
 * (C) Copyright IBM Corp. 2000, 2004. All Rights Reserved
 * ===========================================================================
 */

/*
 * ===========================================================================
 * Copyright 2003 Sun Microsystems, Inc. All rights reserved.
 * ===========================================================================
 */



/* 
 *
 * Change activity:
 *
 * Reason  Date   Origin    Description
 * ------  ----   ------    -------------------------------------------------- 
 * 64632   250903 psuryana  Add IBM module header;
 *
 * ===========================================================================
 * Module Information:
 * 
 * DESCRIPTION: IBM.WRITEME
 * ===========================================================================
 */

package javax.print.event;

/** 
  * Implementations of this listener interface are attached to a
  * {@link javax.print.PrintService PrintService} to monitor
  * the status of the print service.
  * <p>
  * To monitor a particular job see {@link PrintJobListener} and
  * {@link PrintJobAttributeListener}.
  */

public interface PrintServiceAttributeListener {

    /**
     * Called to notify a listener of an event in the print service.
     * The service will call this method on an event notification thread.
     * The client should not perform lengthy processing in this callback
     * or subsequent event notifications may be blocked.
     * @param psae the event being notified
     */
    public void attributeUpdate(PrintServiceAttributeEvent psae) ;

}
