/*
 * @(#)src/classes/sov/javax/print/event/PrintJobAdapter.java, print, as142, 20050517 1.6.2.1
 * ===========================================================================
 * Licensed Materials - Property of IBM
 * "Restricted Materials of IBM"
 *
 * IBM SDK, Java(tm) 2 Technology Edition, v1.4.2
 * (C) Copyright IBM Corp. 2000, 2004. All Rights Reserved
 * ===========================================================================
 */

/*
 * ===========================================================================
 * Copyright 2003 Sun Microsystems, Inc. All rights reserved.
 * ===========================================================================
 */



/* 
 *
 * Change activity:
 *
 * Reason  Date   Origin    Description
 * ------  ----   ------    -------------------------------------------------- 
 * 64632   250903 psuryana  Add IBM module header;
 *
 * ===========================================================================
 * Module Information:
 * 
 * DESCRIPTION: IBM.WRITEME
 * ===========================================================================
 */

package javax.print.event;

/**
  * An abstract adapter class for receiving print job events.
  * The methods in this class are empty.
  * This class exists as a convenience for creating listener objects. 
  * Extend this class to create a {@link PrintJobEvent} listener and override
  * the methods for the events of interest.  Unlike the
  * {@link java.awt.event.ComponentListener ComponentListener}
  * interface, this abstract interface provides null methods so that you 
  * only need to define the methods you need, rather than all of the methods.
  *
  */

public abstract class PrintJobAdapter implements PrintJobListener {

    /**
     * Called to notify the client that data has been successfully
     * transferred to the print service, and the client may free
     * local resources allocated for that data.  The client should
     * not assume that the data has been completely printed after
     * receiving this event.
     *
     * @param pje the event being notified
     */
    public void printDataTransferCompleted(PrintJobEvent pje)  {
    }

    /** 
     * Called to notify the client that the job completed successfully.
     *
     * @param pje the event being notified
     */
    public void printJobCompleted(PrintJobEvent pje)  {
    }


    /** 
     * Called to notify the client that the job failed to complete
     * successfully and will have to be resubmitted.
     *
     * @param pje the event being notified
     */
    public void printJobFailed(PrintJobEvent pje)  {
    }

    /** 
     * Called to notify the client that the job was canceled
     * by user or program.
     *
     * @param pje the event being notified
     */
    public void printJobCanceled(PrintJobEvent pje) {
    }

 
    /** 
     * Called to notify the client that no more events will be delivered.
     * One cause of this event being generated is if the job
     * has successfully completed, but the printing system  
     * is limited in capability and cannot verify this.
     * This event is required to be delivered if none of the other
     * terminal events (completed/failed/canceled) are delivered.
     *
     * @param pje the event being notified
     */
    public void printJobNoMoreEvents(PrintJobEvent pje)  {
    }
 
 
    /** 
     * Called to notify the client that some possibly user rectifiable
     * problem occurs (eg printer out of paper).
     *
     * @param pje the event being notified
     */
    public void printJobRequiresAttention(PrintJobEvent pje)  {
    }
 
}
