/*
 * @(#)src/classes/sov/java/text/SpecialMapping.java, i18n, as142, 20050517 1.8.2.1
 * ===========================================================================
 * Licensed Materials - Property of IBM
 * "Restricted Materials of IBM"
 *
 * IBM SDK, Java(tm) 2 Technology Edition, v1.4.2
 * (C) Copyright IBM Corp. 1998, 2001. All Rights Reserved
 * ===========================================================================
 */

/*
 * ===========================================================================
 * Copyright 2003 Sun Microsystems, Inc. All rights reserved.
 * ===========================================================================
 */




package java.text;

/**
 * This class represents exceptions to the normal unicode category
 * mapping provided by Character. It is internal only.  It represents
 * a range of characters that don't follow the category mapping.
 */
final class SpecialMapping
{
    /**
     * The first character in exception range
     */
    public char startChar;
    /**
     * The last character in the exception range
     */
    public char endChar;
    /**
     * The category for characters in the range
     */
    public int newValue;

    /**
     * Construct a mapping for a single character
     * @param ch the character
     * @param newValue the new category for the character
     */
    public SpecialMapping(char ch, int newValue)
    {
        this(ch, ch, newValue);
    }

    /**
     * Construct a mapping for a range of characters
     * @param startChar the first character in the range
     * @param endChar the last character in the range
     * @param newValue the category for the range
     */
    public SpecialMapping(char startChar, char endChar, int newValue)
    {
        this.startChar = startChar;
        this.endChar = endChar;
        this.newValue = newValue;
    }
}

