/*
 * @(#)src/classes/sov/java/security/cert/CertificateExpiredException.java, security, as142, 20050517 1.7.2.2
 * ===========================================================================
 * Licensed Materials - Property of IBM
 * "Restricted Materials of IBM"
 *
 * IBM SDK, Java(tm) 2 Technology Edition, v1.4.2
 * (C) Copyright IBM Corp. 1998, 2004. All Rights Reserved
 * ===========================================================================
 */

/*
 * ===========================================================================
 * Copyright 2003 Sun Microsystems, Inc. All rights reserved.
 * ===========================================================================
 */

/* 
 * ===========================================================================
 * Change activity: 
 * 
 * Reason  Date   Origin   Description 
 * ------  ----   ------   ---------------------------------------------------
 * 076465  020804 riclau   Explicitly set serialVersionUID
 *
 * ===========================================================================
 */


package java.security.cert;

/**
 * Certificate Expired Exception. This is thrown whenever the current
 * <code>Date</code> or the specified <code>Date</code> is after the
 * <code>notAfter</code> date/time specified in the validity period
 * of the certificate.
 *
 * @author Hemma Prafullchandra
 * 1.4
 */
public class CertificateExpiredException extends CertificateException {

    private static final long serialVersionUID = 9071001339691533771L; /*ibm@76465*/

    /**
     * Constructs a CertificateExpiredException with no detail message. A
     * detail message is a String that describes this particular
     * exception.
     */
    public CertificateExpiredException() {
        super();
    }

    /**
     * Constructs a CertificateExpiredException with the specified detail
     * message. A detail message is a String that describes this
     * particular exception.
     *   
     * @param message the detail message.
     */
    public CertificateExpiredException(String message) {
        super(message);
    }
}
