/*
 * @(#)src/classes/sov/java/security/cert/CRLException.java, security, as142, 20050517 1.8.2.2
 * ===========================================================================
 * Licensed Materials - Property of IBM
 * "Restricted Materials of IBM"
 *
 * IBM SDK, Java(tm) 2 Technology Edition, v1.4.2
 * (C) Copyright IBM Corp. 1998, 2004. All Rights Reserved
 * ===========================================================================
 */

/*
 * ===========================================================================
 * Copyright 2003 Sun Microsystems, Inc. All rights reserved.
 * ===========================================================================
 */

/* 
 * ===========================================================================
 * Change activity: 
 * 
 * Reason  Date   Origin   Description 
 * ------  ----   ------   ---------------------------------------------------
 * 076465  020804 riclau   Explicitly set serialVersionUID
 *
 * ===========================================================================
 */
 

package java.security.cert;

import java.security.GeneralSecurityException;

/**
 * CRL (Certificate Revocation List) Exception.
 *
 * @author Hemma Prafullchandra
 * 1.8
 */
public class CRLException extends GeneralSecurityException {

   private static final long serialVersionUID = -6694728944094197147L; /*ibm@76465*/

   /**
     * Constructs a CRLException with no detail message. A
     * detail message is a String that describes this particular
     * exception.
     */
    public CRLException() {
        super();
    }

    /**
     * Constructs a CRLException with the specified detail
     * message. A detail message is a String that describes this
     * particular exception. 
     *
     * @param message the detail message.
     */
    public CRLException(String message) {
        super(message);
    }
}
