/*
 * @(#)src/classes/sov/java/nio/charset/IllegalCharsetNameException.java, i18n, as142, 20050517 1.2.2.1
 * ===========================================================================
 * IBM Confidential
 * OCO Source Materials
 *
 * IBM SDK, Java(tm) 2 Technology Edition, v1.4.2
 * (C) Copyright IBM Corp. 1998, 2004.
 *
 * The source code for this program is not published or otherwise divested of
 * its trade secrets, irrespective of what has been deposited with the U.S.
 * Copyright office.
 * ===========================================================================
 */

/*
 * ===========================================================================
 * Copyright 2002 Sun Microsystems, Inc. All rights reserved.
 * ===========================================================================
 */


/*
 * ===========================================================================
 * Change activity:
 *
 * Reason  Date   Origin  Description
 * ------  ----   ------  ----------------------------------------------------
 * 061774  030603 pabbott Remove autogeneration of NIO source files.
 *
 */

package java.nio.charset;

/**
 * Unchecked exception thrown when a string that is not a
 * <a href=Charset.html#names>legal charset name</a> is used as such.
 *
 * @version 1.2, 01/09/17
 * @since 1.4
 */

public class IllegalCharsetNameException extends IllegalArgumentException {

   private String charsetName;

   /**
    * Constructs an instance of this class. </p>
    *
    * @param  charsetName
    *         The illegal charset name
    */
   public IllegalCharsetNameException(String charsetName) {
      super(String.valueOf(charsetName));
      this.charsetName = charsetName;
   }

   /**
    * Retrieves the illegal charset name. </p>
    *
    * @return  The illegal charset name
    */
   public String getCharsetName() {
      return charsetName;
   }

}
