/*
 * @(#)src/classes/sov/java/nio/ByteBufferAsIntBufferL.java, nio, as142, 20050517 1.2.2.1
 * ===========================================================================
 * IBM Confidential
 * OCO Source Materials
 *
 * IBM SDK, Java(tm) 2 Technology Edition, v1.4.2
 * (C) Copyright IBM Corp. 1998, 2004.
 *
 * The source code for this program is not published or otherwise divested of
 * its trade secrets, irrespective of what has been deposited with the U.S.
 * Copyright office.
 * ===========================================================================
 */

/*
 * ===========================================================================
 * Copyright 2002 Sun Microsystems, Inc. All rights reserved.
 * ===========================================================================
 */


/*
 * ===========================================================================
 * Change activity:
 *
 * Reason  Date   Origin  Description
 * ------  ----   ------  ----------------------------------------------------
 * 061774  030603 pabbott Remove autogeneration of NIO source files.
 *
 */

package java.nio;

class ByteBufferAsIntBufferL extends IntBuffer {

   protected final ByteBuffer bb;
   protected final int offset;

   ByteBufferAsIntBufferL(ByteBuffer bb) {

      super(-1, 0, bb.remaining() >> 2, bb.remaining() >> 2);
      this.bb = bb;
      // enforce limit == capacity
      int cap = this.capacity();
      this.limit(cap);
      int pos = this.position();
      assert(pos <= cap);
      offset = pos;

   }

   ByteBufferAsIntBufferL(ByteBuffer bb, int mark, int pos, int lim, int cap, int off) {

      super(mark, pos, lim, cap);
      this.bb = bb;
      offset = off;

   }

   public IntBuffer slice() {
      int pos = this.position();
      int lim = this.limit();
      assert(pos <= lim);
      int rem = (pos <= lim ? lim - pos : 0);
      int off = (pos << 2) + offset;
      return new ByteBufferAsIntBufferL(bb, -1, 0, rem, rem, off);
   }

   public IntBuffer duplicate() {
      return new ByteBufferAsIntBufferL(
         bb,
         this.markValue(),
         this.position(),
         this.limit(),
         this.capacity(),
         offset);
   }

   public IntBuffer asReadOnlyBuffer() {

      return new ByteBufferAsIntBufferRL(
         bb,
         this.markValue(),
         this.position(),
         this.limit(),
         this.capacity(),
         offset);

   }

   protected int ix(int i) {
      return (i << 2) + offset;
   }

   public int get() {
      return Bits.getIntL(bb, ix(nextGetIndex()));
   }

   public int get(int i) {
      return Bits.getIntL(bb, ix(checkIndex(i)));
   }

   public IntBuffer put(int x) {

      Bits.putIntL(bb, ix(nextPutIndex()), x);
      return this;

   }

   public IntBuffer put(int i, int x) {

      Bits.putIntL(bb, ix(checkIndex(i)), x);
      return this;

   }

   public IntBuffer compact() {

      int pos = position();
      int lim = limit();
      assert(pos <= lim);
      int rem = (pos <= lim ? lim - pos : 0);

      ByteBuffer db = bb.duplicate();
      db.limit(ix(lim));
      db.position(ix(0));
      ByteBuffer sb = db.slice();
      sb.position(pos << 2);
      sb.compact();
      position(rem);
      limit(capacity());
      return this;

   }

   public boolean isDirect() {
      return bb.isDirect();
   }

   public boolean isReadOnly() {
      return false;
   }

   public ByteOrder order() {

      return ByteOrder.LITTLE_ENDIAN;

   }

}
