/*
 * @(#)src/classes/sov/java/nio/ByteBufferAsFloatBufferRL.java, nio, as142, 20050517 1.2.2.1
 * ===========================================================================
 * IBM Confidential
 * OCO Source Materials
 *
 * IBM SDK, Java(tm) 2 Technology Edition, v1.4.2
 * (C) Copyright IBM Corp. 1998, 2004.
 *
 * The source code for this program is not published or otherwise divested of
 * its trade secrets, irrespective of what has been deposited with the U.S.
 * Copyright office.
 * ===========================================================================
 */

/*
 * ===========================================================================
 * Copyright 2002 Sun Microsystems, Inc. All rights reserved.
 * ===========================================================================
 */


/*
 * ===========================================================================
 * Change activity:
 *
 * Reason  Date   Origin  Description
 * ------  ----   ------  ----------------------------------------------------
 * 061774  030603 pabbott Remove autogeneration of NIO source files.
 *
 */

package java.nio;

class ByteBufferAsFloatBufferRL extends ByteBufferAsFloatBufferL {

   ByteBufferAsFloatBufferRL(ByteBuffer bb) {

      super(bb);

   }

   ByteBufferAsFloatBufferRL(ByteBuffer bb, int mark, int pos, int lim, int cap, int off) {

      super(bb, mark, pos, lim, cap, off);

   }

   public FloatBuffer slice() {
      int pos = this.position();
      int lim = this.limit();
      assert(pos <= lim);
      int rem = (pos <= lim ? lim - pos : 0);
      int off = (pos << 2) + offset;
      return new ByteBufferAsFloatBufferRL(bb, -1, 0, rem, rem, off);
   }

   public FloatBuffer duplicate() {
      return new ByteBufferAsFloatBufferRL(
         bb,
         this.markValue(),
         this.position(),
         this.limit(),
         this.capacity(),
         offset);
   }

   public FloatBuffer asReadOnlyBuffer() {

      return duplicate();

   }

   public FloatBuffer put(float x) {

      throw new ReadOnlyBufferException();

   }

   public FloatBuffer put(int i, float x) {

      throw new ReadOnlyBufferException();

   }

   public FloatBuffer compact() {

      throw new ReadOnlyBufferException();

   }

   public boolean isDirect() {
      return bb.isDirect();
   }

   public boolean isReadOnly() {
      return true;
   }

   public ByteOrder order() {

      return ByteOrder.LITTLE_ENDIAN;

   }

}
