/*
 * @(#)src/classes/sov/java/lang/reflect/ReflectAccess.java, reflect, as142, 20050517 1.5.2.1
 * ===========================================================================
 * Licensed Materials - Property of IBM
 * "Restricted Materials of IBM"
 *
 * IBM SDK, Java(tm) 2 Technology Edition, v1.4.2
 * (C) Copyright IBM Corp. 1998, 2004. All Rights Reserved
 * ===========================================================================
 */

/*
 * ===========================================================================
 * Copyright 2003 Sun Microsystems, Inc. All rights reserved.
 * ===========================================================================
 */

/*
 * ===========================================================================
 * Change activity:
 *
 * Reason Date   Origin   Description
 * ------ ----   ------   ----------------------------------------------------
 * 071341  050404 nichanir Change slot in Field, Method, Constructor to long for J9
 * ===========================================================================
 */


package java.lang.reflect;

import sun.reflect.MethodAccessor;
import sun.reflect.ConstructorAccessor;

/** Package-private class implementing the
    sun.reflect.LangReflectAccess interface, allowing the java.lang
    package to instantiate objects in this package. */

class ReflectAccess implements sun.reflect.LangReflectAccess {
    public Field newField(Class declaringClass,
                          String name,
                          Class type,
                          int modifiers,
                          long slot)               /*ibm@71341*/
    {
        return new Field(declaringClass,
                         name,
                         type,
                         modifiers,
                         slot);
    }

    public Method newMethod(Class declaringClass,
                            String name,
                            Class[] parameterTypes,
                            Class returnType,
                            Class[] checkedExceptions,
                            int modifiers,
                            long slot)             /*ibm@71341*/
    {
        return new Method(declaringClass,
                          name,
                          parameterTypes,
                          returnType,
                          checkedExceptions,
                          modifiers,
                          slot);
    }

    public Constructor newConstructor(Class declaringClass,
                                      Class[] parameterTypes,
                                      Class[] checkedExceptions,
                                      int modifiers,
                                      long slot)   /*ibm@71341*/
    {
        return new Constructor(declaringClass,
                               parameterTypes,
                               checkedExceptions,
                               modifiers,
                               slot);
    }

    public MethodAccessor getMethodAccessor(Method m) {
        return m.getMethodAccessor();
    }

    public void setMethodAccessor(Method m, MethodAccessor accessor) {
        m.setMethodAccessor(accessor);
    }

    public ConstructorAccessor getConstructorAccessor(Constructor c) {
        return c.getConstructorAccessor();
    }

    public void setConstructorAccessor(Constructor c,
                                       ConstructorAccessor accessor)
    {
        c.setConstructorAccessor(accessor);
    }

    public long getConstructorSlot(Constructor c) {       /*ibm@71341*/
        return c.getSlot();
    }

    //
    // Copying routines, needed to quickly fabricate new Field,
    // Method, and Constructor objects from templates
    //
    public Method      copyMethod(Method arg) {
        return arg.copy();
    }

    public Field       copyField(Field arg) {
        return arg.copy();
    }

    public Constructor copyConstructor(Constructor arg) {
        return arg.copy();
    }
}
