/*
 * @(#)src/classes/sov/java/awt/GraphicsCallback.java, awt, as142, 20050517 1.12.2.1
 * ===========================================================================
 * Licensed Materials - Property of IBM
 * "Restricted Materials of IBM"
 *
 * IBM SDK, Java(tm) 2 Technology Edition, v1.4.2
 * (C) Copyright IBM Corp. 2003, 2004. All Rights Reserved
 * ===========================================================================
 */

/*
 * ===========================================================================
 * Copyright 2003 Sun Microsystems, Inc. All rights reserved.
 * ===========================================================================
 */
/* 
 *
 * Change activity:
 *
 * Reason  Date   Origin    Description
 * ------  ----   ------    -------------------------------------------------- 
 * 63757   050903 slattery  Add IBM module header; 
 * 63757   161003 jury      Merge 142
 *
 * ===========================================================================
 * Module Information:
 * 
 * DESCRIPTION: IBM.WRITEME
 * ===========================================================================
 */

/*
 * @(#)GraphicsCallback.java	1.6 03/01/23
 *
 */

package java.awt;

import java.awt.peer.LightweightPeer;
import sun.awt.SunGraphicsCallback;


abstract class GraphicsCallback extends SunGraphicsCallback {

    static final class PaintCallback extends GraphicsCallback {
        private static PaintCallback instance = new PaintCallback();

        private PaintCallback() {}
        public void run(Component comp, Graphics cg) {
            if (comp instanceof Container && !(comp instanceof javax.swing.JComponent)) { //ibm.8159 //ibm.9748
               Container cont = (Container) comp; //ibm.8159
               cont.needsPaint = true;            //ibm.8159
               cont.paint(cg);                    //ibm.8159
               if (cont.needsPaint == true) {     //ibm.8159
                  // not painted yet              //ibm.8159
                  // ensures children paint       //ibm.8159
                  GraphicsCallback.PaintCallback.getInstance(). //ibm.8159
                      runComponents(cont.component, cg,         //ibm.8159
                      GraphicsCallback.LIGHTWEIGHTS);           //ibm.8159
               }                                  //ibm.8159
            } else {                              //ibm.8159
               comp.paint(cg);                    //ibm.8159
            }                                     //ibm.8159
        }
        static PaintCallback getInstance() {
            return instance;
        }
    }
    static final class PrintCallback extends GraphicsCallback {
        private static PrintCallback instance = new PrintCallback();

        private PrintCallback() {}
        public void run(Component comp, Graphics cg) {
            comp.print(cg);
        }
        static PrintCallback getInstance() {
            return instance;
        }
    }
    static final class PaintAllCallback extends GraphicsCallback {
        private static PaintAllCallback instance = new PaintAllCallback();

        private PaintAllCallback() {}
        public void run(Component comp, Graphics cg) {
            comp.paintAll(cg);
        }
        static PaintAllCallback getInstance() {
            return instance;
        }
    }
    static final class PrintAllCallback extends GraphicsCallback {
        private static PrintAllCallback instance = new PrintAllCallback();

        private PrintAllCallback() {}
        public void run(Component comp, Graphics cg) {
            comp.printAll(cg);
        }
        static PrintAllCallback getInstance() {
            return instance;
        }
    }
    static final class PeerPaintCallback extends GraphicsCallback {
        private static PeerPaintCallback instance = new PeerPaintCallback();

        private PeerPaintCallback() {}
        public void run(Component comp, Graphics cg) {
	    comp.validate();
	    if (comp.peer instanceof LightweightPeer) {
	        comp.lightweightPaint(cg);
	    } else {
	        comp.paint(cg); /*ibm@21730*/
	    }
	}
        static PeerPaintCallback getInstance() {
	    return instance;
	}
    }
    static final class PeerPrintCallback extends GraphicsCallback {
        private static PeerPrintCallback instance = new PeerPrintCallback();

        private PeerPrintCallback() {}
        public void run(Component comp, Graphics cg) {
	    comp.validate();
	    if (comp.peer instanceof LightweightPeer) {
	        comp.lightweightPrint(cg);
	    } else {
	        comp.peer.print(cg);
	    }
	}
        static PeerPrintCallback getInstance() {
	    return instance;
	}
    }
    static final class PaintHeavyweightComponentsCallback
        extends GraphicsCallback
    {
        private static PaintHeavyweightComponentsCallback instance =
	    new PaintHeavyweightComponentsCallback();

        private PaintHeavyweightComponentsCallback() {}
        public void run(Component comp, Graphics cg) {
	    if (comp.peer instanceof LightweightPeer) {
	        comp.paintHeavyweightComponents(cg);
	    } else {
	        comp.paintAll(cg);
	    }
	}
        static PaintHeavyweightComponentsCallback getInstance() {
	    return instance;
	}
    }
    static final class PrintHeavyweightComponentsCallback
        extends GraphicsCallback
    {
        private static PrintHeavyweightComponentsCallback instance =
	    new PrintHeavyweightComponentsCallback();

        private PrintHeavyweightComponentsCallback() {}
        public void run(Component comp, Graphics cg) {
	    if (comp.peer instanceof LightweightPeer) {
	        comp.printHeavyweightComponents(cg);
	    } else {
	        comp.printAll(cg);
	    }
	}
        static PrintHeavyweightComponentsCallback getInstance() {
	    return instance;
	}
    }
}
