/*
 * @(#)src/contract/jvm/sov/jvmmi.h, jvm, hs142, 20050519 1.24
 * ===========================================================================
 * Licensed Materials - Property of IBM
 * "Restricted Materials of IBM"
 *
 * IBM SDK, Java(tm) 2 Technology Edition, v1.4.2
 * (C) Copyright IBM Corp. 1998, 2004. All Rights Reserved
 *
 * US Government Users Restricted Rights - Use, duplication or disclosure
 * restricted by GSA ADP Schedule Contract with IBM Corp.
 * ===========================================================================
 */


/*
 *
 * Module Information:
 *
 * DESCRIPTION: 
 * Contains public definitions/declarations related to JVMMI. 
 * Additional non-public JVMMI elements are defined in ci_jvmmi.h.
 * ===========================================================================
 */
 
#include <jni.h>

#define JVMMI_VERSION_1     ((jint)0x00010011)


/****************************************************************************/
/* Event types which may be monitored                                       */
/****************************************************************************/

#define JVMMI_EVENT_COUNT                     22 /* Number of events defined ibm@64689*/

#define JVMMI_EVENT_THREAD_START              0
#define JVMMI_EVENT_THREAD_STOP               1
#define JVMMI_EVENT_CLASS_LOAD                2
#define JVMMI_EVENT_CLASS_UNLOAD              3

#define JVMMI_EVENT_THREAD_CREATED            4
#define JVMMI_EVENT_THREAD_CREATION_REQUESTED 5
#define JVMMI_EVENT_JVM_INIT_DONE             6
#define JVMMI_EVENT_JVM_SHUTDOWN              7
#define JVMMI_EVENT_GC_MARK_START             8
#define JVMMI_EVENT_GC_START                  9
#define JVMMI_EVENT_GC_FINISH                10
#define JVMMI_EVENT_HEAP_SIZE                11
#define JVMMI_EVENT_HEAP_FULL                12
#define JVMMI_EVENT_HEAP_LOW                 13
#define JVMMI_EVENT_AREA_ALLOC               14
#define JVMMI_EVENT_OUT_OF_MEMORY            15
#define JVMMI_EVENT_GC_MARK_STACK_OVERFLOW   16 /*ibm@56481*/
#define JVMMI_EVENT_GC_COMPACT               17 /*ibm@56481*/
#define JVMMI_EVENT_GC_OBJECT_ENUMERATE	     18 /*ibm@56481*/
#define JVMMI_EVENT_OBJECT_REFERENCES        19 /*ibm@64391*/
#define JVMMI_EVENT_HEAPDUMP                 20 /*ibm@64391*/
#define JVMMI_EVENT_JVM_RESET                21 /*ibm@64689*/

/****************************************************************************/
/* "Items" which may be enumerated over                                     */
/* Any changes here need to be reflected in jvmmi_enumerateDefinitions      */
/****************************************************************************/
                                            /*ibm@63737*/
#define JVMMI_LIST_COUNT        7           /* number of lists defined      */

#define JVMMI_LIST_DEFINITION   0x10000000  /* what can be enumerated       */
#define JVMMI_LIST_EVENT        0x10000001  /* what events can be monitored */
#define JVMMI_LIST_COMPONENT    0x10000002  /* components: st, gc, etc.     */
#define JVMMI_LIST_MONITOR      0x10000003  /* monitors                     */
#define JVMMI_LIST_OBJECT       0x10000004  /* All objects in heap          */
#define JVMMI_LIST_THREAD       0x10000005  /* All threads                  */
#define JVMMI_LIST_SYSLOCK      0x10000006  /* system locks       ibm@63737 */
                                                            
/****************************************************************************/
/* Return codes                                                             */
/****************************************************************************/

#define JVMMI_OK     JNI_OK
#define JVMMI_ERR    JNI_ERR
#define JVMMI_OTHER  999


/****************************************************************************/
/* Heap Constants                                                           */
/* The following constants will be used to identify the heap to which a     */
/* heap event (e.g. Heap Low) relates.  If running in non-resettable mode,  */
/* the only value seen will be JVMMI_MAIN_HEAP.                             */
/****************************************************************************/
#define JVMMI_MAIN_HEAP        1   /* The main heap (non-resettable mode)   */
#define JVMMI_MIDDLEWARE_HEAP  1   /* The Middleware Heap (resettable mode) */
#define JVMMI_TRANSIENT_HEAP   2   /* The Transient Heap (resettable mode)  */


/****************************************************************************/
/* Compaction "actions"                                                     */
/* Actually reasons for compaction                                          */
/* used in JVMMI_EVENT_GC_COMPACT                                 ibm@60144 */
/****************************************************************************/
#define JVMMI_COMPACT_NONE            0 /* no compaction !                    */
#define JVMMI_COMPACT_LARGE           1 /* to satisfy allocation failure      */
#define JVMMI_COMPACT_FRAGMENTED      2 /* fragmentation heuristic            */
#define JVMMI_COMPACT_MEM_MINFREE     3 /* < 1/2 minheapFreePercent available */
#define JVMMI_COMPACT_FORCED_GC       4 /* suitable Runtime.gc()              */
#define JVMMI_COMPACT_AVOID_DESPERATE 5 /* avoid desperation where possible   */
#define JVMMI_COMPACT_MEM_INSUFF      6 /* < JMS_MEM_INSUFF available         */
#define JVMMI_COMPACT_ALWAYS          7 /* -compactgc requested               */
#define JVMMI_COMPACT_TH_NEARLY_FULL  8 /* transient heap < 5%                */
#define JVMMI_COMPACT_INCREMENTAL    10 /* Incremental compaction             */
#define JVMMI_COMPACT_SHRINK         11 /* Compact to aid shrinking           */
#define JVMMI_COMPACT_DARKMATTER     12 /* Compact to remove "dark matter"    */
#define JVMMI_COMPACT_INC_ALWAYS     13 /*  -partialcompactgc requested       */
#define JVMMI_COMPACT_LOA_EXPANDED   14 /* Expansion of Large Object Area     */
#define JVMMI_COMPACT_LOA_PRESSURE   15 /* Activity in Large Object Area      */

/****************************************************************************/
/* Results of JVM resets                                                    */
/* used in JVMMI_EVENT_JVM_RESET                                  ibm@64689 */
/****************************************************************************/
#define JVMMI_RESET_SUCCESS                   0  /* successful reset                       */ 
#define JVMMI_RESET_NOT_RESETTABLE            1  /* JVM is not resettable                  */
#define JVMMI_RESET_OUSTANDING_EXCEPTION      2  /* there is an outstanding exception      */
#define JVMMI_RESET_MIDDLEWARE                3  /* Middleware could not be tidied         */
#define JVMMI_RESET_DIRTY                     4  /* JVM is marked dirty                    */
#define JVMMI_RESET_MULTIPLE_THREADS          5  /* Multiple threads are running           */
#define JVMMI_RESET_CLASSLOADER               6  /* Classloader could not be removed       */
#define JVMMI_RESET_GC_NOT_RESET              7  /* GC could not be reset                  */
#define JVMMI_RESET_CLASSLOADER_REINITIALIZE  8  /* Classloader could not be reinitialized */
#define JVMMI_RESET_RESET_MIDDLEWARE          9  /* Middleware could not be reset          */
#define JVMMI_RESET_DIRTY2                   10  /* JVM is marked dirty after reset        */

#ifdef _WIN64
typedef unsigned __int64 uintptr_t;
#elif defined(_WIN32)
typedef unsigned int uintptr_t;
#endif
 

/****************************************************************************/
/* JVMMI_Event                                                              */
/****************************************************************************/

/****************************************************************************/
/* NOTE: Any change to this structure may need reflecting in the            */
/* jvmmi_enumerateEvents function.                                          */
/****************************************************************************/
typedef struct JVMMI_Event{

    int type;                        /* The type of the event               */
    JNIEnv *envID;                   /* Env where event occured             */

    union{                           /* The valid element of the union is   */
                                     /* dictated by type                    */
      struct{
          void *id;                  /* Unique ID of monitor                */
          void *tid;                 /* Thread id of current owner ibm@63737*/
          int flat_inflated;         /* 0 = flat, 1 = inflated              */
          char *name;                /* name of monitor                     */
      } monitor_info;

      struct{
          void *id;                  /* Unique ID of object                 */
          int size;                  /* Size of object                      */
          char *classname;           /* Name of class this is instance of   */
      } object_info;

      struct{
          char *name;                /* Class name                          */
          char *source;              /* Source file name                    */
          int interfaces;            /* Number of interfaces                */
          int methods;               /* Number of methods                   */
          int fields;                /* Number of fields                    */
      } class_info;

      struct{
          int type;                  /* object Type which can be enumerated */
          char *description;         /* V brief description of enmeration   */
      } enumeration_info;

      struct{
          char name[3];              /* Name of component                   */
          void *facade;              /* Pointer to component interface ibm@68114    */
      } component_info;

      struct{
          int type;                  /* Type of event                       */
          char *detail_name;         /* Name of element in detail union     */
          char *elements;            /* List of elements in detail          */
          char *description;         /* V brief description of event        */
      } event_info;

      struct {
          int unused;                /* unused                              */
      } no_additional_info;

      struct {
          int  heap_type;                    /* which heap was involved?            */
          size_t old_heap_size;              /* how big was this heap before?       */
          size_t new_heap_size;              /* how big is this heap now?           */
          size_t free_heap_size;             /* how much room is left on it?        */
          int  gc_counter;                   /* GC Counter                          */
          int  af_counter;                   /* AF Counter                          */
          float percentage_time_in_gc;       /* Percentage time spent in gc         */
          float percentage_time_over_ten_gc; /* % time spent in gc over last 10 gc cycles */
          uintptr_t largest_free_chunk;      /* Largest free chunk available        */
          long mark_time;                    /* milliseconds spent in mark phase    */
          long sweep_time;                   /* milliseconds spent in sweep phase   */
          long compact_time;                 /* milliseconds spent in compact phase */
      } heap_info;

      struct {
          size_t alloc_bytes;        /* bytes allocated since last alloc    */
                                     /* event                               */
      } alloc_info;

      struct {             
          void *id;                  /* which thread generated event?       */
          void *parent_id;           /* ID of it's creator                  */
          void *child_id;            /* ID it (just) created or NULL        */
                                     /* if not a thread created event       */
          char *name;                /* name of thread - e.g. "main"        */ 
      } thread_info;       

      struct {
          char    *detail_message;   /* detail message                      */
          long     allocated_memory; /* allocated bytes                     */
          int      GC_cycles_done;   /* number of GC cycles performed       */
          size_t   max_heap_size;    /* max size of heap                    */
          size_t   free_list_bytes;  /* bytes on the free list              */
      } memory_exception_info;
      
      struct {
          size_t   free_space;        /* free heap space                    */
          size_t   expected_space;    /* a size_t for expected space        */
          size_t   kickoff_threshold; /* less than this left and we mark    */
      } mark_info;

      struct {
          int      overflow_counter;  /* Counter for mark stack overflow           */
                                      /* N.B. JVMMI_EVENT_GC_MARK_STACK_OVERFLOW   */ 
                                      /* is generated at the end of a GC where one */
                                      /* or more mark stack overflows occured, so  */
                                      /* this counter may increment in intervals   */
                                      /* greater than one               ibm@60144  */
      } mark_stack_overflow_info;

      struct {
          int      compact_action;    /* Actually the reason for compaction        */
                                      /* see JVMMI_COMPACT_... above               */
          int      compact_reason;    /* reason for incremental compaction - only  */
                                      /* set if                                    */
                                      /* compact_action==JVMMI_COMPACT_INCREMENTAL */
                                      /* (-1 otherwise)                            */
                                      /*                                ibm@60144  */
          int      compact_counter;
      } compact_info;

      struct {
          int object_enumeration_type;/* 0 - heap believed stable, 1 otherwise     */
          int num_reg_heap_objects;   /* number of objects in the Middleware Heap  */
          int num_tran_heap_objects;  /* number of objects in the Transient Heap   */
          int num_sys_heap_objects;   /* number of objects in the System Heap      */
          int num_acs_heap_objects;   /* number of objects in the                  */
                                      /* Application Class System Heap             */
          int num_tl_heap_objects;    /* number of objects in Thread Local Heaps   */
      } object_enumeration_info;      /*                                 ibm@60144 */

      struct {                                                                        
          int    more_follow;         /* TRUE if further event will follow         */ 
          char   *refs;               /* text of the object references             */ 
          char   *object_description; /* object summary info                       */ 
      } reference_info;               /*                                 ibm@64391 */

      struct {                                                                        
          char     *reason;           /* Reason for this heapdump                  */ 
      } heapdump_info;                /*                                 ibm@64391 */

      struct {                                                                        
          int num_resets;             /* The number of sucessful resets            */ 
          int result;                 /* 0=success other=reason for failure        */ 
      } reset_info;                   /*                                 ibm@64689 */

    } detail;
} JVMMI_Event;


/****************************************************************************/
/* JVMMI_Interface                                                          */
/****************************************************************************/

typedef int(JNICALL *jvmmi_callback_t)(JNIEnv *env, JVMMI_Event *evt,
                                       void *userData, int tid);     

typedef struct JVMMI_Interface{ 

    /* Enable a callback to "func" on event type "eventId" */
    int (JNICALL *EnableEvent)(JNIEnv *env,
                               jvmmi_callback_t func,
                               void *userData,
                               int eventId);

    /* Disable previously enabled callback to "func" on event type "eventId" */
    int (JNICALL *DisableEvent)(JNIEnv *env, 
                               jvmmi_callback_t func,
                               void *userData,
                               int eventId);

    /* Request a callback to "func" for each item of type "itemType", up to 
     * a maximum of "limit" items */
    int (JNICALL *EnumerateOver)(JNIEnv *env, 
                               int itemType, 
                               int limit, 
                               jvmmi_callback_t func,
                               void *userData);
} JVMMI_Interface;


/****************************************************************************/
/* Function declarations                                                    */
/****************************************************************************/

JVMMI_Interface * jvmmi_GetInterface_1(JavaVM *vm);

