/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.sib.sdo;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.sdo.JmsBodyAdapter;
import com.ibm.wsspi.sib.sdo.JmsBodyAdapterException;
import com.ibm.wsspi.sib.sdo.JmsBodyAdapterFactory;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Properties;

public abstract class JmsBodyAdapterRegistry {
    private static final TraceComponent tc = SibTr.register(JmsBodyAdapterRegistry.class, "SIBSdoRepository", "com.ibm.wsspi.sdo.config.CWSJOMessages");
    private static String className = "com.ibm.ws.sib.sdo.config.impl.JmsBodyAdapterRegistryImpl";
    private static JmsBodyAdapterRegistry instance;
    private static Properties properties;

    public static JmsBodyAdapterRegistry instance() {
        return instance;
    }

    static Properties getProperties() throws IOException {
        if (properties == null) {
            InputStream inputStream = JmsBodyAdapterRegistry.class.getClassLoader().getResourceAsStream("com/ibm/wsspi/sib/sdo/bodyadapter.properties");
            properties = new Properties();
            properties.load(inputStream);
        }
        return properties;
    }

    public void init() throws JmsBodyAdapterException {
        try {
            Properties properties = JmsBodyAdapterRegistry.getProperties();
            Enumeration<Object> enumeration = properties.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                this.register(string, properties.getProperty(string));
            }
        }
        catch (IOException iOException) {
            FFDCFilter.processException((Throwable)iOException, (String)"init", (String)"97");
            throw new JmsBodyAdapterException(iOException);
        }
    }

    public abstract void register(String var1, String var2) throws JmsBodyAdapterException;

    public abstract void deregister(String var1) throws JmsBodyAdapterException;

    public abstract JmsBodyAdapterFactory getBodyAdapterFactory(String var1) throws JmsBodyAdapterException;

    public JmsBodyAdapter getBodyAdapter(String string, String string2) throws JmsBodyAdapterException {
        JmsBodyAdapterFactory jmsBodyAdapterFactory;
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "getBodyAdapter", new Object[]{string, string2});
        }
        if ((jmsBodyAdapterFactory = this.getBodyAdapterFactory(string)) == null) {
            throw new JmsBodyAdapterException("Unable to get JmsBodyAdapterFactory for domain " + string);
        }
        JmsBodyAdapter jmsBodyAdapter = jmsBodyAdapterFactory.getBodyAdapter(string2);
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "getBodyAdapter", jmsBodyAdapter);
        }
        return jmsBodyAdapter;
    }

    public JmsBodyAdapter getBodyAdapter(String string) throws JmsBodyAdapterException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "getBodyAdapter", (Object)string);
        }
        String string2 = string;
        int n = string.indexOf(58);
        if (n != -1) {
            string2 = string.substring(0, n);
            string = string.substring(n + 1);
        } else {
            string = null;
        }
        JmsBodyAdapter jmsBodyAdapter = this.getBodyAdapter(string2, string);
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "getBodyAdapter", jmsBodyAdapter);
        }
        return jmsBodyAdapter;
    }

    public abstract void clear();

    static {
        try {
            instance = (JmsBodyAdapterRegistry)Class.forName(className).newInstance();
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.wsspi.sib.sdo.JmsBodyAdapterRegistry.instance", (String)"56");
            throw new RuntimeException("Creating JmsBodyAdapterRegistry: " + exception);
        }
        try {
            instance.init();
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.wsspi.sib.sdo.JmsBodyAdapterRegistry.instance", (String)"63");
            throw new RuntimeException("Initialising JmsBodyAdapterRegistry: " + exception);
        }
    }
}

