/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.sib.core;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.sib.exception.SIMessageException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.SIBusMessage;
import javax.jms.Message;

public abstract class SIJMSMessageFactory {
    private static final String MSG_BUNDLE = "com.ibm.wsspi.sib.core.CWSIBMessages";
    private static final TraceComponent tc = SibTr.register(SIJMSMessageFactory.class, "SIBMfpApi", "com.ibm.wsspi.sib.core.CWSIBMessages");
    private static final String SIBUS_SDO_MESSAGE_FACTORY_CLASS = "com.ibm.ws.sib.mfp.impl.SIJMSMessageFactoryImpl";
    private static SIJMSMessageFactory instance = null;
    private static NoClassDefFoundError createException = null;

    public static SIJMSMessageFactory getInstance() {
        if (instance == null) {
            throw createException;
        }
        return instance;
    }

    public abstract Message createJMSMessage(SIBusMessage var1) throws SIMessageException;

    private static void createFactoryInstance() {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "createFactoryInstance");
        }
        try {
            Class<?> clazz = Class.forName(SIBUS_SDO_MESSAGE_FACTORY_CLASS);
            instance = (SIJMSMessageFactory)clazz.newInstance();
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.wsspi.sib.core.SIJMSMessageFactory.createFactoryInstance", (String)"100");
            SibTr.error(tc, "TEMPORARY_CWSIB9999", "An SIJMSMessageFactoryImpl cannot be created: exception " + exception);
            NoClassDefFoundError noClassDefFoundError = new NoClassDefFoundError(exception.getMessage());
            noClassDefFoundError.initCause(exception);
            throw noClassDefFoundError;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "createFactoryInstance");
        }
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "Source info: @(#)SIB/ws/code/sib.mfp.core/src/com/ibm/wsspi/sib/core/SIJMSMessageFactory.java, SIB.mfp.core, WAS602.SIB, o0610.11 1.3");
        }
        try {
            SIJMSMessageFactory.createFactoryInstance();
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            createException = noClassDefFoundError;
        }
    }
}

