/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.utils.ras;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;

public class FormattedWriter
extends BufferedWriter {
    private int _indent = 0;
    private String _namespace = "";

    public FormattedWriter(Writer writer) {
        super(writer);
    }

    public FormattedWriter(Writer writer, int n) {
        super(writer, n);
    }

    public final void comment(String string) throws IOException {
        this.startComment();
        this.write(string);
        this.endComment();
    }

    public final void endComment() throws IOException {
        this.write("-->");
    }

    public final void emptyTag(String string) throws IOException {
        this.write(60);
        this.write(this._namespace + string);
        this.write("/>");
    }

    public final void endTag(String string) throws IOException {
        this.write("</");
        this.write(this._namespace + string);
        this.write(62);
    }

    public final void indent() {
        ++this._indent;
    }

    public final void introducer(String string) throws IOException {
        this.write("<?" + string + "?>");
        this.newLine();
    }

    public void newLine() throws IOException {
        this.flush();
        super.newLine();
        for (int i = 0; i < this._indent; ++i) {
            this.write("  ");
        }
    }

    public final void outdent() {
        --this._indent;
    }

    public final void nameSpace(String string) {
        this._namespace = string == null || string.equals("") ? "" : string + ":";
    }

    public final void startComment() throws IOException {
        this.write("<!--");
    }

    public final void startTag(String string) throws IOException {
        this.write(60);
        this.write(this._namespace + string);
        this.write(62);
    }

    public final void taggedValue(String string, long l) throws IOException {
        this.startTag(string);
        this.write(Long.toString(l));
        this.endTag(string);
    }

    public final void taggedValue(String string, Object object) throws IOException {
        this.startTag(string);
        if (object == null) {
            this.write("null");
        } else {
            this.write(object.toString());
        }
        this.endTag(string);
    }

    public final void write(Throwable throwable) throws IOException {
        this.indent();
        this.newLine();
        this.write(throwable.toString());
        StackTraceElement[] stackTraceElementArray = throwable.getStackTrace();
        for (int i = 0; i < stackTraceElementArray.length; ++i) {
            this.newLine();
            this.write(stackTraceElementArray[i].toString());
        }
        Throwable throwable2 = throwable.getCause();
        if (throwable2 != null) {
            this.newLine();
            this.write(throwable2.toString());
        }
        this.outdent();
    }
}

