/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.utils.ffdc;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.Traceable;
import com.ibm.ws.ffdc.DiagnosticModule;
import com.ibm.ws.ffdc.FFDC;
import com.ibm.ws.ffdc.IncidentStream;
import com.ibm.ws.sib.utils.BuildInfo;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;

public class SibDiagnosticModule
extends DiagnosticModule {
    private static TraceComponent _tc = SibTr.register(SibDiagnosticModule.class, "", null);
    private static SibDiagnosticModule _singleton;
    private static final String[] SIB_PACKAGE_LIST;
    private static final String SSCID_FIELD_NAME = "$ssccid";
    protected static final String lineSeparator;
    protected int multiple_object_count_to_ffdc = 20;

    protected SibDiagnosticModule() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void register(String[] stringArray) {
        if (_tc.isEntryEnabled()) {
            SibTr.entry(_tc, "register", new Object[]{this, stringArray});
        }
        if (_singleton == null) {
            Class clazz = SibDiagnosticModule.class;
            synchronized (clazz) {
                _singleton = new SibDiagnosticModule();
                _singleton.registerModule(SIB_PACKAGE_LIST);
            }
        }
        this.registerModule(stringArray);
        if (_tc.isEntryEnabled()) {
            SibTr.exit(_tc, "register");
        }
    }

    protected void captureDefaultInformation(IncidentStream incidentStream) {
        this.captureDefaultInformation(incidentStream, null);
    }

    protected void captureDefaultInformation(IncidentStream incidentStream, Throwable throwable) {
        incidentStream.writeLine("Platform Messaging :: Messaging engine:", SibTr.getMEName(null));
        incidentStream.writeLine("Platform Messaging :: Release name:    ", BuildInfo.getBuildRelease());
        incidentStream.writeLine("Platform Messaging :: Level name:      ", BuildInfo.getBuildLevel());
        if (throwable != null) {
            StackTraceElement[] stackTraceElementArray = throwable.getStackTrace();
            HashSet<String> hashSet = new HashSet<String>();
            for (int i = 0; i < stackTraceElementArray.length; ++i) {
                final StackTraceElement stackTraceElement = stackTraceElementArray[i];
                try {
                    if (hashSet.contains(stackTraceElement.getClassName())) continue;
                    Field field = (Field)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                        public Object run() throws Exception {
                            Class<?> clazz = Class.forName(stackTraceElement.getClassName());
                            Field field = clazz.getDeclaredField(SibDiagnosticModule.SSCID_FIELD_NAME);
                            if (field != null) {
                                field.setAccessible(true);
                            }
                            return field;
                        }
                    });
                    if (field != null) {
                        Object object = field.get(null);
                        incidentStream.writeLine(stackTraceElement.getClassName(), object);
                    }
                    hashSet.add(stackTraceElement.getClassName());
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    private void registerModule(String[] stringArray) {
        if (_tc.isEntryEnabled()) {
            SibTr.entry(_tc, "registerModule", new Object[]{this, stringArray});
        }
        int n = 0;
        for (int i = 0; n == 0 && i < stringArray.length; ++i) {
            if (_tc.isDebugEnabled()) {
                SibTr.debug(_tc, "Registering diagnostic module " + (Object)((Object)this) + " for package: " + stringArray[i]);
            }
            if ((n = FFDC.registerDiagnosticModule((DiagnosticModule)this, (String)stringArray[i])) == 0 || !_tc.isDebugEnabled()) continue;
            SibTr.debug(_tc, "Registration failed, rc=" + n);
        }
        if (_tc.isEntryEnabled()) {
            SibTr.exit(_tc, "registerModule");
        }
    }

    public void ffdcDumpDefault(Throwable throwable, IncidentStream incidentStream, Object object, Object[] objectArray, String string) {
        incidentStream.writeLine("SIB FFDC dump for:", (Object)throwable);
        this.captureDefaultInformation(incidentStream, throwable);
        if (object != null) {
            incidentStream.writeLine("SibDiagnosticModule :: Dump of callerThis (DiagnosticModule)", this.toFFDCString(object));
            incidentStream.introspectAndWriteLine("Introspection of callerThis:", object);
        }
        if (objectArray != null) {
            for (int i = 0; i < objectArray.length; ++i) {
                incidentStream.writeLine("callerArg (DiagnosticModule) [" + i + "]", this.toFFDCString(objectArray[i]));
                incidentStream.introspectAndWriteLine("callerArg [" + i + "] (Introspection)", objectArray[i]);
            }
        }
    }

    public final String toFFDCString(Object object) {
        if (object instanceof Map) {
            return this.toFFDCString((Map)object);
        }
        if (object instanceof Collection) {
            return this.toFFDCString((Collection)object);
        }
        if (object instanceof Object[]) {
            return this.toFFDCString((Object[])object);
        }
        return this.toFFDCStringSingleObject(object);
    }

    protected String toFFDCStringSingleObject(Object object) {
        if (object == null) {
            return "<null>";
        }
        if (object instanceof Traceable) {
            return ((Traceable)object).toTraceString();
        }
        if (object instanceof String) {
            return (String)object;
        }
        if (object instanceof byte[]) {
            return this.toFFDCString((byte[])object);
        }
        return object.toString();
    }

    protected final String toFFDCString(byte[] byArray) {
        boolean bl = true;
        for (int i = 0; i < byArray.length; ++i) {
            byte by = byArray[i];
            if (by < 32 || by > 126) {
                bl = false;
                break;
            }
            bl = true;
        }
        String string = bl ? new String(byArray) : this.toFFDCString(byArray, 0, byArray.length);
        return string;
    }

    protected final String toFFDCString(byte[] byArray, int n, int n2) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n2; i += 32) {
            int n3;
            int n4;
            int n5 = Math.min(i + 32, n2);
            StringBuffer stringBuffer2 = new StringBuffer();
            StringBuffer stringBuffer3 = new StringBuffer();
            for (n4 = i; n4 < n5; ++n4) {
                n3 = byArray[n + n4];
                n3 = (n3 + 256) % 256;
                int n6 = n3 / 16;
                int n7 = n3 % 16;
                stringBuffer2.append((char)(n6 < 10 ? 48 + n6 : 97 + n6 - 10));
                stringBuffer2.append((char)(n7 < 10 ? 48 + n7 : 97 + n7 - 10));
                if (n3 >= 32 && n3 <= 126) {
                    stringBuffer3.append((char)n3);
                } else {
                    stringBuffer3.append('.');
                }
                if (n4 % 32 != 15) continue;
                stringBuffer2.append("  ");
                stringBuffer3.append("  ");
            }
            n4 = 32 - (n5 - i);
            for (n3 = 0; n3 < n4; ++n3) {
                stringBuffer2.append("  ");
                if (n3 % 32 != 16) continue;
                stringBuffer2.append("  ");
            }
            stringBuffer2.append("   ");
            String string = "0000" + Integer.toHexString(i + n);
            string = string.substring(string.length() - 4);
            stringBuffer.append(string);
            stringBuffer.append(":  ");
            stringBuffer.append(stringBuffer2.toString());
            stringBuffer.append(stringBuffer3.toString());
            stringBuffer.append(lineSeparator);
        }
        return stringBuffer.toString();
    }

    public final String toFFDCString(Collection collection) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('{');
        if (collection == null) {
            stringBuffer.append("<null>");
        } else {
            Iterator iterator = collection.iterator();
            boolean bl = iterator.hasNext();
            int n = 0;
            while (bl) {
                Object e = iterator.next();
                stringBuffer.append((e == collection ? "<this list>" : this.toFFDCStringSingleObject(e)) + lineSeparator);
                bl = iterator.hasNext();
                if (n <= this.multiple_object_count_to_ffdc) continue;
                stringBuffer.append("........contd");
                bl = false;
            }
        }
        stringBuffer.append('}');
        return stringBuffer.toString();
    }

    public final String toFFDCString(Object[] objectArray) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('{');
        if (objectArray == null) {
            stringBuffer.append("<null>");
        } else {
            for (int i = 0; i < objectArray.length; ++i) {
                Object object = objectArray[i];
                stringBuffer.append((object == objectArray ? "<this array>" : this.toFFDCStringSingleObject(object)) + lineSeparator);
                if (i <= this.multiple_object_count_to_ffdc) continue;
                stringBuffer.append("........contd");
                break;
            }
        }
        stringBuffer.append('}');
        return stringBuffer.toString();
    }

    public final String toFFDCString(Map map) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('{');
        if (map == null) {
            stringBuffer.append("<null>");
        } else {
            Iterator iterator = map.entrySet().iterator();
            boolean bl = iterator.hasNext();
            int n = 0;
            while (bl) {
                Map.Entry entry = iterator.next();
                Object k = entry.getKey();
                Object v = entry.getValue();
                stringBuffer.append((k == map ? "<this map>" : this.toFFDCStringSingleObject(k)) + "=" + (v == map ? "<this map>" : this.toFFDCStringSingleObject(v)) + lineSeparator);
                bl = iterator.hasNext();
                if (n <= this.multiple_object_count_to_ffdc) continue;
                stringBuffer.append("........contd");
                bl = false;
            }
        }
        stringBuffer.append('}');
        return stringBuffer.toString();
    }

    static {
        if (_tc.isDebugEnabled()) {
            SibTr.debug(_tc, "Source info: @(#)SIB/ws/code/sib.utils/src/com/ibm/ws/sib/utils/ffdc/SibDiagnosticModule.java, SIB.utils, WAS602.SIB, o0610.11 1.14");
        }
        _singleton = null;
        SIB_PACKAGE_LIST = new String[]{"com.ibm.ws.sib", "com.ibm.wsspi.sib", "com.ibm.websphere.sib"};
        lineSeparator = System.getProperty("line.separator", "\n");
    }
}

