/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.utils;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.ws.sib.utils.TopicWildcardTranslation;
import java.text.ParseException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TopicWildcardTranslationImpl
extends TopicWildcardTranslation {
    private static TraceComponent tcInt = Tr.register((Class)TopicWildcardTranslation.class, (String)"SIBUtils", (String)"com.ibm.ws.sib.utils.CWSIUMessages");
    private static TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.utils.CWSIUMessages");
    private Pattern sibPattern = Pattern.compile("(//)?([^:./*][^:/*]*|[*])(//?([^:./*][^:/*]*|[*]|[.]))*");

    public String convertSIBToEventBroker(String string) throws ParseException {
        int n;
        if (tcInt.isEntryEnabled()) {
            Tr.entry((TraceComponent)tcInt, (String)"convertSIBToEventBroker");
        }
        if (tcInt.isEntryEnabled()) {
            Tr.debug((TraceComponent)tcInt, (String)("SIB Topic string to convert: " + string));
        }
        if ("//*".equals(string)) {
            return "#";
        }
        if ("*".equals(string)) {
            return "+";
        }
        int n2 = 0;
        while ((n = string.indexOf("//.", n2)) != -1) {
            string = string.substring(0, n) + "/#" + string.substring(n + 3);
            n2 = n + 1;
        }
        n2 = 0;
        while ((n = string.indexOf("/*", n2)) != -1) {
            string = string.replace('*', '+');
            n2 = n + 1;
        }
        n2 = 0;
        while ((n = string.indexOf("/./", n2)) != -1) {
            string = string.substring(0, n + 1) + string.substring(n + 3);
            n2 = n + 1;
        }
        if (string.startsWith("//")) {
            string = "#" + string.substring(1);
        }
        n2 = 0;
        while ((n = string.indexOf("//", n2)) != -1) {
            string = string.substring(0, n + 1) + "#" + string.substring(n + 1);
            n2 = n + 1;
        }
        if (tcInt.isEntryEnabled()) {
            Tr.debug((TraceComponent)tcInt, (String)("Returned topic string: " + string));
        }
        if (tcInt.isEntryEnabled()) {
            Tr.exit((TraceComponent)tcInt, (String)"convertSIBToEventBroker");
        }
        return string;
    }

    public String convertEventBrokerToSIB(String string) throws ParseException {
        int n;
        if (tcInt.isEntryEnabled()) {
            Tr.entry((TraceComponent)tcInt, (String)"convertEventBrokerToSIB");
        }
        if (tcInt.isEntryEnabled()) {
            Tr.debug((TraceComponent)tcInt, (String)("EB Topic string to convert: " + string));
        }
        if ("#".equals(string)) {
            return "//*";
        }
        if ("+".equals(string)) {
            return "*";
        }
        int n2 = 0;
        while ((n = string.indexOf("/#", n2)) != -1) {
            if (n + 2 == string.length()) {
                string = string.replace('#', '/');
                string = string.substring(0, n + 2) + "." + string.substring(n + 2);
                n2 = n + 1;
                continue;
            }
            string = string.substring(0, n + 1) + "/" + string.substring(n + 3);
            n2 = n + 1;
        }
        if (string.startsWith("#/")) {
            string = "/" + string.substring(1);
        }
        n2 = 0;
        while ((n = string.indexOf("/+", n2)) != -1) {
            string = string.replace('+', '*');
            n2 = n + 1;
        }
        if (tcInt.isEntryEnabled()) {
            Tr.debug((TraceComponent)tcInt, (String)("Returned topic string: " + string));
        }
        if (tcInt.isEntryEnabled()) {
            Tr.exit((TraceComponent)tcInt, (String)"convertEventBrokerToSIB");
        }
        return string;
    }

    public String convertMA0CToSIB(String string) throws ParseException {
        int n;
        if (tcInt.isEntryEnabled()) {
            Tr.entry((TraceComponent)tcInt, (String)"convertMA0CToXPath");
        }
        if (tcInt.isEntryEnabled()) {
            Tr.debug((TraceComponent)tcInt, (String)("MA0C Topic string to convert: " + string));
        }
        if (string.indexOf("?") != -1) {
            throw new ParseException(nls.getFormattedMessage("INVALID_WILDCARD_CHAR_CWSIU0011", new Object[]{"?", string}, null), 0);
        }
        if (string.startsWith("*")) {
            string = "/" + string;
        }
        int n2 = 0;
        while ((n = string.indexOf("*", n2)) != -1) {
            char c;
            boolean bl = false;
            if (n > 0 && (c = string.charAt(n - 1)) != '/') {
                bl = true;
                if (tcInt.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tcInt, (String)"Invalid MA0C topic - * is not preceeded by /");
                }
            }
            if (n < string.length() - 1 && (c = string.charAt(n + 1)) != '/') {
                bl = true;
                if (tcInt.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tcInt, (String)"Invalid MA0C topic - * is not followed by /");
                }
            }
            if (bl) {
                throw new ParseException(nls.getFormattedMessage("INVALID_ASTERIX_WILDCARD_CWSIU0012", new Object[]{string}, null), 0);
            }
            string = string.substring(0, n) + "/" + string.substring(n, string.length());
            n2 = n + 2;
        }
        if (tcInt.isEntryEnabled()) {
            Tr.debug((TraceComponent)tcInt, (String)("Returned topic string: " + string));
        }
        if (tcInt.isEntryEnabled()) {
            Tr.exit((TraceComponent)tcInt, (String)"convertMA0CToXPath");
        }
        return string;
    }

    public boolean isValidSIBTopic(String string) {
        if (tcInt.isEntryEnabled()) {
            Tr.entry((TraceComponent)tcInt, (String)"isValidSIBTopic");
        }
        if (tcInt.isDebugEnabled()) {
            Tr.debug((TraceComponent)tcInt, (String)("sibTopic: " + string));
        }
        boolean bl = false;
        if (string == null || "".equals(string)) {
            bl = true;
        } else {
            Matcher matcher = this.sibPattern.matcher(string);
            bl = matcher.matches();
        }
        if (tcInt.isEntryEnabled()) {
            Tr.exit((TraceComponent)tcInt, (String)"isValidSIBTopic", (Object)new Boolean(bl));
        }
        return bl;
    }
}

