/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.utils;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.utils.CryptoHash;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.rmi.server.UID;
import java.util.Arrays;
import java.util.Random;

abstract class SIBUuidLength {
    private static final String className = SIBUuidLength.class.getName();
    private byte[] uuid;
    private static final String ipaddress = SIBUuidLength.getIPAddress();
    private int hashcode;
    private int stringLength = 0;
    private String string;

    protected SIBUuidLength(int n) {
        this.uuid = new byte[n];
        try {
            do {
                byte[] byArray = new String(new UID().toString() + ipaddress).getBytes("UTF-8");
                CryptoHash.hash(byArray, this.uuid);
            } while (Arrays.equals(this.uuid, new byte[n]));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            FFDCFilter.processException((Throwable)unsupportedEncodingException, (String)(className + ".<init>"), (String)"1", (Object)this);
        }
    }

    protected SIBUuidLength(int n, byte[] byArray) {
        if (byArray == null) {
            throw new NullPointerException();
        }
        this.uuid = new byte[n];
        System.arraycopy(byArray, 0, this.uuid, 0, Math.min(this.uuid.length, byArray.length));
    }

    protected SIBUuidLength(int n, String string) {
        int n2;
        if (string == null) {
            throw new NullPointerException();
        }
        this.uuid = new byte[n];
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            n2 = string.charAt(i);
            if (n2 == 45) continue;
            stringBuffer.append((char)n2);
        }
        String string2 = stringBuffer.toString();
        n2 = 0;
        for (int i = 0; i < string2.length() && n2 < this.uuid.length; i += 2) {
            stringBuffer = new StringBuffer();
            stringBuffer.append(string2.substring(i, i + 1));
            if (i + 1 < string2.length()) {
                stringBuffer.append(string2.substring(i + 1, i + 2));
            } else {
                stringBuffer.append("0");
            }
            this.uuid[n2++] = (byte)Integer.parseInt(stringBuffer.toString(), 16);
        }
    }

    public byte[] toByteArray() {
        return this.uuid;
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (this == object) {
            bl = true;
        } else if (object != null && object.getClass() == this.getClass()) {
            bl = Arrays.equals(this.uuid, ((SIBUuidLength)object).uuid);
        }
        return bl;
    }

    public int hashCode() {
        if (this.hashcode == 0) {
            int n = 0;
            for (int i = 0; i < this.uuid.length; ++i) {
                n += this.uuid[i];
            }
            this.hashcode = n;
        }
        return this.hashcode;
    }

    public int getStringLength() {
        if (this.stringLength == 0) {
            this.stringLength = this.uuid.length * 2;
        }
        return this.stringLength;
    }

    public String toString() {
        char[] cArray = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        if (this.string == null) {
            char[] cArray2 = new char[this.getStringLength()];
            int n = 0;
            for (int i = 0; i < cArray2.length; ++i) {
                cArray2[i++] = cArray[(this.uuid[n] & 0xF0) >>> 4];
                cArray2[i] = cArray[(this.uuid[n++] & 0xF) >>> 0];
            }
            this.string = new String(cArray2);
        }
        return this.string;
    }

    private static String getIPAddress() {
        String string;
        try {
            string = InetAddress.getLocalHost().getHostAddress();
        }
        catch (Exception exception) {
            string = new Long(new Random().nextLong()).toString();
        }
        return string;
    }
}

