/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.trm.wlm.client;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.cluster.channel.ChannelSelectionAdapterImpl;
import com.ibm.ws.sib.trm.wlm.client.Identities;
import com.ibm.ws.sib.trm.wlm.client.Selection;
import com.ibm.ws.sib.trm.wlm.client.WaitForWLMData;
import com.ibm.ws.sib.utils.RuntimeInfo;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.cluster.Identity;
import com.ibm.wsspi.cluster.Target;
import com.ibm.wsspi.cluster.adapter.channel.ChannelSelectionAdapter;
import com.ibm.wsspi.cluster.adapter.channel.ChannelSelectionCriteria;
import com.ibm.wsspi.cluster.adapter.channel.ChannelTarget;
import com.ibm.wsspi.cluster.adapter.channel.NoAvailableEndPointException;
import com.ibm.wsspi.cluster.selection.NoApplicableTargetException;
import com.ibm.wsspi.cluster.selection.NoAvailableTargetException;
import com.ibm.wsspi.cluster.selection.SelectionCallback;
import com.ibm.wsspi.cluster.selection.SelectionCriteria;
import com.ibm.wsspi.cluster.selection.SelectionRule;
import com.ibm.wsspi.cluster.selection.SelectionService;
import com.ibm.wsspi.cluster.selection.SelectionServiceFactory;
import java.util.HashMap;
import java.util.Map;

public class Select {
    public static final String $ssccid = "@(#) 1.55 SIB/ws/code/sib.trm.client.impl/src/com/ibm/ws/sib/trm/wlm/client/Select.java, SIB.trm, WAS602.SIB, o0525.08 05/03/30 03:57:22 [6/23/05 06:31:13]";
    private static final TraceComponent tc = SibTr.register(Select.class, "SIBTrm", "com.ibm.ws.sib.trm.CWSITMessages");
    public static final ChannelSelectionAdapter channelSelectionAdapter;
    public static final SelectionService selectionService;
    private static byte[] normalMode;
    private static byte[] recoveryMode;
    private static SelectionRule[] localisedRules;
    private static SelectionRule[] nonLocalisedRules;
    private static final String lingerName = "sib.trm.linger";
    private static final String lingerDefault = "3";
    private static int lingerTime;

    public static Selection meLongName(String string, String string2, String string3) {
        return Select.meLongName(string, string2, string3, false, true);
    }

    public static Selection meLongName(String string, String string2, String string3, boolean bl, boolean bl2) {
        return Select.meLongName(string, string2, string3, null, bl, bl2);
    }

    public static Selection meLongName(String string, String string2, String string3, String string4) {
        return Select.meLongName(string, string2, string3, string4, false, true);
    }

    public static Selection meLongName(String string, String string2, String string3, String string4, boolean bl, boolean bl2) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "meLongName");
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "bus=" + string + ",subnet=" + string2 + ",name=" + string3 + ",transportChain=" + string4 + ",recovery=" + bl + ",localise=" + bl2);
        }
        Selection selection = null;
        Identity identity = Identities.getMeLongNameIdentity(string, string2, string3);
        Map map = Select.selectionMap(bl, bl2);
        if (string4 == null) {
            SelectionCriteria selectionCriteria = selectionService.getCriteria(identity, map);
            Target target = Select.select(selectionCriteria, true);
            if (target != null) {
                selection = new Selection(target, 0);
            }
        } else {
            ChannelSelectionCriteria channelSelectionCriteria = channelSelectionAdapter.getCriteria(identity, map, string4, null, null, false);
            ChannelTarget channelTarget = Select.select(channelSelectionCriteria, true);
            if (channelTarget != null) {
                selection = new Selection(channelTarget, 0);
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "meLongName");
        }
        return selection;
    }

    public static Selection meShortName(String string, String string2) {
        return Select.meShortName(string, string2, false, true);
    }

    public static Selection meShortName(String string, String string2, boolean bl, boolean bl2) {
        return Select.meShortName(string, string2, null, bl, bl2);
    }

    public static Selection meShortName(String string, String string2, String string3) {
        return Select.meShortName(string, string2, string3, false, true);
    }

    public static Selection meShortName(String string, String string2, String string3, boolean bl, boolean bl2) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "meShortName");
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "bus=" + string + ",name=" + string2 + ",transportChain=" + string3 + ",recovery=" + bl + ",localise=" + bl2);
        }
        Selection selection = null;
        Identity identity = Identities.getMeShortNameIdentity(string, string2);
        Map map = Select.selectionMap(bl, bl2);
        if (string3 == null) {
            SelectionCriteria selectionCriteria = selectionService.getCriteria(identity, map);
            Target target = Select.select(selectionCriteria, true);
            if (target != null) {
                selection = new Selection(target, 1);
            }
        } else {
            ChannelSelectionCriteria channelSelectionCriteria = channelSelectionAdapter.getCriteria(identity, map, string3, null, null, false);
            ChannelTarget channelTarget = Select.select(channelSelectionCriteria, true);
            if (channelTarget != null) {
                selection = new Selection(channelTarget, 1);
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "meShortName");
        }
        return selection;
    }

    public static Selection meUuid(String string) {
        return Select.meUuid(string, false, true);
    }

    public static Selection meUuid(String string, boolean bl, boolean bl2) {
        return Select.meUuid(string, null, bl, bl2);
    }

    public static Selection meUuid(String string, String string2) {
        return Select.meUuid(string, string2, false, true);
    }

    public static Selection meUuid(String string, String string2, boolean bl, boolean bl2) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "meUuid");
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "uuid=" + string + ",transportChain=" + string2 + ",recovery=" + bl + ",localise=" + bl2);
        }
        Selection selection = null;
        Identity identity = Identities.getMeUuidIdentity(string);
        Map map = Select.selectionMap(bl, bl2);
        if (string2 == null) {
            SelectionCriteria selectionCriteria = selectionService.getCriteria(identity, map);
            Target target = Select.select(selectionCriteria, true);
            if (target != null) {
                selection = new Selection(target, 1);
            }
        } else {
            ChannelSelectionCriteria channelSelectionCriteria = channelSelectionAdapter.getCriteria(identity, map, string2, null, null, false);
            ChannelTarget channelTarget = Select.select(channelSelectionCriteria, true);
            if (channelTarget != null) {
                selection = new Selection(channelTarget, 1);
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "meUuid");
        }
        return selection;
    }

    public static Selection fromBus(String string) {
        return Select.fromBus(string, false, true);
    }

    public static Selection fromBus(String string, boolean bl, boolean bl2) {
        return Select.fromBus(string, null, bl, bl2);
    }

    public static Selection fromBus(String string, String string2) {
        return Select.fromBus(string, string2, false, true);
    }

    public static Selection fromBus(String string, String string2, boolean bl, boolean bl2) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "fromBus");
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "bus=" + string + ",transportChain=" + string2 + ",recovery=" + bl + ",localise=" + bl2);
        }
        Selection selection = null;
        Identity identity = Identities.getBusIdentity(string);
        Map map = Select.selectionMap(bl, bl2);
        if (string2 == null) {
            SelectionCriteria selectionCriteria = selectionService.getCriteria(identity, map);
            Target target = Select.select(selectionCriteria, true);
            if (target != null) {
                selection = new Selection(target, 1);
            }
        } else {
            ChannelSelectionCriteria channelSelectionCriteria = channelSelectionAdapter.getCriteria(identity, map, string2, null, null, false);
            ChannelTarget channelTarget = Select.select(channelSelectionCriteria, true);
            if (channelTarget != null) {
                selection = new Selection(channelTarget, 1);
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "fromBus");
        }
        return selection;
    }

    public static Selection fromBusMember(String string, String string2) {
        return Select.fromBusMember(string, string2, false, true);
    }

    public static Selection fromBusMember(String string, String string2, boolean bl, boolean bl2) {
        return Select.fromBusMember(string, string2, null, bl, bl2);
    }

    public static Selection fromBusMember(String string, String string2, String string3) {
        return Select.fromBusMember(string, string2, string3, false, true);
    }

    public static Selection fromBusMember(String string, String string2, String string3, boolean bl, boolean bl2) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "fromBusMember");
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "bus=" + string + ",busMember=" + string2 + ",transportChain=" + string3 + ",recovery=" + bl + ",localise=" + bl2);
        }
        Selection selection = null;
        Identity identity = Identities.getBusMemberIdentity(string, string2);
        Map map = Select.selectionMap(bl, bl2);
        if (string3 == null) {
            SelectionCriteria selectionCriteria = selectionService.getCriteria(identity, map);
            Target target = Select.select(selectionCriteria, true);
            if (target != null) {
                selection = new Selection(target, 1);
            }
        } else {
            ChannelSelectionCriteria channelSelectionCriteria = channelSelectionAdapter.getCriteria(identity, map, string3, null, null, false);
            ChannelTarget channelTarget = Select.select(channelSelectionCriteria, true);
            if (channelTarget != null) {
                selection = new Selection(channelTarget, 1);
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "fromBusMember");
        }
        return selection;
    }

    public static Selection fromSubnet(String string, String string2) {
        return Select.fromSubnet(string, string2, false, true);
    }

    public static Selection fromSubnet(String string, String string2, boolean bl, boolean bl2) {
        return Select.fromSubnet(string, string2, null, bl, bl2);
    }

    public static Selection fromSubnet(String string, String string2, String string3) {
        return Select.fromSubnet(string, string2, string3, false, true);
    }

    public static Selection fromSubnet(String string, String string2, String string3, boolean bl, boolean bl2) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "fromSubnet");
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "bus=" + string + ",subnet=" + string2 + ",transportChain=" + string3 + ",recovery=" + bl + ",localise=" + bl2);
        }
        Selection selection = null;
        Identity identity = Identities.getSubnetIdentity(string, string2);
        Map map = Select.selectionMap(bl, bl2);
        if (string3 == null) {
            SelectionCriteria selectionCriteria = selectionService.getCriteria(identity, map);
            Target target = Select.select(selectionCriteria, true);
            if (target != null) {
                selection = new Selection(target, 1);
            }
        } else {
            ChannelSelectionCriteria channelSelectionCriteria = channelSelectionAdapter.getCriteria(identity, map, string3, null, null, false);
            ChannelTarget channelTarget = Select.select(channelSelectionCriteria, true);
            if (channelTarget != null) {
                selection = new Selection(channelTarget, 1);
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "fromSubnet");
        }
        return selection;
    }

    public static Selection fromCluster(String string, String string2) {
        return Select.fromCluster(string, string2, false, true);
    }

    public static Selection fromCluster(String string, String string2, boolean bl, boolean bl2) {
        return Select.fromCluster(string, string2, null, bl, bl2);
    }

    public static Selection fromCluster(String string, String string2, String string3) {
        return Select.fromCluster(string, string2, string3, false, true);
    }

    public static Selection fromCluster(String string, String string2, String string3, boolean bl, boolean bl2) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "fromCluster");
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "bus=" + string + ",cluster=" + string2 + ",transportChain=" + string3 + ",recovery=" + bl + ",localise=" + bl2);
        }
        Selection selection = null;
        Identity identity = Identities.getClusterIdentity(string, string2);
        Map map = Select.selectionMap(bl, bl2);
        if (string3 == null) {
            SelectionCriteria selectionCriteria = selectionService.getCriteria(identity, map);
            Target target = Select.select(selectionCriteria, true);
            if (target != null) {
                selection = new Selection(target, 1);
            }
        } else {
            ChannelSelectionCriteria channelSelectionCriteria = channelSelectionAdapter.getCriteria(identity, map, string3, null, null, false);
            ChannelTarget channelTarget = Select.select(channelSelectionCriteria, true);
            if (channelTarget != null) {
                selection = new Selection(channelTarget, 1);
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "fromCluster");
        }
        return selection;
    }

    public static Selection fromServer(String string, String string2) {
        return Select.fromServer(string, string2, false, true);
    }

    public static Selection fromServer(String string, String string2, boolean bl, boolean bl2) {
        return Select.fromServer(string, string2, null, bl, bl2);
    }

    public static Selection fromServer(String string, String string2, String string3) {
        return Select.fromServer(string, string2, string3, false, true);
    }

    public static Selection fromServer(String string, String string2, String string3, boolean bl, boolean bl2) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "fromServer");
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "bus=" + string + ",server=" + string2 + ",transportChain=" + string3 + ",recovery=" + bl + ",localise=" + bl2);
        }
        Selection selection = null;
        Identity identity = Identities.getServerIdentity(string, string2);
        Map map = Select.selectionMap(bl, bl2);
        if (string3 == null) {
            SelectionCriteria selectionCriteria = selectionService.getCriteria(identity, map);
            Target target = Select.select(selectionCriteria, true);
            if (target != null) {
                selection = new Selection(target, 1);
            }
        } else {
            ChannelSelectionCriteria channelSelectionCriteria = channelSelectionAdapter.getCriteria(identity, map, string3, null, null, false);
            ChannelTarget channelTarget = Select.select(channelSelectionCriteria, true);
            if (channelTarget != null) {
                selection = new Selection(channelTarget, 1);
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "fromServer");
        }
        return selection;
    }

    public static Selection fromCustom(String string, String string2) {
        return Select.fromCustom(string, string2, false, true);
    }

    public static Selection fromCustom(String string, String string2, boolean bl, boolean bl2) {
        return Select.fromCustom(string, string2, null, bl, bl2);
    }

    public static Selection fromCustom(String string, String string2, String string3) {
        return Select.fromCustom(string, string2, string3, false, true);
    }

    public static Selection fromCustom(String string, String string2, String string3, boolean bl, boolean bl2) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "fromCustom");
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "bus=" + string + ",group=" + string2 + ",transportChain=" + string3 + ",recovery=" + bl + ",localise=" + bl2);
        }
        Selection selection = null;
        Identity identity = Identities.getCustomIdentity(string, string2);
        Map map = Select.selectionMap(bl, bl2);
        if (string3 == null) {
            SelectionCriteria selectionCriteria = selectionService.getCriteria(identity, map);
            Target target = Select.select(selectionCriteria, true);
            if (target != null) {
                selection = new Selection(target, 1);
            }
        } else {
            ChannelSelectionCriteria channelSelectionCriteria = channelSelectionAdapter.getCriteria(identity, map, string3, null, null, false);
            ChannelTarget channelTarget = Select.select(channelSelectionCriteria, true);
            if (channelTarget != null) {
                selection = new Selection(channelTarget, 1);
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "fromCustom");
        }
        return selection;
    }

    public static Selection fromDestination(String string, String string2) {
        return Select.fromDestination(string, string2, false, true);
    }

    public static Selection fromDestination(String string, String string2, boolean bl, boolean bl2) {
        return Select.fromDestination(string, string2, null, bl, bl2);
    }

    public static Selection fromDestination(String string, String string2, String string3) {
        return Select.fromDestination(string, string2, string3, false, true);
    }

    public static Selection fromDestination(String string, String string2, String string3, boolean bl, boolean bl2) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "fromDestination");
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "bus=" + string + ",destination=" + string2 + ",transportChain=" + string3 + ",recovery=" + bl + ",localise=" + bl2);
        }
        Selection selection = null;
        Identity identity = Identities.getDestinationNameIdentity(string, string2);
        Map map = Select.selectionMap(bl, bl2);
        if (string3 == null) {
            SelectionCriteria selectionCriteria = selectionService.getCriteria(identity, map);
            Target target = Select.select(selectionCriteria, true);
            if (target != null) {
                selection = new Selection(target, 1);
            }
        } else {
            ChannelSelectionCriteria channelSelectionCriteria = channelSelectionAdapter.getCriteria(identity, map, string3, null, null, false);
            ChannelTarget channelTarget = Select.select(channelSelectionCriteria, true);
            if (channelTarget != null) {
                selection = new Selection(channelTarget, 1);
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "fromDestination");
        }
        return selection;
    }

    protected static Map selectionMap(boolean bl, boolean bl2) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "selectionMap");
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "recovery=" + bl + ",localise=" + bl2);
        }
        HashMap<String, Object[]> hashMap = new HashMap<String, Object[]>();
        if (!bl) {
            hashMap.put("AcceptableStates", normalMode);
        } else {
            hashMap.put("AcceptableStates", recoveryMode);
        }
        if (bl2) {
            hashMap.put("rules.precedence", localisedRules);
        } else {
            hashMap.put("rules.precedence", nonLocalisedRules);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "selectionMap");
        }
        return hashMap;
    }

    protected static Target select(SelectionCriteria selectionCriteria, boolean bl) {
        return Select.select(selectionCriteria, bl, null);
    }

    protected static Target select(SelectionCriteria selectionCriteria, boolean bl, SelectionCallback selectionCallback) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "select", new Object[]{selectionCriteria, new Boolean(bl), selectionCallback});
        }
        Target target = null;
        long l = System.currentTimeMillis() + (long)(lingerTime * 1000);
        NoAvailableTargetException noAvailableTargetException = null;
        do {
            try {
                target = selectionService.select(selectionCriteria);
            }
            catch (NoAvailableTargetException noAvailableTargetException2) {
                SibTr.exception(tc, (Exception)((Object)noAvailableTargetException2));
                noAvailableTargetException = noAvailableTargetException2;
                long l2 = System.currentTimeMillis();
                if (l2 >= l) {
                    bl = false;
                }
                if (!bl) continue;
                target = new WaitForWLMData().sleep(noAvailableTargetException2, l - l2);
            }
        } while (target == null && bl);
        if (target == null && selectionCallback != null) {
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "Registering supplied SelectionCallback");
            }
            noAvailableTargetException.callbackWhenAvailable(selectionCallback, null);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "select", target);
        }
        return target;
    }

    protected static ChannelTarget select(ChannelSelectionCriteria channelSelectionCriteria, boolean bl) {
        ChannelTarget channelTarget = null;
        long l = System.currentTimeMillis() + (long)(lingerTime * 1000);
        do {
            long l2;
            try {
                channelTarget = channelSelectionAdapter.select(channelSelectionCriteria);
            }
            catch (NoAvailableEndPointException noAvailableEndPointException) {
                SibTr.exception(tc, (Exception)((Object)noAvailableEndPointException));
                l2 = System.currentTimeMillis();
                if (l2 >= l) {
                    bl = false;
                }
                if (!bl) continue;
                channelTarget = new WaitForWLMData().sleep(noAvailableEndPointException, l - l2);
            }
            catch (NoApplicableTargetException noApplicableTargetException) {
                SibTr.exception(tc, (Exception)((Object)noApplicableTargetException));
                l2 = System.currentTimeMillis();
                if (l2 >= l) {
                    bl = false;
                }
                if (!bl) continue;
                channelTarget = new WaitForWLMData().sleep(noApplicableTargetException, l - l2);
            }
        } while (channelTarget == null && bl);
        return channelTarget;
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "Source Info: @(#) 1.55 SIB/ws/code/sib.trm.client.impl/src/com/ibm/ws/sib/trm/wlm/client/Select.java, SIB.trm, WAS602.SIB, o0525.08 05/03/30 03:57:22 [6/23/05 06:31:13]");
        }
        channelSelectionAdapter = new ChannelSelectionAdapterImpl();
        selectionService = SelectionServiceFactory.getSelectionService();
        normalMode = new byte[]{0};
        recoveryMode = new byte[]{0, 9};
        Object object = selectionService.getRule("rule.local.process");
        SelectionRule selectionRule = selectionService.getRule("rule.local.server");
        SelectionRule selectionRule2 = selectionService.getRule("rule.local.host");
        SelectionRule selectionRule3 = selectionService.getRule("rule.local.cell");
        localisedRules = new SelectionRule[]{object, selectionRule, selectionRule2, selectionRule3};
        nonLocalisedRules = new SelectionRule[]{selectionRule3};
        object = RuntimeInfo.getPropertyWithMsg(lingerName, lingerDefault);
        lingerTime = new Integer((String)object);
    }
}

