/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.trm.client;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.comms.ClientConnection;
import com.ibm.ws.sib.mfp.trm.TrmClientBootstrapRequest;
import com.ibm.ws.sib.mfp.trm.TrmFirstContactMessageType;
import com.ibm.ws.sib.mfp.trm.TrmMessageFactory;
import com.ibm.ws.sib.trm.client.ClientAttachProperties;
import com.ibm.ws.sib.trm.client.ClientHandler;
import com.ibm.ws.sib.trm.client.CredentialType;
import com.ibm.ws.sib.trm.client.Utils;
import com.ibm.ws.sib.utils.ras.SibTr;

class ClientBootstrapHandler
extends ClientHandler {
    public static final String $ssccid = "@(#) 1.40 SIB/ws/code/sib.trm.client.impl/src/com/ibm/ws/sib/trm/client/ClientBootstrapHandler.java, SIB.trm, WAS602.SIB, o0610.11 05/04/12 03:26:38 [3/13/06 13:38:58]";
    private String bootstrapTransportChain;

    public ClientBootstrapHandler(ClientAttachProperties clientAttachProperties, CredentialType credentialType, String string) {
        super(clientAttachProperties, credentialType);
        this.bootstrapTransportChain = string;
    }

    public boolean connect(ClientConnection clientConnection) {
        boolean bl = true;
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "connect");
        }
        try {
            TrmMessageFactory trmMessageFactory = TrmMessageFactory.getInstance();
            TrmClientBootstrapRequest trmClientBootstrapRequest = trmMessageFactory.createNewTrmClientBootstrapRequest();
            trmClientBootstrapRequest.setBusName(this.cap.getBusName());
            trmClientBootstrapRequest.setCredentialType(this.credentialType.getCredentialType());
            trmClientBootstrapRequest.setUserid(this.credentialType.getUserid());
            trmClientBootstrapRequest.setPassword(this.credentialType.getPassword());
            trmClientBootstrapRequest.setTargetGroupName(this.cap.getTargetGroupName());
            trmClientBootstrapRequest.setTargetGroupType(this.cap.getTargetGroupType());
            trmClientBootstrapRequest.setTargetSignificance(this.cap.getTargetSignificance());
            trmClientBootstrapRequest.setConnectionProximity(this.cap.getConnectionProximity());
            trmClientBootstrapRequest.setTargetTransportChain(this.cap.getTargetTransportChain());
            trmClientBootstrapRequest.setBootstrapTransportChain(this.bootstrapTransportChain);
            trmClientBootstrapRequest.setConnectionMode(this.cap.getConnectionMode());
            byte[] byArray = trmClientBootstrapRequest.encode(clientConnection);
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, Utils.outBound("client bootstrap request"));
            }
            byte[] byArray2 = clientConnection.trmHandshakeExchange(byArray);
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, Utils.inBound("client bootstrap reply"));
            }
            this.fcm = trmMessageFactory.createInboundTrmFirstContactMessage(byArray2, 0, byArray2.length);
            if (this.fcm.getMessageType() != TrmFirstContactMessageType.CLIENT_BOOTSTRAP_REPLY) {
                SibTr.error(tc, "PROTOCOL_ERROR_CWSIT0038", new Object[]{this.cap.getBusName(), this.fcm.getMessageType().toString(), TrmFirstContactMessageType.CLIENT_BOOTSTRAP_REPLY.toString()});
                bl = false;
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)(className + ".connect"), (String)"1", (Object)this);
            SibTr.exception(tc, exception);
            bl = false;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "connect", (Object)("rc=" + bl));
        }
        return bl;
    }

    static {
        className = ClientBootstrapHandler.class.getName();
        tc = SibTr.register(className, "SIBTrm", "com.ibm.ws.sib.trm.CWSITMessages");
        nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.trm.CWSITMessages");
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "Source Info: @(#) 1.40 SIB/ws/code/sib.trm.client.impl/src/com/ibm/ws/sib/trm/client/ClientBootstrapHandler.java, SIB.trm, WAS602.SIB, o0610.11 05/04/12 03:26:38 [3/13/06 13:38:58]");
        }
    }
}

