/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.multicast.rmm.impl;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.rmm.transmitter.RMTransmitter;
import com.ibm.rmm.transmitter.TopicT;
import com.ibm.rmm.util.LogEventListener;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.comms.pmi.CommsPMI;
import com.ibm.ws.sib.jfapchannel.JFapChannelConstants;
import com.ibm.ws.sib.mfp.JsMessage;
import com.ibm.ws.sib.mfp.MessageEncodeFailedException;
import com.ibm.ws.sib.multicast.MulticastTransmitter;
import com.ibm.ws.sib.multicast.rmm.impl.JSRMMConstants;
import com.ibm.ws.sib.multicast.rmm.impl.JSRMMLogEventListener;
import com.ibm.ws.sib.multicast.rmm.impl.RMMFactory;
import com.ibm.ws.sib.multicast.rmm.impl.StreamWrapper;
import com.ibm.ws.sib.processor.MulticastProperties;
import com.ibm.ws.sib.utils.RuntimeInfo;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.SIBusMessage;
import com.ibm.wsspi.sib.core.exception.SIConnectionLostException;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.List;
import java.util.Properties;

public class JSRMMTransmitter
implements MulticastTransmitter,
JSRMMConstants {
    private static final TraceComponent tc = SibTr.register(JSRMMTransmitter.class, "SIBCommunications", "com.ibm.ws.sib.multicast.SICMMessages");
    private static RMTransmitter rmmT;
    private static int rmTransmitterUseCount;
    private String multicastGroup;
    private String streamId;
    private TopicT topicT;
    private byte packetNum = 0;
    private StreamWrapper id;
    private int useCount = 0;
    private RMMFactory factory = null;

    private static RMTransmitter instantiateTransmitter(MulticastProperties multicastProperties) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "instatiateTransmitter");
        }
        Properties properties = new Properties();
        properties.setProperty("DataPort", "" + multicastProperties.getMulticastPort());
        properties.setProperty("PacketSizeBytes", "" + multicastProperties.getMulticastPacketSize());
        properties.setProperty("McastSocketTTL", "" + multicastProperties.getMulticastTTL());
        properties.setProperty("MulticastInterface", multicastProperties.getMulticastInterfaceAddress());
        properties.setProperty("LimitTransRate", RuntimeInfo.getPropertyWithMsg("sib.comms.MulticastTxLimitTransRate", "Disabled"));
        properties.setProperty("TransRateLimitKbps", RuntimeInfo.getPropertyWithMsg("sib.comms.MulticastTxTransRateLimitKbps", "55000"));
        properties.setProperty("NackAccumulationTimeMillis", RuntimeInfo.getPropertyWithMsg("sib.comms.MulticastTxNackAccumulationTimeMillis", "300"));
        properties.setProperty("HeartbeatTimeoutSec", RuntimeInfo.getPropertyWithMsg("sib.comms.MulticastTxHeartbeatTimeoutSec", "5"));
        properties.setProperty("MinimalHistoryKBytes", RuntimeInfo.getPropertyWithMsg("sib.comms.MulticastTxMinimalHistoryKBytes", "50000"));
        properties.setProperty("LogLevel", RuntimeInfo.getPropertyWithMsg("sib.comms.MulticastLogLevel", "none"));
        properties.setProperty("DebugLevel", RuntimeInfo.getPropertyWithMsg("sib.comms.MulticastDebugLevel", "none"));
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "Getting transmitter with the following params:", properties);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "instatiateTransmitter");
        }
        return RMTransmitter.getInstance((Properties)properties, (int)2, (int)0, (LogEventListener)new JSRMMLogEventListener());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSRMMTransmitter(String string, MulticastProperties multicastProperties, StreamWrapper streamWrapper, RMMFactory rMMFactory) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "<init>", new Object[]{string, multicastProperties, streamWrapper, rMMFactory});
        }
        this.multicastGroup = multicastProperties.getMulticastGroupAddress();
        this.streamId = string;
        this.id = streamWrapper;
        this.factory = rMMFactory;
        if (rmmT == null) {
            rmmT = JSRMMTransmitter.instantiateTransmitter(multicastProperties);
        }
        JSRMMTransmitter jSRMMTransmitter = this;
        synchronized (jSRMMTransmitter) {
            ++rmTransmitterUseCount;
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "Transmitter is bound to " + rmmT.getRmmAddress().getInetAddress());
        }
        this.topicT = rmmT.createTopicTransmitter(string, multicastProperties.isReliable(), this.multicastGroup);
        if (tc.isDebugEnabled()) {
            SibTr.debug(this, tc, "Created RMM Transmitter.", this.id);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "<init>");
        }
    }

    public void send(SIBusMessage sIBusMessage) throws MessageEncodeFailedException, SIConnectionLostException {
        int n;
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "send", sIBusMessage);
        }
        JsMessage jsMessage = (JsMessage)sIBusMessage;
        List list = jsMessage.encode(null);
        int n2 = 0;
        for (n = 0; n < list.size(); ++n) {
            n2 += ((byte[])list.get(n)).length;
        }
        n = n2 + JFAP_PROXY_MESSAGE_HEADER_END;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(n);
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            dataOutputStream.write(HDR_EYE_CATCHER);
            dataOutputStream.writeInt(n);
            dataOutputStream.writeShort(JFapChannelConstants.getJFAPPriority(sIBusMessage.getPriority()));
            byte by = this.packetNum;
            this.packetNum = (byte)(by + 1);
            dataOutputStream.writeByte(by);
            dataOutputStream.writeByte(241);
            dataOutputStream.writeLong(n2);
            for (int i = 0; i < list.size(); ++i) {
                dataOutputStream.write((byte[])list.get(i));
            }
            byte[] byArray = byteArrayOutputStream.toByteArray();
            if (tc.isDebugEnabled()) {
                SibTr.debug(this, tc, "About to send message to " + this.multicastGroup + " on stream " + this.streamId);
                SibTr.bytes(this, tc, byArray);
            }
            this.topicT.submitMessage(byArray);
            CommsPMI.getClientStats().onMulticastWriteMessage();
            CommsPMI.getClientStats().onMulticastWriteBytes(byArray.length);
            CommsPMI.getClientStats().onWriteBytes(byArray.length);
            if (tc.isDebugEnabled()) {
                SibTr.debug(this, tc, "sent message of size " + byArray.length);
            }
        }
        catch (IOException iOException) {
            FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.sib.multicast.rmm.impl.JSRMMTransmitter", (String)"1-001", (Object)this);
            if (tc.isDebugEnabled()) {
                SibTr.debug(this, tc, "Unable to build message", iOException);
            }
            throw new SIConnectionLostException(null, iOException);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "send");
        }
    }

    public synchronized void incrementUseCount() {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "incrementUseCount");
        }
        ++this.useCount;
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "incrementUseCount");
        }
    }

    public synchronized void close() {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "close");
        }
        --rmTransmitterUseCount;
        if (tc.isDebugEnabled()) {
            SibTr.debug(this, tc, "Transmitter Use count is now: " + rmTransmitterUseCount);
        }
        --this.useCount;
        if (tc.isDebugEnabled()) {
            SibTr.debug(this, tc, "Use count is now: " + this.useCount);
        }
        if (this.useCount == 0) {
            this.topicT.close();
            this.topicT = null;
            this.factory.closed(this);
            if (rmTransmitterUseCount == 0) {
                if (tc.isDebugEnabled()) {
                    SibTr.debug(this, tc, "Shutting down RMTransmitter");
                }
                rmmT.stop();
                rmmT = null;
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "close");
        }
    }

    protected StreamWrapper getId() {
        return this.id;
    }

    static {
        rmTransmitterUseCount = 0;
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "@(#)SIB/ws/code/sib.multicast.rmm.impl/src/com/ibm/ws/sib/multicast/rmm/impl/JSRMMTransmitter.java, SIB.comms, WAS602.SIB, o0610.11 1.12");
        }
    }
}

