/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.mfp.sdo.soap.write;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.ws.sib.mfp.sdo.mime.MimeElement;
import com.ibm.ws.sib.mfp.sdo.mime.MimeElementList;
import com.ibm.ws.sib.mfp.sdo.mime.MimeFactory;
import com.ibm.ws.sib.mfp.sdo.resource.ResourceException;
import com.ibm.ws.sib.mfp.sdo.resource.WSDLMetaData;
import com.ibm.ws.sib.mfp.sdo.resource.XSDMetaData;
import com.ibm.ws.sib.mfp.sdo.soap.DocumentScanner;
import com.ibm.ws.sib.mfp.sdo.soap.SOAPFormatDescriptor;
import com.ibm.ws.sib.mfp.sdo.soap.parse.InfoNodeStore;
import com.ibm.ws.sib.mfp.sdo.soap.parse.MIMEPartHandler;
import com.ibm.ws.sib.mfp.sdo.soap.parse.ParseState;
import com.ibm.ws.sib.mfp.sdo.soap.write.BasicXMLWriter;
import com.ibm.ws.sib.mfp.sdo.soap.write.BindingUtil;
import com.ibm.ws.sib.mfp.sdo.soap.write.NamespaceContext;
import com.ibm.ws.sib.mfp.sdo.soap.write.OutputUtil;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.sdo.DataMediatorException;
import commonj.sdo.DataObject;
import commonj.sdo.Property;
import commonj.sdo.Type;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.wsdl.extensions.mime.MIMEContent;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.sdo.EProperty;
import org.eclipse.emf.ecore.sdo.impl.DynamicEStoreEDataObjectImpl;
import org.eclipse.emf.ecore.sdo.util.SDOUtil;
import org.eclipse.emf.ecore.util.ExtendedMetaData;

public class SOAPWriter {
    private static TraceComponent tc = SibTr.register(SOAPWriter.class, "SIBMfp", "com.ibm.ws.sib.mfp.CWSIFMessages");
    private static TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.mfp.CWSIFMessages");
    private static final String SOAP_ENVELOPE_URI = "http://schemas.xmlsoap.org/soap/envelope/";
    private NamespaceContext namespaceContext;
    private SOAPFormatDescriptor descriptor;
    private WSDLMetaData meta;
    private XSDMetaData xsdMeta;
    private OutputUtil util;
    private BasicXMLWriter writer;
    private Map soapParts;
    private Map mimeParts;
    private MimeElementList mimeElements;
    private Map boundMimeElements = new HashMap();
    private List boundHeaderParts;
    private boolean messagesMatch;

    public SOAPWriter(WSDLMetaData wSDLMetaData, XSDMetaData xSDMetaData) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "<init>");
        }
        this.meta = wSDLMetaData;
        this.xsdMeta = xSDMetaData;
        this.util = new OutputUtil(this);
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "<init>");
        }
    }

    NamespaceContext getNamespaceContext() {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "getNamespaceContext");
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "getNamespaceContext");
        }
        return this.namespaceContext;
    }

    SOAPFormatDescriptor getDescriptor() {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "getDescriptor");
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "getDescriptor");
        }
        return this.descriptor;
    }

    OutputUtil getOutputUtil() {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "getOutputUtil");
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "getOutputUtil");
        }
        return this.util;
    }

    WSDLMetaData getWsdlMetaData() {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "getWsdlMetaData");
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "getWsdlMetaData", this.meta);
        }
        return this.meta;
    }

    XSDMetaData getXsdMetaData() {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "getXsdMetaData");
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "getXsdMetaData", this.xsdMeta);
        }
        return this.xsdMeta;
    }

    String getSOAPEnvelopeNamespace() {
        return SOAP_ENVELOPE_URI;
    }

    public String write(OutputStream outputStream, DataObject dataObject, SOAPFormatDescriptor sOAPFormatDescriptor, boolean bl) throws DataMediatorException, IOException, ResourceException {
        int n;
        Object object;
        int n2;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        Object object6;
        Object object7;
        Object object8;
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "write");
        }
        this.namespaceContext = new NamespaceContext(this);
        this.writer = new BasicXMLWriter(this);
        this.descriptor = sOAPFormatDescriptor;
        if ((dataObject = dataObject.getDataObject("Info")) instanceof DynamicEStoreEDataObjectImpl && (object8 = (object7 = (DynamicEStoreEDataObjectImpl)dataObject).eStore()) instanceof InfoNodeStore) {
            object6 = new BindingUtil(this.meta);
            object5 = (InfoNodeStore)object8;
            object4 = ((InfoNodeStore)object5).getDescriptor();
            object3 = ((InfoNodeStore)object5).getInitialMessage();
            if (object3 != null && ((BindingUtil)object6).sameBinding((SOAPFormatDescriptor)object4, this.descriptor)) {
                object2 = object3.getData();
                int n3 = object3.getStartOffset();
                int n4 = object3.getLength();
                n2 = 1;
                object = "Content-Type".getBytes("US-ASCII");
                for (n = 0; n < ((byte[])object).length; ++n) {
                    if (n4 >= n && object[n] == object2[n3 + n]) continue;
                    n2 = 0;
                    break;
                }
                if (n2 != 0 && !bl) {
                    object3 = null;
                }
                if (object3 != null) {
                    String string = object3.getContentType();
                    if (bl && string != null && string.length() > 0) {
                        outputStream.write(string.getBytes("US-ASCII"));
                        outputStream.write("\n\n".getBytes("US-ASCII"));
                        string = null;
                    }
                    outputStream.write(object3.getData(), object3.getStartOffset(), object3.getLength());
                    outputStream.flush();
                    if (tc.isEntryEnabled()) {
                        SibTr.exit(tc, "write", (Object)string);
                    }
                    return string;
                }
            }
        }
        this.descriptor.setOperationName(dataObject.getString("operationName"));
        this.descriptor.setMessageName(dataObject.getString("messageName"));
        this.descriptor.setMessageType(dataObject.getString("messageType"));
        this.messagesMatch = false;
        if (dataObject instanceof DynamicEStoreEDataObjectImpl && (object8 = (object7 = (DynamicEStoreEDataObjectImpl)dataObject).eStore()) instanceof InfoNodeStore) {
            object6 = (InfoNodeStore)object8;
            object5 = ((InfoNodeStore)object6).getDescriptor();
            object4 = new BindingUtil(this.meta);
            this.messagesMatch = ((BindingUtil)object4).sameMessage((SOAPFormatDescriptor)object5, this.descriptor);
        }
        this.soapParts = this.meta.getSOAPParts(this.descriptor);
        this.mimeParts = this.meta.getMIMEParts(this.descriptor);
        this.boundHeaderParts = this.meta.getBoundHeaderParts(this.descriptor);
        object7 = null;
        object8 = dataObject.getList("attachments");
        if (object8.size() > 0 || this.mimeParts.size() > 0) {
            this.mimeElements = MimeFactory.createEmptyMimeMessageParser("boundary");
            object6 = object8.iterator();
            while (object6.hasNext()) {
                MimeElement mimeElement;
                Object object9;
                object5 = (DataObject)object6.next();
                object4 = object5.getString("contentId");
                object3 = object5.getString("contentType");
                object2 = object5.getString("contentTransferEncoding");
                Type type = object5.getType();
                if (object2 == null || ((String)object2).length() == 0) {
                    object2 = "binary";
                }
                if ("MIMEAttachmentEntryType".equals(type.getName())) {
                    if (object4 == null || ((String)object4).length() == 0) {
                        n2 = System.identityHashCode(object5);
                        object4 = Integer.toString(n2, 16);
                    }
                    object9 = object5.getBytes("data");
                    mimeElement = MimeFactory.createNewMimeElement((byte[])object9, 0, ((Object)object9).length, (String)object3, (String)object4, (String)object2);
                } else {
                    Object object10;
                    object9 = object5.getString("messagePart");
                    object = dataObject.get("body/" + (String)object9);
                    if (object4 == null || ((String)object4).length() == 0) {
                        n = System.identityHashCode(object5);
                        object4 = (String)object9 + "=" + Integer.toString(n, 16) + "@ibm.com";
                    }
                    if (object instanceof byte[]) {
                        object10 = object;
                        mimeElement = MimeFactory.createNewMimeElement(object10, 0, ((byte[])object10).length, (String)object3, (String)object4, (String)object2);
                    } else {
                        object10 = (String)object;
                        mimeElement = MimeFactory.createNewMimeElement((String)object10, (String)object3, (String)object4, (String)object2);
                    }
                    this.boundMimeElements.put(object9, mimeElement);
                }
                this.mimeElements.add(mimeElement);
            }
            object5 = new ByteArrayOutputStream();
            object4 = new OutputStreamWriter((OutputStream)object5, "UTF-8");
            this.writeEnvelope((OutputStreamWriter)object4, dataObject);
            ((OutputStreamWriter)object4).close();
            object3 = ((ByteArrayOutputStream)object5).toByteArray();
            object2 = MimeFactory.createNewMimeElement((byte[])object3, 0, ((Object)object3).length, "text/xml", "start", "7bit");
            this.mimeElements.add(0, object2);
            this.mimeElements.setStartPart((MimeElement)object2);
            object3 = this.mimeElements.flatten();
            object7 = this.mimeElements.getContentHeader();
            if (bl) {
                outputStream.write(((String)object7).getBytes("US-ASCII"));
                outputStream.write("\n\n".getBytes("US-ASCII"));
            }
            outputStream.write((byte[])object3);
            outputStream.flush();
        } else {
            object6 = new OutputStreamWriter(outputStream, "UTF-8");
            this.writeEnvelope((OutputStreamWriter)object6, dataObject);
            ((OutputStreamWriter)object6).flush();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "write");
        }
        return object7;
    }

    private void writeEnvelope(OutputStreamWriter outputStreamWriter, DataObject dataObject) throws IOException, DataMediatorException, ResourceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "writeEnvelope");
        }
        this.namespaceContext.push();
        outputStreamWriter.write(60);
        String string = this.namespaceContext.getPrefix(SOAP_ENVELOPE_URI, "env");
        this.util.writeQName(outputStreamWriter, "Envelope", string);
        if (this.descriptor.getServiceNamespace() != null) {
            this.namespaceContext.getPrefix(this.descriptor.getServiceNamespace(), null);
        }
        if (this.isSOAPEncoded(dataObject)) {
            this.namespaceContext.getPrefix("http://www.w3.org/2001/XMLSchema", "xsd");
            this.namespaceContext.getPrefix("http://www.w3.org/2001/XMLSchema-instance", "xsi");
            this.namespaceContext.getPrefix("http://schemas.xmlsoap.org/soap/encoding/", "enc");
        }
        this.namespaceContext.writeDeclarations(outputStreamWriter);
        outputStreamWriter.write(62);
        this.writeHeaders(outputStreamWriter, dataObject);
        this.writeBody(outputStreamWriter, dataObject);
        outputStreamWriter.write("</");
        this.util.writeQName(outputStreamWriter, "Envelope", string);
        outputStreamWriter.write(62);
        this.namespaceContext.pop();
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "writeEnvelope");
        }
    }

    private void writeHeaders(OutputStreamWriter outputStreamWriter, DataObject dataObject) throws IOException, DataMediatorException, ResourceException {
        Object object;
        Object object2;
        Object object3;
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "writeHeaders");
        }
        this.namespaceContext.push();
        boolean bl = false;
        DocumentScanner.SavedState savedState = null;
        List list = null;
        String string = null;
        if (this.messagesMatch) {
            object3 = (DynamicEStoreEDataObjectImpl)dataObject;
            object2 = object3.eStore();
            object = (InfoNodeStore)object2;
            savedState = ((InfoNodeStore)object).getHeaderState();
        }
        if (savedState != null) {
            bl = true;
            object3 = savedState.getNamespaceURIs().iterator();
            object2 = savedState.getNamespacePrefixes().iterator();
            while (object3.hasNext()) {
                this.namespaceContext.ensurePrefix((String)object3.next(), (String)object2.next());
            }
            string = ParseState.getEncoding(savedState);
        } else {
            list = dataObject.getList("headers");
            boolean bl2 = bl = !list.isEmpty() || !this.boundHeaderParts.isEmpty();
        }
        if (bl) {
            object3 = this.namespaceContext.getPrefix(SOAP_ENVELOPE_URI, "env");
            outputStreamWriter.write(60);
            this.util.writeQName(outputStreamWriter, "Header", (String)object3);
            if (string != null) {
                this.util.writeEncoding(outputStreamWriter, string);
            }
            this.namespaceContext.writeDeclarations(outputStreamWriter);
            outputStreamWriter.write(62);
            if (savedState != null) {
                savedState.writeToStream(outputStreamWriter);
            } else {
                Property property;
                Object object4;
                Object object5;
                Object object6;
                CharSequence charSequence;
                Object object7;
                object2 = new ArrayList();
                object = list.iterator();
                while (object.hasNext()) {
                    object7 = (DataObject)object.next();
                    charSequence = new StringBuffer();
                    if (object7.isSet("actor")) {
                        object6 = object7.getString("actor");
                        ((StringBuffer)charSequence).append(" " + (String)object3 + ":actor='" + (String)object6 + "'");
                    }
                    if (object7.isSet("mustUnderstand")) {
                        boolean bl3 = object7.getBoolean("mustUnderstand");
                        if (bl3) {
                            ((StringBuffer)charSequence).append(" " + (String)object3 + ":mustUnderstand='1'");
                        } else {
                            ((StringBuffer)charSequence).append(" " + (String)object3 + ":mustUnderstand='0'");
                        }
                    }
                    if (object7.getType().getProperty("messagePart") != null) {
                        object5 = object7.getString("messagePart");
                        object4 = dataObject.getDataObject("body");
                        property = object4.getType().getProperty((String)object5);
                        object6 = object4.get(property);
                        object2.add(object5);
                    } else {
                        object5 = object7.getSequence("any");
                        if (object5.size() != 1) {
                            object4 = nls.getFormattedMessage("BAD_HEADER_CHILD_CWSIF0281", new Object[]{new Integer(object5.size())}, "Header entry has wrong child count");
                            throw new DataMediatorException((String)object4);
                        }
                        object6 = object5.getValue(0);
                        property = object5.getProperty(0);
                    }
                    object5 = ((EProperty)property).getEStructuralFeature();
                    this.writer.writeFeature(outputStreamWriter, (EStructuralFeature)object5, object6, this.namespaceContext, false, ((StringBuffer)charSequence).toString());
                }
                object7 = this.boundHeaderParts.iterator();
                while (object7.hasNext()) {
                    charSequence = (String)object7.next();
                    if (object2.contains(charSequence)) continue;
                    object2.add(charSequence);
                    object6 = dataObject.getDataObject("body");
                    property = object6.getType().getProperty((String)charSequence);
                    object5 = object6.get(property);
                    object4 = ((EProperty)property).getEStructuralFeature();
                    this.writer.writeFeature(outputStreamWriter, (EStructuralFeature)object4, object5, this.namespaceContext, false, null);
                }
            }
            outputStreamWriter.write("</");
            this.util.writeQName(outputStreamWriter, "Header", (String)object3);
            outputStreamWriter.write(62);
            this.namespaceContext.pop();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "writeHeaders");
        }
    }

    private void writeBody(OutputStreamWriter outputStreamWriter, DataObject dataObject) throws IOException, DataMediatorException, ResourceException {
        Object object;
        Object object2;
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "writeBody");
        }
        this.namespaceContext.push();
        String string = null;
        DocumentScanner.SavedState savedState = null;
        DataObject dataObject2 = null;
        if (this.messagesMatch) {
            object2 = (DynamicEStoreEDataObjectImpl)dataObject;
            object = object2.eStore();
            InfoNodeStore infoNodeStore = (InfoNodeStore)object;
            savedState = infoNodeStore.getBodyState();
        }
        if (savedState != null) {
            object2 = savedState.getNamespaceURIs().iterator();
            object = savedState.getNamespacePrefixes().iterator();
            while (object2.hasNext()) {
                this.namespaceContext.ensurePrefix((String)object2.next(), (String)object.next());
            }
            string = ParseState.getEncoding(savedState);
        } else {
            dataObject2 = dataObject.getDataObject("body");
            object2 = this.xsdMeta.getGlobalType("UnknownBodyType", "http://www.ibm.com/ns/2004/05/webservices/messagemodel", "http://www.ibm.com/ns/2004/05/webservices/messagemodel");
            object = SDOUtil.adaptType((EClassifier)object2);
            if (dataObject2.getType().equals(object)) {
                string = dataObject2.getString("encodingStyle");
            }
        }
        outputStreamWriter.write(60);
        object2 = this.namespaceContext.getPrefix(SOAP_ENVELOPE_URI, "env");
        this.util.writeQName(outputStreamWriter, "Body", (String)object2);
        if (string != null) {
            this.util.writeEncoding(outputStreamWriter, string);
        }
        this.namespaceContext.writeDeclarations(outputStreamWriter);
        outputStreamWriter.write(62);
        if (savedState != null) {
            savedState.writeToStream(outputStreamWriter);
        } else if (dataObject2 != null) {
            boolean bl = this.meta.isRPC(this.descriptor);
            boolean bl2 = "fault".equals(this.descriptor.getMessageType());
            if (!bl2 && bl) {
                String string2 = this.meta.getSOAPBodyNamespace(this.descriptor);
                String string3 = this.meta.getSOAPBodyName(this.descriptor);
                outputStreamWriter.write(60);
                String string4 = this.namespaceContext.getPrefix(string2, null);
                this.util.writeQName(outputStreamWriter, string3, string4);
                this.namespaceContext.writeDeclarations(outputStreamWriter);
                outputStreamWriter.write(62);
                this.writeMessageParts(outputStreamWriter, dataObject2, dataObject);
                outputStreamWriter.write("</");
                this.util.writeQName(outputStreamWriter, string3, string4);
                outputStreamWriter.write(62);
            } else if (!bl2) {
                this.writeMessageParts(outputStreamWriter, dataObject2, dataObject);
            } else {
                outputStreamWriter.write(60);
                String string5 = this.namespaceContext.getPrefix(SOAP_ENVELOPE_URI, null);
                this.util.writeQName(outputStreamWriter, "Fault", string5);
                this.namespaceContext.writeDeclarations(outputStreamWriter);
                outputStreamWriter.write(62);
                Iterator iterator = dataObject2.getType().getProperties().iterator();
                while (iterator.hasNext()) {
                    Property property = (Property)iterator.next();
                    Object object3 = dataObject2.get(property);
                    EStructuralFeature eStructuralFeature = ((EProperty)property).getEStructuralFeature();
                    boolean bl3 = "detail".equals(property.getName());
                    if (bl3) {
                        this.writeDetailInternal(outputStreamWriter, dataObject, (DataObject)object3);
                        continue;
                    }
                    if (eStructuralFeature.isDerived() || object3 == null) continue;
                    this.writer.writeFeature(outputStreamWriter, eStructuralFeature, object3, this.namespaceContext, false, null);
                }
                outputStreamWriter.write("</");
                this.util.writeQName(outputStreamWriter, "Fault", string5);
                outputStreamWriter.write(62);
            }
        }
        outputStreamWriter.write("</");
        this.util.writeQName(outputStreamWriter, "Body", (String)object2);
        outputStreamWriter.write(62);
        this.namespaceContext.pop();
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "writeBody");
        }
    }

    private void writeMessageParts(OutputStreamWriter outputStreamWriter, DataObject dataObject, DataObject dataObject2) throws DataMediatorException, ResourceException, IOException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "writeMessageParts", new Object[]{outputStreamWriter, dataObject, dataObject2});
        }
        ExtendedMetaData extendedMetaData = ExtendedMetaData.INSTANCE;
        Iterator iterator = dataObject.getType().getProperties().iterator();
        while (iterator.hasNext()) {
            Property property = (Property)iterator.next();
            Object object = dataObject.get(property);
            EStructuralFeature eStructuralFeature = ((EProperty)property).getEStructuralFeature();
            if (extendedMetaData.getFeatureKind(eStructuralFeature) == 2) continue;
            if (this.mimeParts.containsKey(property.getName())) {
                this.writeMIMEReference(outputStreamWriter, dataObject2, eStructuralFeature);
                continue;
            }
            if (this.boundHeaderParts.contains(property.getName()) || eStructuralFeature.isDerived() || object == null) continue;
            this.writer.writeFeature(outputStreamWriter, eStructuralFeature, object, this.namespaceContext, false, null);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "writeMessageParts");
        }
    }

    private void writeMIMEReference(OutputStreamWriter outputStreamWriter, DataObject dataObject, EStructuralFeature eStructuralFeature) throws DataMediatorException, ResourceException, IOException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "writeMIMEReference", eStructuralFeature);
        }
        this.namespaceContext.push();
        ExtendedMetaData extendedMetaData = ExtendedMetaData.INSTANCE;
        String string = extendedMetaData.getName(eStructuralFeature);
        String string2 = extendedMetaData.getNamespace(eStructuralFeature);
        String string3 = eStructuralFeature.getEContainingClass().getEPackage().getNsPrefix();
        String string4 = null;
        MimeElement mimeElement = (MimeElement)this.boundMimeElements.get(string);
        if (mimeElement == null) {
            MIMEContent mIMEContent = (MIMEContent)this.mimeParts.get(string);
            int n = System.identityHashCode(dataObject);
            int n2 = System.identityHashCode(string);
            String string5 = string + "=" + Integer.toString(n, 16) + Integer.toString(n2, 16) + "@ibm.com";
            String string6 = mIMEContent.getType();
            String string7 = "binary";
            Object object = dataObject.get("body/" + string);
            if (object instanceof byte[]) {
                byte[] byArray = (byte[])object;
                mimeElement = MimeFactory.createNewMimeElement(byArray, 0, byArray.length, string6, string5, string7);
            } else {
                String string8 = (String)object;
                mimeElement = MimeFactory.createNewMimeElement(string8, string6, string5, string7);
            }
            this.boundMimeElements.put(eStructuralFeature, mimeElement);
            this.mimeElements.add(mimeElement);
        }
        if (!MIMEPartHandler.matchesPartName(string, mimeElement.getContentID())) {
            outputStreamWriter.write(60);
            string3 = this.namespaceContext.getPrefix(string2, string3);
            string4 = this.namespaceContext.getPrefix("", string4);
            this.util.writeQName(outputStreamWriter, string, string3);
            outputStreamWriter.write(32);
            this.util.writeQName(outputStreamWriter, "href", string4);
            outputStreamWriter.write("='");
            this.util.writeString(outputStreamWriter, "cid:");
            this.util.writeString(outputStreamWriter, mimeElement.getContentID());
            outputStreamWriter.write(39);
            this.namespaceContext.writeDeclarations(outputStreamWriter);
            outputStreamWriter.write("/>");
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "writeMIMEReference");
        }
    }

    private boolean isSOAPEncoded(DataObject dataObject) throws ResourceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "isSOAPEncoded", dataObject);
        }
        boolean bl = false;
        if (this.descriptor.usingWSDL()) {
            bl = this.meta.isEncoded(this.descriptor);
        } else {
            InfoNodeStore infoNodeStore;
            InternalEObject.EStore eStore;
            DynamicEStoreEDataObjectImpl dynamicEStoreEDataObjectImpl;
            String string = null;
            DocumentScanner.SavedState savedState = null;
            if (this.messagesMatch) {
                dynamicEStoreEDataObjectImpl = (DynamicEStoreEDataObjectImpl)dataObject;
                eStore = dynamicEStoreEDataObjectImpl.eStore();
                infoNodeStore = (InfoNodeStore)eStore;
                savedState = infoNodeStore.getBodyState();
            }
            if (savedState != null) {
                string = ParseState.getEncoding(savedState);
            } else {
                dynamicEStoreEDataObjectImpl = dataObject.getDataObject("body");
                eStore = this.xsdMeta.getGlobalType("UnknownBodyType", "http://www.ibm.com/ns/2004/05/webservices/messagemodel", "http://www.ibm.com/ns/2004/05/webservices/messagemodel");
                infoNodeStore = SDOUtil.adaptType((EClassifier)eStore);
                if (dynamicEStoreEDataObjectImpl.getType().equals(infoNodeStore)) {
                    string = dynamicEStoreEDataObjectImpl.getString("encodingStyle");
                }
            }
            bl = this.meta.isSOAPEncoding(string);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "isSOAPEncoded", new Boolean(bl));
        }
        return bl;
    }

    public void writeDetail(OutputStream outputStream, DataObject dataObject, SOAPFormatDescriptor sOAPFormatDescriptor) throws IOException, ResourceException, DataMediatorException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "writeDetail", new Object[]{outputStream, dataObject, sOAPFormatDescriptor});
        }
        this.namespaceContext = new NamespaceContext(this);
        this.writer = new BasicXMLWriter(this);
        this.descriptor = sOAPFormatDescriptor;
        this.descriptor.setOperationName(dataObject.getString("operationName"));
        this.descriptor.setMessageName(dataObject.getString("messageName"));
        this.descriptor.setMessageType(dataObject.getString("messageType"));
        this.namespaceContext = new NamespaceContext(this);
        this.writer = new BasicXMLWriter(this);
        this.soapParts = this.meta.getSOAPParts(this.descriptor);
        this.mimeParts = this.meta.getMIMEParts(this.descriptor);
        this.boundHeaderParts = this.meta.getBoundHeaderParts(this.descriptor);
        DataObject dataObject2 = dataObject.getDataObject("body/detail");
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream, "UTF-8");
        this.writeDetailInternal(outputStreamWriter, dataObject, dataObject2);
        outputStreamWriter.flush();
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "writeDetail");
        }
    }

    private void writeDetailInternal(OutputStreamWriter outputStreamWriter, DataObject dataObject, DataObject dataObject2) throws IOException, ResourceException, DataMediatorException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "writeDetailInternal", new Object[]{outputStreamWriter, dataObject, dataObject2});
        }
        if (dataObject2 != null) {
            boolean bl = this.descriptor.getMessageName() != null;
            outputStreamWriter.write(60);
            String string = this.namespaceContext.getPrefix("", null);
            this.util.writeQName(outputStreamWriter, "detail", string);
            outputStreamWriter.write(62);
            if (bl) {
                DataObject dataObject3 = dataObject2.getDataObject("any[1]");
                this.writeMessageParts(outputStreamWriter, dataObject3, dataObject);
            } else {
                this.writeMessageParts(outputStreamWriter, dataObject2, dataObject);
            }
            outputStreamWriter.write("</");
            this.util.writeQName(outputStreamWriter, "detail", string);
            outputStreamWriter.write(62);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "writeDetailInternal");
        }
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "Source info: @(#)SIB/ws/code/sib.mfp.sdo.impl/src/com/ibm/ws/sib/mfp/sdo/soap/write/SOAPWriter.java, SIB.mfp, WAS602.SIB, o0610.11 1.31");
        }
    }
}

