/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.mfp.sdo.soap.write;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.sib.mfp.sdo.resource.ResourceException;
import com.ibm.ws.sib.mfp.sdo.resource.WSDLMetaData;
import com.ibm.ws.sib.mfp.sdo.resource.XSDMetaData;
import com.ibm.ws.sib.mfp.sdo.resource.type.JSXMLTypePackage;
import com.ibm.ws.sib.mfp.sdo.soap.SOAPFormatDescriptor;
import com.ibm.ws.sib.mfp.sdo.soap.write.NamespaceContext;
import com.ibm.ws.sib.mfp.sdo.soap.write.SOAPWriter;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.io.IOException;
import java.io.OutputStreamWriter;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.sdo.EDataObject;
import org.eclipse.emf.ecore.sdo.EDataObjectSimpleAnyType;
import org.eclipse.emf.ecore.sdo.SDOPackage;
import org.eclipse.emf.ecore.util.ExtendedMetaData;
import org.eclipse.emf.ecore.xml.type.SimpleAnyType;
import org.eclipse.emf.ecore.xml.type.XMLTypePackage;

public class OutputUtil {
    private static TraceComponent tc = SibTr.register(OutputUtil.class, "SIBMfp", "com.ibm.ws.sib.mfp.CWSIFMessages");
    private SOAPWriter writer;
    private WSDLMetaData wsdlMeta;
    private XSDMetaData xsdMeta;

    public OutputUtil(SOAPWriter sOAPWriter) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "<init>");
        }
        this.writer = sOAPWriter;
        this.wsdlMeta = this.writer.getWsdlMetaData();
        this.xsdMeta = this.writer.getXsdMetaData();
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "<init>");
        }
    }

    public void writeString(OutputStreamWriter outputStreamWriter, String string) throws IOException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "writeString");
        }
        int n = 0;
        char[] cArray = string.toCharArray();
        block7: for (int i = 0; i < cArray.length; ++i) {
            switch (cArray[i]) {
                case '<': {
                    if (n < i) {
                        outputStreamWriter.write(cArray, n, i - n);
                    }
                    outputStreamWriter.write("&lt;");
                    n = i + 1;
                    continue block7;
                }
                case '>': {
                    if (n < i) {
                        outputStreamWriter.write(cArray, n, i - n);
                    }
                    outputStreamWriter.write("&gt;");
                    n = i + 1;
                    continue block7;
                }
                case '&': {
                    if (n < i) {
                        outputStreamWriter.write(cArray, n, i - n);
                    }
                    outputStreamWriter.write("&amp;");
                    n = i + 1;
                    continue block7;
                }
                case '\'': {
                    if (n < i) {
                        outputStreamWriter.write(cArray, n, i - n);
                    }
                    outputStreamWriter.write("&apos;");
                    n = i + 1;
                    continue block7;
                }
                case '\"': {
                    if (n < i) {
                        outputStreamWriter.write(cArray, n, i - n);
                    }
                    outputStreamWriter.write("&quot;");
                    n = i + 1;
                }
            }
        }
        if (n < cArray.length) {
            outputStreamWriter.write(cArray, n, cArray.length - n);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "writeString");
        }
    }

    void writeQName(OutputStreamWriter outputStreamWriter, String string, String string2) throws IOException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "writeQName");
        }
        if (string2 != null && string2.length() > 0) {
            outputStreamWriter.write(string2);
            outputStreamWriter.write(58);
        }
        outputStreamWriter.write(string);
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "writeQName");
        }
    }

    void writeXsiType(OutputStreamWriter outputStreamWriter, EDataObject eDataObject, EStructuralFeature eStructuralFeature, NamespaceContext namespaceContext) throws IOException {
        String string;
        String string2;
        EClass eClass;
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "writeXsiType");
        }
        Object object = eClass = eDataObject != null ? eDataObject.eClass() : eStructuralFeature.getEType();
        if (eDataObject instanceof EDataObjectSimpleAnyType) {
            eClass = ((SimpleAnyType)eDataObject).getInstanceType();
        }
        if (eClass == SDOPackage.eINSTANCE.getEDataObjectAnyType()) {
            if (tc.isEntryEnabled()) {
                SibTr.exit(tc, "writeXsiType");
            }
            return;
        }
        EPackage ePackage = eClass.getEPackage();
        String string3 = this.xsdMeta.getName((EClassifier)eClass);
        if (ePackage == XMLTypePackage.eINSTANCE || ePackage == JSXMLTypePackage.eINSTANCE) {
            string2 = "http://www.w3.org/2001/XMLSchema";
            string = "xsd";
        } else {
            ExtendedMetaData extendedMetaData = ExtendedMetaData.INSTANCE;
            string2 = extendedMetaData.getNamespace(ePackage);
            string = ePackage.getNsPrefix();
        }
        String string4 = namespaceContext.getPrefix("http://www.w3.org/2001/XMLSchema-instance", "xsi");
        string = namespaceContext.getPrefix(string2, string);
        outputStreamWriter.write(32);
        this.writeQName(outputStreamWriter, "type", string4);
        outputStreamWriter.write("='");
        this.writeQName(outputStreamWriter, string3, string);
        outputStreamWriter.write("'");
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "writeXsiType");
        }
    }

    void writeXsiNil(OutputStreamWriter outputStreamWriter, boolean bl, NamespaceContext namespaceContext) throws IOException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "writeXsiNil");
        }
        String string = namespaceContext.getPrefix("http://www.w3.org/2001/XMLSchema-instance", "xsi");
        outputStreamWriter.write(32);
        this.writeQName(outputStreamWriter, "nil", string);
        outputStreamWriter.write("='");
        outputStreamWriter.write(Boolean.toString(bl));
        outputStreamWriter.write("'");
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "writeXsiNil");
        }
    }

    boolean writeEncoding(OutputStreamWriter outputStreamWriter, EStructuralFeature eStructuralFeature) throws IOException, ResourceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "writeEncoding");
        }
        Boolean bl = Boolean.FALSE;
        SOAPFormatDescriptor sOAPFormatDescriptor = this.writer.getDescriptor();
        String string = this.wsdlMeta.getEncoding(eStructuralFeature, this.writer.getDescriptor());
        if (string != null && string.length() > 0) {
            this.writeEncoding(outputStreamWriter, string);
            bl = Boolean.TRUE;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "writeEncoding", bl);
        }
        return bl;
    }

    void writeEncoding(OutputStreamWriter outputStreamWriter, String string) throws IOException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "writeEncoding", new Object[]{outputStreamWriter, string});
        }
        NamespaceContext namespaceContext = this.writer.getNamespaceContext();
        String string2 = namespaceContext.getPrefix(this.writer.getSOAPEnvelopeNamespace(), "env");
        outputStreamWriter.write(32);
        this.writeQName(outputStreamWriter, "encodingStyle", string2);
        outputStreamWriter.write("='");
        this.writeString(outputStreamWriter, string);
        outputStreamWriter.write("'");
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "writeEncoding");
        }
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "Source info: @(#)SIB/ws/code/sib.mfp.sdo.impl/src/com/ibm/ws/sib/mfp/sdo/soap/write/OutputUtil.java, SIB.mfp, WAS602.SIB, o0610.11 1.15");
        }
    }
}

