/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.mfp.sdo.soap.parse;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.ws.sib.mfp.sdo.mime.MimeElementList;
import com.ibm.ws.sib.mfp.sdo.resource.ResourceCache;
import com.ibm.ws.sib.mfp.sdo.resource.ResourceException;
import com.ibm.ws.sib.mfp.sdo.resource.WSDLMetaData;
import com.ibm.ws.sib.mfp.sdo.resource.XSDMetaData;
import com.ibm.ws.sib.mfp.sdo.resource.XSDResourceHelper;
import com.ibm.ws.sib.mfp.sdo.soap.DocumentScanner;
import com.ibm.ws.sib.mfp.sdo.soap.SOAPFormatDescriptor;
import com.ibm.ws.sib.mfp.sdo.soap.parse.FaultDetailHandler;
import com.ibm.ws.sib.mfp.sdo.soap.parse.FaultIdentificationHandler;
import com.ibm.ws.sib.mfp.sdo.soap.parse.HandlerStack;
import com.ibm.ws.sib.mfp.sdo.soap.parse.InfoNodeStore;
import com.ibm.ws.sib.mfp.sdo.soap.parse.MessageIdentificationHandler;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.sdo.DataMediatorException;
import commonj.sdo.DataObject;
import commonj.sdo.Property;
import commonj.sdo.Type;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.sdo.EType;
import org.eclipse.emf.ecore.sdo.impl.DynamicEStoreEDataObjectImpl;

public class SOAPParser {
    private static TraceComponent tc = SibTr.register(SOAPParser.class, "SIBMfp", "com.ibm.ws.sib.mfp.CWSIFMessages");
    private static TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.mfp.CWSIFMessages");
    private ResourceCache cache;
    private WSDLMetaData wsdlMetaData;
    private XSDMetaData xsdMetaData;

    public SOAPParser(ResourceCache resourceCache, WSDLMetaData wSDLMetaData, XSDMetaData xSDMetaData) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "<init>");
        }
        this.cache = resourceCache;
        this.wsdlMetaData = wSDLMetaData;
        this.xsdMetaData = xSDMetaData;
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "<init>");
        }
    }

    public DataObject parse(String string, byte[] byArray, int n, int n2, SOAPFormatDescriptor sOAPFormatDescriptor) throws ResourceException, DataMediatorException, IOException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "parse");
        }
        DataObject dataObject = this.cache.createDataObject("http://www.ibm.com/ns/2004/05/webservices/messagemodel", "", null);
        Type type = dataObject.getType();
        Property property = type.getProperty("Info");
        EType eType = (EType)property.getType();
        EClass eClass = (EClass)eType.getEClassifier();
        InfoNodeStore infoNodeStore = new InfoNodeStore(eClass, string, byArray, n, n2, sOAPFormatDescriptor, this.cache, this.wsdlMetaData, this.xsdMetaData);
        DynamicEStoreEDataObjectImpl dynamicEStoreEDataObjectImpl = new DynamicEStoreEDataObjectImpl(eClass, (InternalEObject.EStore)infoNodeStore);
        infoNodeStore.setProxyNode((DataObject)dynamicEStoreEDataObjectImpl);
        dataObject.setDataObject(property, (DataObject)dynamicEStoreEDataObjectImpl);
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "parse", dynamicEStoreEDataObjectImpl);
        }
        return dataObject;
    }

    public void parseDetail(DataObject dataObject, byte[] byArray, int n, int n2, SOAPFormatDescriptor sOAPFormatDescriptor) throws ResourceException, DataMediatorException {
        Object object;
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "parseDetail", new Object[]{dataObject, byArray, new Integer(n), new Integer(n2), sOAPFormatDescriptor});
        }
        sOAPFormatDescriptor.setOperationName(dataObject.getString("operationName"));
        sOAPFormatDescriptor.setMessageName(dataObject.getString("messageName"));
        sOAPFormatDescriptor.setMessageType(dataObject.getString("messageType"));
        ResourceSet resourceSet = XSDResourceHelper.createResourceSet(sOAPFormatDescriptor.getLocation(), this.cache);
        BasicState basicState = new BasicState();
        basicState.setDescriptor(sOAPFormatDescriptor);
        basicState.setInfoNode(dataObject);
        basicState.setOnDemandResources(resourceSet);
        basicState.setWsdlMetaData(this.wsdlMetaData);
        basicState.setXsdMetaData(this.xsdMetaData);
        sOAPFormatDescriptor.setMessageType("fault");
        DocumentScanner documentScanner = new DocumentScanner(byArray, n, n2);
        HandlerStack handlerStack = new HandlerStack(documentScanner, true, this.wsdlMetaData);
        if (sOAPFormatDescriptor.usingWSDL()) {
            object = new MessageIdentificationHandler(sOAPFormatDescriptor, this.wsdlMetaData, null, this.cache);
            FaultIdentificationHandler faultIdentificationHandler = new FaultIdentificationHandler((MessageIdentificationHandler)object, true, this.wsdlMetaData);
            handlerStack.pushDocumentHandler((HandlerStack.HandlerBase)object);
            handlerStack.pushDocumentHandler(faultIdentificationHandler);
            try {
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray, n, n2);
                documentScanner.scanDocument(handlerStack, byteArrayInputStream);
                ((MessageIdentificationHandler)object).completeIdentification(true);
            }
            catch (MessageIdentificationHandler.ParseComplete parseComplete) {
                // empty catch block
            }
        }
        if (sOAPFormatDescriptor.getOperationName() != null) {
            dataObject.setString("operationName", sOAPFormatDescriptor.getOperationName());
        }
        if (sOAPFormatDescriptor.getMessageName() != null) {
            dataObject.setString("messageName", sOAPFormatDescriptor.getMessageName());
        }
        if (sOAPFormatDescriptor.getMessageType() != null) {
            dataObject.setString("messageType", sOAPFormatDescriptor.getMessageType());
        }
        documentScanner = new DocumentScanner(byArray, n, n2);
        handlerStack = new HandlerStack(documentScanner, true, this.wsdlMetaData);
        handlerStack.pushDocumentHandler(new FaultDetailHandler(basicState, dataObject.getDataObject("body/detail"), null));
        object = new ByteArrayInputStream(byArray, n, n2);
        documentScanner.scanDocument(handlerStack, (InputStream)object);
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "parseDetail");
        }
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "Source info: @(#)SIB/ws/code/sib.mfp.sdo.impl/src/com/ibm/ws/sib/mfp/sdo/soap/parse/SOAPParser.java, SIB.mfp, WAS602.SIB, o0610.11 1.24");
        }
    }

    static class BasicState {
        private SOAPFormatDescriptor descriptor;
        private ResourceSet onDemandResources;
        private MimeElementList mimeElements;
        private DataObject infoNode;
        private WSDLMetaData wsdlMetaData;
        private XSDMetaData xsdMetaData;

        BasicState() {
        }

        public SOAPFormatDescriptor getDescriptor() {
            return this.descriptor;
        }

        public MimeElementList getMimeElements() {
            return this.mimeElements;
        }

        public ResourceSet getOnDemandResources() {
            return this.onDemandResources;
        }

        public void setDescriptor(SOAPFormatDescriptor sOAPFormatDescriptor) {
            this.descriptor = sOAPFormatDescriptor;
        }

        public void setMimeElements(MimeElementList mimeElementList) {
            this.mimeElements = mimeElementList;
        }

        public void setOnDemandResources(ResourceSet resourceSet) {
            this.onDemandResources = resourceSet;
        }

        public DataObject getInfoNode() {
            return this.infoNode;
        }

        public void setInfoNode(DataObject dataObject) {
            this.infoNode = dataObject;
        }

        public WSDLMetaData getWsdlMetaData() {
            return this.wsdlMetaData;
        }

        public void setWsdlMetaData(WSDLMetaData wSDLMetaData) {
            this.wsdlMetaData = wSDLMetaData;
        }

        public XSDMetaData getXsdMetaData() {
            return this.xsdMetaData;
        }

        public void setXsdMetaData(XSDMetaData xSDMetaData) {
            this.xsdMetaData = xSDMetaData;
        }
    }
}

