/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.mfp.sdo.soap.parse;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.ws.sib.mfp.sdo.SdoCopier;
import com.ibm.ws.sib.mfp.sdo.resource.WSDLMetaData;
import com.ibm.ws.sib.mfp.sdo.soap.parse.HandlerStack;
import com.ibm.ws.sib.mfp.sdo.soap.parse.SOAPParser;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.sdo.DataMediatorException;
import com.ibm.xml.b2b.scan.DocumentScannerSupport;
import com.ibm.xml.b2b.util.QName;
import commonj.sdo.DataObject;
import commonj.sdo.Property;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;

abstract class SOAPEncodedHandler
extends HandlerStack.HandlerBase {
    private static TraceComponent tc = SibTr.register(SOAPEncodedHandler.class, "SIBMfp", "com.ibm.ws.sib.mfp.CWSIFMessages");
    private static TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.mfp.CWSIFMessages");
    private WSDLMetaData wsdlMeta;

    SOAPEncodedHandler(SOAPParser.BasicState basicState) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "<init>");
        }
        this.wsdlMeta = basicState.getWsdlMetaData();
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "<init>");
        }
    }

    private void replaceNode(HandlerStack.NodeEntry nodeEntry, DataObject dataObject) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "replaceNode");
        }
        DataObject dataObject2 = nodeEntry.node;
        Property property = nodeEntry.property;
        int n = nodeEntry.index;
        Object object = property.getType().isInstance((Object)dataObject) ? dataObject : dataObject.get(property);
        if (n != -1) {
            List list = dataObject2.getList(property);
            if (n >= 0) {
                list.set(n, object);
            } else {
                n = (n + 2) * -1;
                ListIterator<DataObject> listIterator = list.listIterator(n);
                listIterator.add((DataObject)object);
            }
        } else {
            dataObject2.set(property, object);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "replaceNode");
        }
    }

    protected String handleNonRootNode() throws DataMediatorException {
        Object object;
        Object object2;
        Object object3;
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "handleNonRootNode");
        }
        HandlerStack handlerStack = this.getHandlerStack();
        DocumentScannerSupport documentScannerSupport = handlerStack.getScannerState();
        if (!handlerStack.isSOAPEncoded()) {
            QName qName = documentScannerSupport.currentElement;
            String string = nls.getFormattedMessage("NON_ROOT_ERROR_CWSIF0296", new Object[]{qName.localPart, qName.namespaceURI}, "Non-root soap element must be SOAP encoded");
            throw new DataMediatorException(string);
        }
        String string = null;
        for (int i = 0; i < documentScannerSupport.attrCount; ++i) {
            object3 = documentScannerSupport.attrNames[i];
            object2 = documentScannerSupport.attValues[i];
            if (!"root".equals(object3.localPart) || !this.wsdlMeta.isSOAPEncodingNamespace(object3.namespaceURI)) continue;
            string = object2.toString();
            handlerStack.getProcessedAttributes()[i] = true;
            break;
        }
        if (string == null || !string.equals("0")) {
            QName qName = documentScannerSupport.currentElement;
            object3 = nls.getFormattedMessage("NON_ROOT_ERROR_CWSIF0297", new Object[]{qName.localPart, qName.namespaceURI, string}, "Invalid SOAP:root attribute");
            throw new DataMediatorException((String)object3);
        }
        String string2 = null;
        for (int i = 0; i < documentScannerSupport.attrCount; ++i) {
            object2 = documentScannerSupport.attrNames[i];
            object = documentScannerSupport.attValues[i];
            if (!"id".equals(object2.localPart) || !"".equals(object2.namespaceURI)) continue;
            string2 = object.toString();
            handlerStack.getProcessedAttributes()[i] = true;
            break;
        }
        if (string2 == null) {
            String string3 = documentScannerSupport.currentElement.localPart;
            object2 = documentScannerSupport.currentElement.namespaceURI;
            object = nls.getFormattedMessage("ID_ATTR_NOT_FOUND_CWSIF0305", new Object[]{string3, object2}, "id attribute not found");
            throw new DataMediatorException((String)object);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "handleNonRootNode", string2);
        }
        return string2;
    }

    protected void handleEndOfBody() throws DataMediatorException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "handleEndOfBody");
        }
        HandlerStack handlerStack = this.getHandlerStack();
        List list = handlerStack.getIncompleteNodes();
        Map map = handlerStack.getOrphanNodes();
        if (map != null || list != null) {
            Object object;
            String string;
            Object object2;
            while (map != null && map.size() > 0) {
                Object object3;
                object2 = (String)map.keySet().iterator().next();
                string = (DataObject)map.get(object2);
                object = new ArrayList();
                int n = 0;
                while (list != null && n < list.size()) {
                    object3 = (HandlerStack.NodeEntry)list.get(n);
                    if (object3.href.charAt(0) == '#' && object3.href.substring(1).equals(object2)) {
                        object.add(object3);
                        list.remove(n);
                        continue;
                    }
                    ++n;
                }
                while (object.size() > 1) {
                    object3 = SdoCopier.copy((DataObject)string);
                    this.replaceNode((HandlerStack.NodeEntry)object.get(0), (DataObject)object3);
                    object.remove(0);
                }
                if (object.size() == 1) {
                    this.replaceNode((HandlerStack.NodeEntry)object.get(0), (DataObject)string);
                    map.remove(object2);
                    continue;
                }
                object3 = nls.getFormattedMessage("HREF_NOT_FOUND_CWSIF0306", new Object[]{object2}, "Unable to locate element which references non-root SOAP element");
                throw new DataMediatorException((String)object3);
            }
            if (list != null && list.size() > 0) {
                object2 = (HandlerStack.NodeEntry)list.get(0);
                string = ((HandlerStack.NodeEntry)object2).href;
                object = nls.getFormattedMessage("INVALID_HREF_CWSIF0307", new Object[]{string}, "Unknown href value");
                throw new DataMediatorException((String)object);
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "handleEndOfBody");
        }
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "Source info: @(#)SIB/ws/code/sib.mfp.sdo.impl/src/com/ibm/ws/sib/mfp/sdo/soap/parse/SOAPEncodedHandler.java, SIB.mfp, WAS602.SIB, o0610.11 1.8");
        }
    }
}

