/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.mfp.sdo.soap.parse;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.ws.sib.mfp.sdo.resource.ResourceException;
import com.ibm.ws.sib.mfp.sdo.resource.WSDLMetaData;
import com.ibm.ws.sib.mfp.sdo.soap.SOAPFormatDescriptor;
import com.ibm.ws.sib.mfp.sdo.soap.parse.BasicXMLHandler;
import com.ibm.ws.sib.mfp.sdo.soap.parse.HandlerStack;
import com.ibm.ws.sib.mfp.sdo.soap.parse.MIMEPartHandler;
import com.ibm.ws.sib.mfp.sdo.soap.parse.SOAPEncodedHandler;
import com.ibm.ws.sib.mfp.sdo.soap.parse.SOAPParser;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.sdo.DataMediatorException;
import com.ibm.xml.b2b.scan.DocumentScannerSupport;
import com.ibm.xml.b2b.util.QName;
import commonj.sdo.DataObject;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.sdo.EProperty;

public class RPCHandler
extends SOAPEncodedHandler {
    private static TraceComponent tc = SibTr.register(RPCHandler.class, "SIBMfp", "com.ibm.ws.sib.mfp.CWSIFMessages");
    private static TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.mfp.CWSIFMessages");
    private SOAPParser.BasicState basicState;
    private DataObject messageNode;
    private WSDLMetaData meta;
    private boolean inWrapper = false;
    private boolean inTopLevelElement = false;
    private String idValue;
    private HandlerStack.HandlerBase nestedHandler;
    private Map mimeParts;
    private List partList;
    private int partIndex;
    private String wrapperName;
    private String wrapperURI;
    private List mimeContentIds;

    RPCHandler(SOAPParser.BasicState basicState, DataObject dataObject, List list) throws ResourceException {
        super(basicState);
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "<init>");
        }
        this.basicState = basicState;
        this.messageNode = dataObject;
        this.meta = basicState.getWsdlMetaData();
        SOAPFormatDescriptor sOAPFormatDescriptor = basicState.getDescriptor();
        this.mimeParts = this.meta.getMIMEParts(sOAPFormatDescriptor);
        this.wrapperName = this.meta.getSOAPBodyName(sOAPFormatDescriptor);
        this.wrapperURI = this.meta.getSOAPBodyNamespace(sOAPFormatDescriptor);
        this.partList = this.messageNode.getType().getProperties();
        this.mimeContentIds = list;
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "<init>");
        }
    }

    void prepareForFaultMessage() {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "prepareForFaultMessage");
        }
        this.inTopLevelElement = true;
        this.inWrapper = true;
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "prepareForFaultMessage");
        }
    }

    boolean allowText() {
        return false;
    }

    private void handleEndElementEvent() {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "handleEndElementEvent");
        }
        if (this.inWrapper) {
            if (this.nestedHandler == null) {
                this.inWrapper = false;
                this.inTopLevelElement = false;
            } else {
                this.nestedHandler = null;
            }
        } else if (this.inTopLevelElement) {
            if (this.nestedHandler != null) {
                BasicXMLHandler basicXMLHandler = (BasicXMLHandler)this.nestedHandler;
                this.getHandlerStack().addOrphanNode(this.idValue, basicXMLHandler.getTopNode());
                this.nestedHandler = null;
            }
            this.inTopLevelElement = false;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "handleEndElementEvent");
        }
    }

    public void endElementEvent() throws DataMediatorException, ResourceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "endElementEvent");
        }
        if (this.nestedHandler != null) {
            this.nestedHandler.endElementEvent();
        }
        this.handleEndElementEvent();
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "endElementEvent");
        }
    }

    public void startElementEvent(boolean bl) throws DataMediatorException, ResourceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "startElementEvent");
        }
        HandlerStack handlerStack = this.getHandlerStack();
        DocumentScannerSupport documentScannerSupport = handlerStack.getScannerState();
        QName qName = documentScannerSupport.currentElement;
        if (!this.inTopLevelElement) {
            this.inTopLevelElement = true;
            if (this.wrapperName.equals(qName.localPart) && this.wrapperURI.equals(qName.namespaceURI)) {
                this.inWrapper = true;
            } else {
                this.idValue = this.handleNonRootNode();
                this.nestedHandler = new BasicXMLHandler(this.basicState);
                handlerStack.pushDocumentHandler(this.nestedHandler);
                this.nestedHandler.startElementEvent(bl);
            }
        } else if (this.inWrapper) {
            EProperty eProperty = (EProperty)this.partList.get(this.partIndex++);
            String string = eProperty.getName();
            while (this.mimeParts != null && this.mimeParts.containsKey(string)) {
                boolean bl2 = false;
                if (this.mimeContentIds != null) {
                    Iterator iterator = this.mimeContentIds.iterator();
                    while (iterator.hasNext()) {
                        String string2 = (String)iterator.next();
                        if (!MIMEPartHandler.matchesPartName(string, string2)) continue;
                        bl2 = true;
                    }
                }
                if (string.equals(qName.localPart) || !bl2) break;
                eProperty = (EProperty)this.partList.get(this.partIndex++);
                string = eProperty.getName();
            }
            if (this.mimeParts != null && this.mimeParts.containsKey(string)) {
                MIMEPartHandler mIMEPartHandler = new MIMEPartHandler(this.basicState);
                mIMEPartHandler.setExpectedPart(eProperty);
                this.nestedHandler = mIMEPartHandler;
            } else {
                BasicXMLHandler basicXMLHandler = new BasicXMLHandler(this.basicState);
                basicXMLHandler.setCurrentNode(this.messageNode);
                basicXMLHandler.setExpectedPart(eProperty);
                this.nestedHandler = basicXMLHandler;
            }
            handlerStack.pushDocumentHandler(this.nestedHandler);
            this.nestedHandler.startElementEvent(bl);
        }
        if (bl) {
            this.handleEndElementEvent();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "startElementEvent");
        }
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "Source info: @(#)SIB/ws/code/sib.mfp.sdo.impl/src/com/ibm/ws/sib/mfp/sdo/soap/parse/RPCHandler.java, SIB.mfp, WAS602.SIB, o0610.11 1.18");
        }
    }
}

