/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.mfp.sdo.soap.parse;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.ws.sib.mfp.sdo.resource.WSDLMetaData;
import com.ibm.ws.sib.mfp.sdo.soap.DocumentScanner;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.sdo.DataMediatorException;
import com.ibm.xml.b2b.scan.DocumentEventHandler;
import com.ibm.xml.b2b.scan.DocumentScannerSupport;
import com.ibm.xml.b2b.util.QName;
import com.ibm.xml.b2b.util.XMLName;
import com.ibm.xml.b2b.util.XMLString;
import java.io.IOException;
import java.util.Map;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class ParseState
implements DocumentEventHandler {
    private static TraceComponent tc = SibTr.register(ParseState.class, "SIBMfp", "com.ibm.ws.sib.mfp.CWSIFMessages");
    private static TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.mfp.CWSIFMessages");
    private static final Pattern whiteSpace;
    private static final String ENCODING_KEY;
    private DocumentScanner scanner;
    private WSDLMetaData wsdlMeta;
    private boolean[] processedAttributes = new boolean[10];
    private Stack encodingStack = null;
    private String encoding = null;
    private boolean soapEncoded = false;

    ParseState(DocumentScanner documentScanner, boolean bl, WSDLMetaData wSDLMetaData) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "ParseState", documentScanner);
        }
        this.scanner = documentScanner;
        this.wsdlMeta = wSDLMetaData;
        if (bl) {
            this.encodingStack = new Stack();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "ParseState", this);
        }
    }

    ParseState(DocumentScanner documentScanner, DocumentScanner.SavedState savedState, boolean bl, WSDLMetaData wSDLMetaData) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "ParseState", new Object[]{documentScanner, savedState});
        }
        this.scanner = documentScanner;
        this.wsdlMeta = wSDLMetaData;
        if (bl) {
            this.encodingStack = new Stack();
            this.encoding = ParseState.getEncoding(savedState);
            this.soapEncoded = this.wsdlMeta.isSOAPEncoding(this.encoding);
            EncodingEntry encodingEntry = new EncodingEntry();
            encodingEntry.encoding = this.encoding;
            encodingEntry.soapEncoded = this.soapEncoded;
            encodingEntry.level = -1;
            this.encodingStack.push(encodingEntry);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "ParseState", this);
        }
    }

    DocumentScannerSupport getScannerState() {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "getScannerState");
        }
        DocumentScannerSupport documentScannerSupport = this.scanner.getScannerState();
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "getScannerState", documentScannerSupport);
        }
        return documentScannerSupport;
    }

    DocumentScanner.SavedState getContentAsSavedState() throws IOException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "getContentAsSavedState");
        }
        DocumentScanner.SavedState savedState = this.scanner.saveSubtree();
        Map map = savedState.getHandlerProperties();
        map.put(ENCODING_KEY, this.getEncoding());
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "getContentAsSavedState", savedState);
        }
        return savedState;
    }

    boolean skipSubtree() {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "skipSubtree");
        }
        boolean bl = this.scanner.skipSubtree();
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "skipSubtree", new Boolean(bl));
        }
        return bl;
    }

    boolean[] getProcessedAttributes() {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "getProcessedAttributes");
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "getProcessedAttributes", this.processedAttributes);
        }
        return this.processedAttributes;
    }

    boolean isSOAPEncoded() {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "isSOAPEncoded");
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "isSOAPEncoded", new Boolean(this.soapEncoded));
        }
        return this.soapEncoded;
    }

    String getEncoding() {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "getEncoding");
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "getEncoding", (Object)this.encoding);
        }
        return this.encoding;
    }

    public static String getEncoding(DocumentScanner.SavedState savedState) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "getEncoding", savedState);
        }
        String string = null;
        Map map = savedState.getHandlerProperties();
        if (map.containsKey(ENCODING_KEY)) {
            string = (String)map.get(ENCODING_KEY);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "getEncoding", (Object)string);
        }
        return string;
    }

    private void handleEndElementEvent() {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "handleEndElementEvent");
        }
        this.popEncoding();
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "handleEndElementEvent");
        }
    }

    private void pushEncoding() {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "pushEncoding");
        }
        if (this.encodingStack == null) {
            if (tc.isEntryEnabled()) {
                SibTr.exit(tc, "pushEncoding");
            }
            return;
        }
        DocumentScannerSupport documentScannerSupport = this.getScannerState();
        for (int i = 0; i < documentScannerSupport.attrCount; ++i) {
            if (!"encodingStyle".equals(documentScannerSupport.attrNames[i].localPart) || !this.wsdlMeta.isSOAPEnvelopeNamespace(documentScannerSupport.attrNames[i].namespaceURI)) continue;
            this.encoding = documentScannerSupport.attValues[i].toString();
            this.soapEncoded = this.wsdlMeta.isSOAPEncoding(this.encoding);
            EncodingEntry encodingEntry = new EncodingEntry();
            encodingEntry.encoding = this.encoding;
            encodingEntry.soapEncoded = this.soapEncoded;
            encodingEntry.level = documentScannerSupport.elementDepth;
            this.encodingStack.push(encodingEntry);
            this.processedAttributes[i] = true;
            break;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "pushEncoding");
        }
    }

    private void popEncoding() {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "popEncoding");
        }
        if (this.encodingStack == null) {
            if (tc.isEntryEnabled()) {
                SibTr.exit(tc, "popEncoding");
            }
            return;
        }
        if (!this.encodingStack.empty()) {
            DocumentScannerSupport documentScannerSupport = this.getScannerState();
            EncodingEntry encodingEntry = (EncodingEntry)this.encodingStack.peek();
            if (encodingEntry.level == documentScannerSupport.elementDepth) {
                this.encodingStack.pop();
                if (!this.encodingStack.empty()) {
                    encodingEntry = (EncodingEntry)this.encodingStack.peek();
                    this.encoding = encodingEntry.encoding;
                    this.soapEncoded = encodingEntry.soapEncoded;
                } else {
                    this.encoding = null;
                    this.soapEncoded = false;
                }
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "popEncoding");
        }
    }

    public void character(int n, boolean bl) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "character");
        }
        switch (n) {
            case 9: 
            case 10: 
            case 13: 
            case 32: {
                break;
            }
            default: {
                String string = Character.toString((char)n);
                QName qName = this.getScannerState().currentElement;
                String string2 = nls.getFormattedMessage("VALUE_PARSE_ERROR_CWSIF0302", new Object[]{qName.localPart, qName.namespaceURI, string}, "Unexpected character data");
                DataMediatorException dataMediatorException = new DataMediatorException(string2);
                throw new DocumentScanner.TunneledDataMediatorException(dataMediatorException);
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "character");
        }
    }

    public void characters(XMLString xMLString) {
        String string;
        Matcher matcher;
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "characters");
        }
        if (!(matcher = whiteSpace.matcher(string = xMLString.toString())).matches()) {
            QName qName = this.getScannerState().currentElement;
            String string2 = nls.getFormattedMessage("VALUE_PARSE_ERROR_CWSIF0302", new Object[]{qName.localPart, qName.namespaceURI, string}, "Unexpected character data");
            DataMediatorException dataMediatorException = new DataMediatorException(string2);
            throw new DocumentScanner.TunneledDataMediatorException(dataMediatorException);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "characters");
        }
    }

    public void endElementEvent() {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "endElementEvent");
        }
        this.handleEndElementEvent();
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "endElementEvent");
        }
    }

    public void processingInstruction(XMLName xMLName, XMLString xMLString) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "processingInstruction");
        }
        DocumentScannerSupport documentScannerSupport = this.getScannerState();
        QName qName = documentScannerSupport.currentElement;
        String string = nls.getFormattedMessage("PI_PARSE_ERROR_CWSIF0308", new Object[]{qName.localPart, qName.namespaceURI, xMLName}, "Unexpected processing instruction");
        DataMediatorException dataMediatorException = new DataMediatorException(string);
        throw new DocumentScanner.TunneledDataMediatorException(dataMediatorException);
    }

    public void startElementEvent(boolean bl) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "startElementEvent");
        }
        DocumentScannerSupport documentScannerSupport = this.getScannerState();
        documentScannerSupport.resolveNamespaceURIs();
        int n = documentScannerSupport.attrCount;
        if (this.processedAttributes.length < n) {
            this.processedAttributes = new boolean[n];
        }
        for (int i = 0; i < n; ++i) {
            this.processedAttributes[i] = false;
        }
        this.pushEncoding();
        if (bl) {
            this.handleEndElementEvent();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "startElementEvent");
        }
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "Source info: @(#)SIB/ws/code/sib.mfp.sdo.impl/src/com/ibm/ws/sib/mfp/sdo/soap/parse/ParseState.java, SIB.mfp, WAS602.SIB, o0610.11 1.7");
        }
        whiteSpace = Pattern.compile("[ \t\n\r]*");
        ENCODING_KEY = ParseState.class.getName() + "SOAPEncoded";
    }

    private class EncodingEntry {
        String encoding;
        boolean soapEncoded;
        int level;

        private EncodingEntry() {
        }
    }
}

