/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.mfp.sdo.soap;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.mfp.sdo.resource.ResourceCache;
import com.ibm.ws.sib.mfp.sdo.resource.ResourceException;
import com.ibm.ws.sib.mfp.sdo.resource.WSDLMetaData;
import com.ibm.ws.sib.mfp.sdo.resource.XSDMetaData;
import com.ibm.ws.sib.mfp.sdo.soap.SOAPDataMediator;
import com.ibm.ws.sib.mfp.sdo.soap.SOAPFormatDescriptor;
import com.ibm.ws.sib.mfp.sdo.soap.parse.SOAPParser;
import com.ibm.ws.sib.mfp.sdo.soap.write.SOAPWriter;
import com.ibm.ws.sib.mfp.sdo.ws.WebServicesFormatDescriptor;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.sdo.DataMediator;
import com.ibm.wsspi.sib.sdo.DataMediatorException;
import commonj.sdo.DataGraph;
import commonj.sdo.DataObject;
import java.io.IOException;
import java.io.OutputStream;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.sdo.EDataGraph;
import org.eclipse.emf.ecore.sdo.EDataObject;

public class SOAPDataMediatorImpl
implements DataMediator,
SOAPDataMediator {
    private static TraceComponent tc = SibTr.register(SOAPDataMediatorImpl.class, "SIBMfp", "com.ibm.ws.sib.mfp.CWSIFMessages");
    private static TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.mfp.CWSIFMessages");
    private SOAPFormatDescriptor format;
    private ResourceCache cache;
    private WSDLMetaData wsdlMeta;
    private XSDMetaData xsdMeta;

    SOAPDataMediatorImpl(ResourceCache resourceCache, String string) throws DataMediatorException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "<init>");
        }
        this.cache = resourceCache;
        this.wsdlMeta = new WSDLMetaData(this.cache);
        this.xsdMeta = new XSDMetaData(this.cache);
        this.format = new SOAPFormatDescriptor(string);
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "<init>");
        }
    }

    public String getLocation() {
        return this.format.getLocation();
    }

    public String getServiceNamespace() {
        return this.format.getServiceNamespace();
    }

    public String getServiceName() {
        return this.format.getServiceName();
    }

    public String getPortName() {
        return this.format.getPortName();
    }

    public DataGraph createDataGraph() throws DataMediatorException {
        Object object;
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "createDataGraph");
        }
        DataGraph dataGraph = null;
        Throwable throwable = null;
        try {
            object = new SOAPFormatDescriptor(this.format);
            dataGraph = this.cache.createDataGraph(((WebServicesFormatDescriptor)object).getLocation());
            DataObject dataObject = dataGraph.createRootObject("http://www.ibm.com/ns/2004/05/webservices/messagemodel", "");
            dataObject.createDataObject("Info");
        }
        catch (Throwable throwable2) {
            FFDCFilter.processException((Throwable)throwable2, (String)"com.ibm.ws.sib.mfp.sdo.soap.SOAPDataMediatorImpl.createDataGraph", (String)"156", (Object)this);
            throwable = throwable2;
        }
        if (throwable != null) {
            object = nls.getFormattedMessage("SOAP_CREATE_FAILURE_CWSIF0276", new Object[]{throwable}, "SOAP create datagraph failure");
            throw new DataMediatorException((String)object, throwable);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "createDataGraph");
        }
        return dataGraph;
    }

    public DataGraph read(String string, byte[] byArray, int n, int n2) throws DataMediatorException {
        Object object;
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "read", new Object[]{string, byArray, new Integer(n), new Integer(n2)});
        }
        EDataGraph eDataGraph = null;
        Throwable throwable = null;
        try {
            if (n < 0 || n2 < 0 || n + n2 > byArray.length) {
                String string2 = nls.getFormattedMessage("SOAP_BUFFER_ERROR_CWSIF0275", new Object[]{new Integer(byArray.length), new Integer(n), new Integer(n2)}, "Invalid buffer offsets");
                throw new DataMediatorException(string2);
            }
            object = new SOAPFormatDescriptor(this.format);
            SOAPParser sOAPParser = new SOAPParser(this.cache, this.wsdlMeta, this.xsdMeta);
            EDataObject eDataObject = (EDataObject)sOAPParser.parse(string, byArray, n, n2, (SOAPFormatDescriptor)object);
            eDataGraph = (EDataGraph)this.cache.createDataGraph(((WebServicesFormatDescriptor)object).getLocation());
            eDataGraph.setERootObject((EObject)eDataObject);
        }
        catch (DataMediatorException dataMediatorException) {
            throwable = dataMediatorException;
        }
        catch (ResourceException resourceException) {
            throwable = resourceException;
        }
        catch (Throwable throwable2) {
            FFDCFilter.processException((Throwable)throwable2, (String)"com.ibm.ws.sib.mfp.sdo.soap.SOAPDataMediatorImpl.read", (String)"206", (Object)this);
            throwable = throwable2;
        }
        if (throwable != null) {
            object = nls.getFormattedMessage("SOAP_PARSE_FAILURE_CWSIF0271", new Object[]{throwable}, "SOAP parse failure");
            throw new DataMediatorException((String)object, throwable);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "read", eDataGraph);
        }
        return eDataGraph;
    }

    public SOAPDataMediator.Message write(DataGraph dataGraph) throws DataMediatorException {
        String string;
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "write", dataGraph);
        }
        MessageImpl messageImpl = null;
        Throwable throwable = null;
        try {
            string = null;
            byte[] byArray = null;
            int n = 0;
            int n2 = 0;
            DataObject dataObject = dataGraph.getRootObject();
            FixedBufferOutputStream fixedBufferOutputStream = new FixedBufferOutputStream();
            string = this.write(dataObject, fixedBufferOutputStream, false);
            n2 = fixedBufferOutputStream.getLength();
            byArray = fixedBufferOutputStream.getBuffer();
            if (byArray == null) {
                byArray = new byte[n2];
                ByteOutputStream byteOutputStream = new ByteOutputStream(byArray, n, n2);
                this.write(dataObject, byteOutputStream, false);
            }
            messageImpl = new MessageImpl(string, byArray, n, n2);
        }
        catch (DataMediatorException dataMediatorException) {
            throwable = dataMediatorException;
        }
        catch (ResourceException resourceException) {
            throwable = resourceException;
        }
        catch (Throwable throwable2) {
            FFDCFilter.processException((Throwable)throwable2, (String)"com.ibm.ws.sib.mfp.sdo.soap.SOAPDataMediatorImpl.write", (String)"261", (Object)this);
            throwable = throwable2;
        }
        if (throwable != null) {
            string = nls.getFormattedMessage("SOAP_WRITE_FAILURE_CWSIF0273", new Object[]{throwable}, "SOAP write failure");
            throw new DataMediatorException(string, throwable);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "write", messageImpl);
        }
        return messageImpl;
    }

    public DataObject read(byte[] byArray, int n, int n2) throws DataMediatorException {
        Object object;
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "read");
        }
        DataObject dataObject = null;
        Throwable throwable = null;
        try {
            object = new SOAPFormatDescriptor(this.format);
            SOAPParser sOAPParser = new SOAPParser(this.cache, this.wsdlMeta, this.xsdMeta);
            dataObject = sOAPParser.parse(null, byArray, n, n2, (SOAPFormatDescriptor)object);
        }
        catch (DataMediatorException dataMediatorException) {
            throwable = dataMediatorException;
        }
        catch (ResourceException resourceException) {
            throwable = resourceException;
        }
        catch (Throwable throwable2) {
            FFDCFilter.processException((Throwable)throwable2, (String)"com.ibm.ws.sib.mfp.sdo.soap.SOAPDataMediatorImpl.read", (String)"303", (Object)this);
            throwable = throwable2;
        }
        if (throwable != null) {
            object = nls.getFormattedMessage("SOAP_PARSE_FAILURE_CWSIF0271", new Object[]{throwable}, "SOAP parse failure");
            throw new DataMediatorException((String)object, throwable);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "read");
        }
        return dataObject;
    }

    public int getLength(DataObject dataObject, DataMediator.State state) throws DataMediatorException {
        Object object;
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "getLength");
        }
        int n = 0;
        Throwable throwable = null;
        try {
            object = null;
            if (state != null && state.value instanceof SOAPDataMediator.Message) {
                object = (SOAPDataMediator.Message)state.value;
            } else {
                FixedBufferOutputStream fixedBufferOutputStream = new FixedBufferOutputStream();
                this.write(dataObject, fixedBufferOutputStream, true);
                object = new MessageImpl(null, fixedBufferOutputStream.getBuffer(), 0, fixedBufferOutputStream.getLength());
                if (state != null) {
                    state.value = object;
                }
            }
            n = object.getLength();
        }
        catch (DataMediatorException dataMediatorException) {
            throwable = dataMediatorException;
        }
        catch (ResourceException resourceException) {
            throwable = resourceException;
        }
        catch (Throwable throwable2) {
            FFDCFilter.processException((Throwable)throwable2, (String)"com.ibm.ws.sib.mfp.sdo.soap.SOAPDataMediatorImpl.getLength", (String)"356", (Object)this);
            throwable = throwable2;
        }
        if (throwable != null) {
            object = nls.getFormattedMessage("SOAP_LENGTH_FAILURE_CWSIF0272", new Object[]{throwable}, "SOAP getLength failure");
            throw new DataMediatorException((String)object, throwable);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "getLength");
        }
        return n;
    }

    public int write(DataObject dataObject, byte[] byArray, int n, int n2, DataMediator.State state) throws DataMediatorException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "write");
        }
        int n3 = 0;
        Throwable throwable = null;
        try {
            Object object;
            boolean bl = false;
            if (state != null && state.value instanceof SOAPDataMediator.Message && (object = (SOAPDataMediator.Message)state.value).getData() != null) {
                byte[] byArray2 = object.getData();
                int n4 = object.getStartOffset();
                int n5 = object.getLength();
                System.arraycopy(byArray2, n4, byArray, n, n5);
                n3 = n5;
                bl = true;
            }
            if (!bl) {
                object = new ByteOutputStream(byArray, n, n2);
                this.write(dataObject, (OutputStream)object, true);
                n3 = ((ByteOutputStream)object).getLength();
            }
        }
        catch (DataMediatorException dataMediatorException) {
            throwable = dataMediatorException;
        }
        catch (ResourceException resourceException) {
            throwable = resourceException;
        }
        catch (Throwable throwable2) {
            FFDCFilter.processException((Throwable)throwable2, (String)"com.ibm.ws.sib.mfp.sdo.soap.SOAPDataMediatorImpl.write", (String)"413", (Object)this);
            throwable = throwable2;
        }
        if (throwable != null) {
            String string = nls.getFormattedMessage("SOAP_WRITE_FAILURE_CWSIF0273", new Object[]{throwable}, "SOAP write failure");
            throw new DataMediatorException(string, throwable);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "write");
        }
        return n3;
    }

    public DataObject readTransform(byte[] byArray, String string) throws DataMediatorException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "readTransform");
        }
        DataObject dataObject = this.read(byArray, 0, byArray.length);
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "readTransform");
        }
        return dataObject;
    }

    public byte[] writeTransform(DataObject dataObject, String string) throws DataMediatorException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "writeTransform");
        }
        DataMediator.State state = new DataMediator.State();
        int n = this.getLength(dataObject, state);
        byte[] byArray = new byte[n];
        this.write(dataObject, byArray, 0, n, state);
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "writeTransform");
        }
        return byArray;
    }

    private String write(DataObject dataObject, OutputStream outputStream, boolean bl) throws IOException, DataMediatorException, ResourceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "write(data, stream)");
        }
        SOAPFormatDescriptor sOAPFormatDescriptor = new SOAPFormatDescriptor(this.format);
        SOAPWriter sOAPWriter = new SOAPWriter(this.wsdlMeta, this.xsdMeta);
        String string = sOAPWriter.write(outputStream, dataObject, sOAPFormatDescriptor, bl);
        outputStream.flush();
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "write(data, stream)", (Object)string);
        }
        return string;
    }

    public SOAPDataMediator.Message writeDetail(DataObject dataObject) throws DataMediatorException {
        Object object;
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "writeDetail", dataObject);
        }
        MessageImpl messageImpl = null;
        Throwable throwable = null;
        try {
            object = null;
            int n = 0;
            int n2 = 0;
            SOAPFormatDescriptor sOAPFormatDescriptor = new SOAPFormatDescriptor(this.format);
            sOAPFormatDescriptor.setOperationName(dataObject.getString("operationName"));
            sOAPFormatDescriptor.setMessageName(dataObject.getString("messageName"));
            sOAPFormatDescriptor.setMessageType(dataObject.getString("messageType"));
            FixedBufferOutputStream fixedBufferOutputStream = new FixedBufferOutputStream();
            SOAPWriter sOAPWriter = new SOAPWriter(this.wsdlMeta, this.xsdMeta);
            sOAPWriter.writeDetail(fixedBufferOutputStream, dataObject, sOAPFormatDescriptor);
            fixedBufferOutputStream.flush();
            n2 = fixedBufferOutputStream.getLength();
            object = fixedBufferOutputStream.getBuffer();
            if (object == null) {
                object = new byte[n2];
                ByteOutputStream byteOutputStream = new ByteOutputStream((byte[])object, n, n2);
                sOAPWriter = new SOAPWriter(this.wsdlMeta, this.xsdMeta);
                sOAPWriter.writeDetail(fixedBufferOutputStream, dataObject, sOAPFormatDescriptor);
            }
            messageImpl = new MessageImpl(null, (byte[])object, n, n2);
        }
        catch (DataMediatorException dataMediatorException) {
            throwable = dataMediatorException;
        }
        catch (ResourceException resourceException) {
            throwable = resourceException;
        }
        catch (Throwable throwable2) {
            FFDCFilter.processException((Throwable)throwable2, (String)"com.ibm.ws.sib.mfp.sdo.soap.SOAPDataMediatorImpl.writeDetail", (String)"528", (Object)this);
            throwable = throwable2;
        }
        if (throwable != null) {
            object = nls.getFormattedMessage("SOAP_WRITE_FAILURE_CWSIF0273", new Object[]{throwable}, "SOAP write failure");
            throw new DataMediatorException((String)object, throwable);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "writeDetail", messageImpl);
        }
        return messageImpl;
    }

    public void readDetail(DataObject dataObject, byte[] byArray, int n, int n2) throws DataMediatorException {
        Object object;
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "readDetail", new Object[]{dataObject, byArray, new Integer(n), new Integer(n2)});
        }
        Object var5_5 = null;
        Throwable throwable = null;
        try {
            object = new SOAPFormatDescriptor(this.format);
            SOAPParser sOAPParser = new SOAPParser(this.cache, this.wsdlMeta, this.xsdMeta);
            sOAPParser.parseDetail(dataObject, byArray, n, n2, (SOAPFormatDescriptor)object);
        }
        catch (DataMediatorException dataMediatorException) {
            throwable = dataMediatorException;
        }
        catch (ResourceException resourceException) {
            throwable = resourceException;
        }
        catch (Throwable throwable2) {
            FFDCFilter.processException((Throwable)throwable2, (String)"com.ibm.ws.sib.mfp.sdo.soap.SOAPDataMediatorImpl.readDetail", (String)"571", (Object)this);
            throwable = throwable2;
        }
        if (throwable != null) {
            object = nls.getFormattedMessage("SOAP_PARSE_FAILURE_CWSIF0271", new Object[]{throwable}, "SOAP parse failure");
            throw new DataMediatorException((String)object, throwable);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "readDetail");
        }
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "Source info: @(#)SIB/ws/code/sib.mfp.sdo.impl/src/com/ibm/ws/sib/mfp/sdo/soap/SOAPDataMediatorImpl.java, SIB.mfp, WAS602.SIB, o0610.11 1.11");
        }
    }

    private class MessageImpl
    implements SOAPDataMediator.Message {
        private String contentType;
        private byte[] data;
        private int startOffset;
        private int length;

        public MessageImpl(String string, byte[] byArray, int n, int n2) {
            this.contentType = string;
            this.data = byArray;
            this.startOffset = n;
            this.length = n2;
        }

        public String getContentType() {
            return this.contentType;
        }

        public byte[] getData() {
            return this.data;
        }

        public int getStartOffset() {
            return this.startOffset;
        }

        public int getLength() {
            return this.length;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Message [ contentType: ");
            stringBuffer.append(this.contentType);
            stringBuffer.append(", data: ");
            stringBuffer.append(this.data);
            stringBuffer.append(", startOffset: ");
            stringBuffer.append(this.startOffset);
            stringBuffer.append(", length: ");
            stringBuffer.append(this.length);
            stringBuffer.append(" ]");
            return stringBuffer.toString();
        }
    }

    private class ByteOutputStream
    extends OutputStream {
        byte[] frame;
        int start;
        int length;
        int currentOffset;

        public ByteOutputStream(byte[] byArray, int n, int n2) {
            this.frame = byArray;
            this.start = this.currentOffset = n;
            this.length = n2;
        }

        public int getLength() {
            return this.currentOffset - this.start;
        }

        public void close() throws IOException {
        }

        public void flush() throws IOException {
        }

        public void write(byte[] byArray, int n, int n2) throws IOException {
            System.arraycopy(byArray, n, this.frame, this.currentOffset, n2);
            this.currentOffset += n2;
        }

        public void write(byte[] byArray) throws IOException {
            System.arraycopy(byArray, 0, this.frame, this.currentOffset, byArray.length);
            this.currentOffset += byArray.length;
        }

        public void write(int n) throws IOException {
            this.frame[this.currentOffset++] = (byte)n;
        }
    }

    private static class FixedBufferOutputStream
    extends OutputStream {
        private static final int BUFFER_SIZE = 4096;
        int length = 0;
        byte[] buffer = new byte[4096];

        private FixedBufferOutputStream() {
        }

        public int getLength() {
            return this.length;
        }

        public byte[] getBuffer() {
            if (this.length <= 4096) {
                return this.buffer;
            }
            return null;
        }

        public void close() throws IOException {
        }

        public void flush() throws IOException {
        }

        public void write(byte[] byArray, int n, int n2) throws IOException {
            if (this.length + n2 <= 4096) {
                System.arraycopy(byArray, n, this.buffer, this.length, n2);
            }
            this.length += n2;
        }

        public void write(byte[] byArray) throws IOException {
            if (this.length + byArray.length <= 4096) {
                System.arraycopy(byArray, 0, this.buffer, this.length, byArray.length);
            }
            this.length += byArray.length;
        }

        public void write(int n) throws IOException {
            if (this.length < 4096) {
                this.buffer[this.length] = (byte)n;
            }
            ++this.length;
        }
    }
}

