/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.mfp.sdo.resource;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.mfp.sdo.SdoInstanceFactory;
import com.ibm.ws.sib.mfp.sdo.resource.ResourceCache;
import com.ibm.ws.sib.mfp.sdo.resource.ResourceException;
import com.ibm.ws.sib.mfp.sdo.resource.ResourceLoader;
import com.ibm.ws.sib.mfp.sdo.resource.ResourceNotFoundException;
import com.ibm.ws.sib.mfp.sdo.resource.XSDResourceHelper;
import com.ibm.ws.sib.mfp.sdo.resource.type.JSXMLTypePackage;
import com.ibm.ws.sib.mfp.sdo.util.Privileged;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.ExtendedMetaData;
import org.eclipse.xsd.XSDDiagnosticSeverity;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.ecore.XSDEcoreBuilder;
import org.eclipse.xsd.util.XSDResourceImpl;

public class XSDResourceLoader {
    private static TraceComponent tc = SibTr.register(XSDResourceLoader.class, "SIBMfp", "com.ibm.ws.sib.mfp.CWSIFMessages");
    private static TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.mfp.CWSIFMessages");
    private ResourceCache cache;
    private ResourceLoader loader;
    static /* synthetic */ Class class$com$ibm$ws$sib$mfp$sdo$resource$XSDResourceLoader$ErrorCheckEcoreBuilder;

    public XSDResourceLoader(ResourceLoader resourceLoader, ResourceCache resourceCache) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "<init>", resourceLoader);
        }
        this.loader = resourceLoader;
        this.cache = resourceCache;
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "<init>");
        }
    }

    static synchronized void convertSchema(ResourceSet resourceSet) throws ResourceException {
        Iterator<Object> iterator;
        Object object;
        String string;
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "convertSchema");
        }
        ErrorCheckEcoreBuilder errorCheckEcoreBuilder = new ErrorCheckEcoreBuilder();
        Iterator iterator2 = resourceSet.getResources().iterator();
        while (iterator2.hasNext()) {
            string = (Resource)iterator2.next();
            object = string.getContents().iterator();
            while (object.hasNext()) {
                iterator = object.next();
                if (!(iterator instanceof XSDSchema)) continue;
                errorCheckEcoreBuilder.generate((XSDSchema)iterator);
            }
        }
        string = errorCheckEcoreBuilder.getFirstError();
        if (string != null) {
            object = nls.getFormattedMessage("XSD_ERROR_CWSIF0243", new Object[]{string}, "Import failed");
            throw new ResourceException((String)object);
        }
        object = errorCheckEcoreBuilder.getTargetNamespaceToEPackageMap();
        iterator = object.values().iterator();
        while (iterator.hasNext()) {
            ((EPackage)iterator.next()).setEFactoryInstance((EFactory)new SdoInstanceFactory());
        }
        Iterator iterator3 = errorCheckEcoreBuilder.getSchemas().iterator();
        while (iterator3.hasNext()) {
            XSDSchema xSDSchema = (XSDSchema)iterator3.next();
            Resource resource = xSDSchema.eResource();
            EPackage ePackage = (EPackage)object.get(xSDSchema.getTargetNamespace());
            if (ePackage == null || ePackage.eResource() != null) continue;
            resource.getContents().add((Object)ePackage);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "convertSchema");
        }
    }

    public ResourceSet loadSchema(String string) throws ResourceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "loadSchema", (Object)string);
        }
        ResourceSet resourceSet = null;
        try {
            InputStream inputStream = this.loader.getInputStream(string);
            if (inputStream != null) {
                resourceSet = XSDResourceHelper.createResourceSet(string, this.cache);
                HashMap<String, Boolean> hashMap = new HashMap<String, Boolean>();
                hashMap.put(XSDResourceImpl.XSD_TRACK_LOCATION, Boolean.TRUE);
                Resource resource = resourceSet.createResource(URI.createURI((String)string));
                Privileged.resourceLoad(resource, inputStream, hashMap);
                if (resource.getErrors().size() != 0) {
                    Object object = resource.getErrors().get(0);
                    String string2 = nls.getFormattedMessage("INVALID_XSD_CWSIF0242", new Object[]{object}, "Failed to load XML Schema");
                    throw new ResourceException(string2);
                }
                XSDResourceLoader.convertSchema(resourceSet);
            }
        }
        catch (Throwable throwable) {
            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.sib.mfp.sdo.resource.XSDResourceLoader.loadSchema", (String)"203", (Object)this);
            String string3 = nls.getFormattedMessage("INVALID_XSD_CWSIF0241", new Object[]{string, throwable}, "Failed to import XML Schema.");
            if (throwable instanceof ResourceNotFoundException) {
                throw new ResourceNotFoundException(string3, throwable);
            }
            throw new ResourceException(string3, throwable);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "loadSchema", resourceSet);
        }
        return resourceSet;
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "Source info: @(#)SIB/ws/code/sib.mfp.sdo.impl/src/com/ibm/ws/sib/mfp/sdo/resource/XSDResourceLoader.java, SIB.mfp, WAS602.SIB, o0610.11 1.16");
        }
    }

    private static class ErrorCheckEcoreBuilder
    extends XSDEcoreBuilder {
        private final TraceComponent nested_tc = SibTr.register(class$com$ibm$ws$sib$mfp$sdo$resource$XSDResourceLoader$ErrorCheckEcoreBuilder == null ? (class$com$ibm$ws$sib$mfp$sdo$resource$XSDResourceLoader$ErrorCheckEcoreBuilder = XSDResourceLoader.class$("com.ibm.ws.sib.mfp.sdo.resource.XSDResourceLoader$ErrorCheckEcoreBuilder")) : class$com$ibm$ws$sib$mfp$sdo$resource$XSDResourceLoader$ErrorCheckEcoreBuilder, "com.ibm.ws.sib.mfp.CWSIFMessages", "com.ibm.ws.sib.mfp.CWSIFMessages");

        ErrorCheckEcoreBuilder() {
            if (this.nested_tc.isEntryEnabled()) {
                SibTr.entry(this.nested_tc, "ErrorCheckEcoreBuilder");
            }
            this.simpleDiagnostics = new ArrayList();
            if (this.nested_tc.isEntryEnabled()) {
                SibTr.exit(this.nested_tc, "ErrorCheckEcoreBuilder", (Object)this);
            }
        }

        String getFirstError() {
            if (this.nested_tc.isEntryEnabled()) {
                SibTr.entry(this.nested_tc, "getFirstError");
            }
            String string = null;
            Iterator iterator = this.simpleDiagnostics.iterator();
            while (string == null && iterator.hasNext()) {
                List list = (List)iterator.next();
                if (!XSDDiagnosticSeverity.FATAL_LITERAL.getName().equals(list.get(0)) && !XSDDiagnosticSeverity.ERROR_LITERAL.getName().equals(list.get(0))) continue;
                string = (String)list.get(1);
            }
            if (this.nested_tc.isEntryEnabled()) {
                SibTr.exit(this.nested_tc, "getFirstError", string);
            }
            return string;
        }

        List getSchemas() {
            if (this.nested_tc.isEntryEnabled()) {
                SibTr.entry(this.nested_tc, "getSchemas");
            }
            List list = this.xsdSchemas;
            if (this.nested_tc.isEntryEnabled()) {
                SibTr.exit(this.nested_tc, "getSchemas", list);
            }
            return list;
        }

        protected EClassifier getBuiltInEClassifier(String string, String string2) {
            if (this.nested_tc.isEntryEnabled()) {
                SibTr.entry(this.nested_tc, "getBuiltInEClassifier", new Object[]{string, string2});
            }
            EClassifier eClassifier = null;
            ExtendedMetaData extendedMetaData = ExtendedMetaData.INSTANCE;
            eClassifier = extendedMetaData.getType((EPackage)JSXMLTypePackage.eINSTANCE, string2);
            if (eClassifier == null) {
                eClassifier = super.getBuiltInEClassifier(string, string2);
            }
            if (this.nested_tc.isEntryEnabled()) {
                SibTr.exit(this.nested_tc, "getBuiltInEClassifier", eClassifier);
            }
            return eClassifier;
        }
    }
}

