/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.mfp.sdo.resource;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.mfp.sdo.resource.ResourceCache;
import com.ibm.ws.sib.mfp.sdo.resource.ResourceException;
import com.ibm.ws.sib.mfp.sdo.resource.ResourceLoader;
import com.ibm.ws.sib.mfp.sdo.resource.ResourceNotFoundException;
import com.ibm.ws.sib.mfp.sdo.resource.WSDLResourceLoader;
import com.ibm.ws.sib.mfp.sdo.resource.XSDResourceHelper;
import com.ibm.ws.sib.mfp.sdo.resource.XSDResourceLoader;
import com.ibm.ws.sib.mfp.sdo.resource.loader.MFPResourceLoader;
import com.ibm.ws.sib.mfp.sdo.resource.loader.ResourceTracker;
import com.ibm.ws.sib.mfp.sdo.util.Privileged;
import com.ibm.ws.sib.utils.ras.SibTr;
import commonj.sdo.DataGraph;
import commonj.sdo.DataObject;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.wsdl.Definition;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.sdo.EDataGraph;
import org.eclipse.emf.ecore.sdo.SDOFactory;
import org.eclipse.emf.ecore.util.ExtendedMetaData;
import org.eclipse.xsd.XSDSchema;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

class ResourceCacheImpl
implements ResourceCache {
    private static final TraceComponent tc = SibTr.register(ResourceCacheImpl.class, "SIBMfp", "com.ibm.ws.sib.mfp.CWSIFMessages");
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.mfp.CWSIFMessages");
    private static final String intervalProp = "com.ibm.ws.sib.mfp.sdo.repository.SdoRepositoryCache.interval";
    private Map objectCache;
    private CacheMonitor monitor;
    private ResourceLoader loader;
    static /* synthetic */ Class class$com$ibm$ws$sib$mfp$sdo$resource$ResourceCacheImpl$CacheEntry;
    static /* synthetic */ Class class$com$ibm$ws$sib$mfp$sdo$resource$ResourceCacheImpl$ResourceHandler;
    static /* synthetic */ Class class$com$ibm$ws$sib$mfp$sdo$resource$ResourceCacheImpl$CacheMonitor;

    public ResourceCacheImpl(ResourceLoader resourceLoader, boolean bl) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "ResourceCacheImpl");
        }
        this.loader = new MFPResourceLoader(resourceLoader);
        this.objectCache = new HashMap();
        this.monitor = new CacheMonitor();
        if (bl) {
            try {
                String string = Privileged.getSystemProperty(intervalProp);
                if (string != null) {
                    long l = Long.parseLong(string);
                    if (l < 0L) {
                        this.setThreshold(-1L);
                    } else {
                        this.setThreshold(l * 1000L);
                    }
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.sib.mfp.sdo.resource.ResourceCacheImpl.ResourceCacheImpl", (String)"132", (Object)this);
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "ResourceCacheImpl");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XSDSchema getSchemaModel(String string) throws ResourceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "getSchemaModel", (Object)string);
        }
        XSDSchema xSDSchema = null;
        CacheEntry cacheEntry = null;
        do {
            xSDSchema = null;
            Map map = this.objectCache;
            synchronized (map) {
                cacheEntry = (CacheEntry)this.objectCache.get(string);
            }
            if (cacheEntry == null) {
                cacheEntry = this.loadSchemaResource(string);
            }
            if (cacheEntry == null) continue;
            xSDSchema = (XSDSchema)cacheEntry.payload;
        } while (cacheEntry != null && !this.monitor.isValid(cacheEntry));
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "getSchemaModel", xSDSchema);
        }
        return xSDSchema;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Definition getWSDLModel(String string) throws ResourceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "getWSDLModel", (Object)string);
        }
        Definition definition = null;
        CacheEntry cacheEntry = null;
        do {
            definition = null;
            Map map = this.objectCache;
            synchronized (map) {
                cacheEntry = (CacheEntry)this.objectCache.get(string);
            }
            if (cacheEntry == null) {
                cacheEntry = this.loadWSDLResource(string);
            }
            if (cacheEntry == null) continue;
            definition = (Definition)cacheEntry.payload;
        } while (cacheEntry != null && !this.monitor.isValid(cacheEntry));
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "getWSDLModel", new Boolean(definition != null));
        }
        return definition;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XSDSchema getSchemaModel(String string, String string2) throws ResourceException {
        Map map;
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "getSchemaModel", new Object[]{string, string2});
        }
        XSDSchema xSDSchema = null;
        CacheEntry cacheEntry = null;
        if (string2 != null) {
            do {
                xSDSchema = null;
                map = this.objectCache;
                synchronized (map) {
                    cacheEntry = (CacheEntry)this.objectCache.get(string2);
                }
                if (cacheEntry == null) {
                    cacheEntry = this.loadResource(string2);
                }
                if (cacheEntry == null) continue;
                xSDSchema = XSDResourceHelper.locateSchema(cacheEntry.resourceSet, string, string2);
            } while (cacheEntry != null && !this.monitor.isValid(cacheEntry));
        }
        if (xSDSchema == null) {
            do {
                xSDSchema = null;
                map = this.objectCache;
                synchronized (map) {
                    cacheEntry = (CacheEntry)this.objectCache.get(string);
                }
                if (cacheEntry == null) {
                    cacheEntry = this.loadResource(string);
                }
                if (cacheEntry == null) continue;
                xSDSchema = XSDResourceHelper.locateSchema(cacheEntry.resourceSet, string, string);
            } while (cacheEntry != null && !this.monitor.isValid(cacheEntry));
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "getSchemaModel", xSDSchema);
        }
        return xSDSchema;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EPackage getEcoreModel(String string, String string2) throws ResourceException {
        Object object;
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "getEcoreModel", new Object[]{string, string2});
        }
        EPackage ePackage = null;
        CacheEntry cacheEntry = null;
        if (string2 != null) {
            do {
                ePackage = null;
                object = this.objectCache;
                synchronized (object) {
                    cacheEntry = (CacheEntry)this.objectCache.get(string2);
                }
                if (cacheEntry == null) {
                    cacheEntry = this.loadResource(string2);
                }
                if (cacheEntry == null) continue;
                ePackage = XSDResourceHelper.locatePackage(cacheEntry.resourceSet, string, string2);
            } while (cacheEntry != null && !this.monitor.isValid(cacheEntry));
        }
        if (ePackage == null) {
            do {
                block23: {
                    ePackage = null;
                    object = this.objectCache;
                    synchronized (object) {
                        cacheEntry = (CacheEntry)this.objectCache.get(string);
                    }
                    if (cacheEntry == null) {
                        try {
                            cacheEntry = this.loadResource(string);
                        }
                        catch (ResourceNotFoundException resourceNotFoundException) {
                            if (!tc.isDebugEnabled()) break block23;
                            SibTr.debug(tc, "Supressing resource exception", resourceNotFoundException);
                        }
                    }
                }
                if (cacheEntry == null) continue;
                ePackage = XSDResourceHelper.locatePackage(cacheEntry.resourceSet, string, string);
            } while (cacheEntry != null && !this.monitor.isValid(cacheEntry));
        }
        if (ePackage == null) {
            object = null;
            do {
                ePackage = null;
                cacheEntry = null;
                Map map = this.objectCache;
                synchronized (map) {
                    Iterator iterator = this.objectCache.values().iterator();
                    while (ePackage == null && iterator.hasNext()) {
                        cacheEntry = (CacheEntry)iterator.next();
                        if (string != null && string.equals(cacheEntry.targetNamespace)) {
                            ePackage = XSDResourceHelper.locatePackage(cacheEntry.resourceSet, string);
                            object = cacheEntry.locationURI;
                            continue;
                        }
                        ePackage = null;
                        cacheEntry = null;
                        object = null;
                    }
                }
            } while (cacheEntry != null && !this.monitor.isValid(cacheEntry));
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "getEcoreModel", ePackage);
        }
        return ePackage;
    }

    public DataGraph createDataGraph(String string) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "createDataGraph", (Object)string);
        }
        EDataGraph eDataGraph = SDOFactory.eINSTANCE.createEDataGraph();
        ResourceSet resourceSet = XSDResourceHelper.createResourceSet(string, this);
        eDataGraph.setResourceSet(resourceSet);
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "createDataGraph", eDataGraph);
        }
        return eDataGraph;
    }

    public DataObject createDataObject(String string, String string2, String string3) throws ResourceException {
        ExtendedMetaData extendedMetaData;
        EClassifier eClassifier;
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "createDataObject", new Object[]{string, string2, string3});
        }
        DataObject dataObject = null;
        EPackage ePackage = this.getEcoreModel(string, string3);
        if (ePackage != null && (eClassifier = (extendedMetaData = ExtendedMetaData.INSTANCE).getType(ePackage, string2)) instanceof EClass) {
            dataObject = (DataObject)ePackage.getEFactoryInstance().create((EClass)eClassifier);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "createDataObject", dataObject);
        }
        return dataObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "clear");
        }
        Map map = this.objectCache;
        synchronized (map) {
            this.objectCache.clear();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "clear");
        }
    }

    public void setThreshold(long l) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "setThreshold", new Long(l));
        }
        this.monitor.setThreshold(l);
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "setThreshold");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CacheEntry setupCache(ResourceSet resourceSet, Object object, String string, ResourceTracker resourceTracker) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "setupCache", new Object[]{string});
        }
        CacheEntry cacheEntry = null;
        String string2 = null;
        if (object instanceof XSDSchema) {
            string2 = ((XSDSchema)object).getTargetNamespace();
        }
        CacheEntry cacheEntry2 = new CacheEntry(string, string2, resourceSet, object, resourceTracker.getResources());
        Object object2 = this.objectCache;
        synchronized (object2) {
            cacheEntry = (CacheEntry)this.objectCache.get(string);
            if (cacheEntry == null) {
                cacheEntry = cacheEntry2;
                this.objectCache.put(string, cacheEntry);
            }
        }
        if (cacheEntry != cacheEntry2) {
            object2 = resourceSet.getResources().iterator();
            while (object2.hasNext()) {
                Resource resource = (Resource)object2.next();
                Iterator iterator = resource.getContents().iterator();
                while (iterator.hasNext()) {
                    Object e = iterator.next();
                    if (!(e instanceof EPackage)) continue;
                    EPackage ePackage = (EPackage)e;
                    Iterator iterator2 = ePackage.getEClassifiers().iterator();
                    while (iterator2.hasNext()) {
                        EClassifier eClassifier = (EClassifier)iterator2.next();
                        if (!(eClassifier instanceof EClass)) continue;
                        ((EClass)eClassifier).getESuperTypes().clear();
                    }
                }
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "setupCache", cacheEntry);
        }
        return cacheEntry;
    }

    private CacheEntry loadResource(String string) throws ResourceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "loadResource", (Object)string);
        }
        CacheEntry cacheEntry = null;
        InputStream inputStream = this.loader.getInputStream(string);
        InputSource inputSource = new InputSource(inputStream);
        inputSource.setSystemId(string);
        if (inputSource != null) {
            int n = 0;
            try {
                SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
                sAXParserFactory.setValidating(false);
                sAXParserFactory.setNamespaceAware(true);
                SAXParser sAXParser = sAXParserFactory.newSAXParser();
                sAXParser.parse(inputSource, (DefaultHandler)new ResourceHandler());
            }
            catch (StopParsing stopParsing) {
                n = stopParsing.getReason();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (n == 1) {
                cacheEntry = this.loadSchemaResource(string);
            } else if (n == 2) {
                cacheEntry = this.loadWSDLResource(string);
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "loadResource", cacheEntry);
        }
        return cacheEntry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CacheEntry loadSchemaResource(String string) throws ResourceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "loadSchemaResource", (Object)string);
        }
        CacheEntry cacheEntry = null;
        ResourceTracker resourceTracker = new ResourceTracker(this.loader);
        XSDResourceLoader xSDResourceLoader = new XSDResourceLoader(resourceTracker, this);
        ResourceSet resourceSet = xSDResourceLoader.loadSchema(string);
        Object var6_6 = null;
        if (resourceSet != null) {
            Map map = this.objectCache;
            synchronized (map) {
                Iterator iterator = resourceSet.getResources().iterator();
                block3: while (iterator.hasNext()) {
                    Resource resource = (Resource)iterator.next();
                    Iterator iterator2 = resource.getContents().iterator();
                    while (iterator2.hasNext()) {
                        Object e = iterator2.next();
                        if (!(e instanceof XSDSchema)) continue;
                        CacheEntry cacheEntry2 = this.setupCache(resourceSet, e, resource.getURI().toString(), resourceTracker);
                        if (!cacheEntry2.locationURI.equals(string)) continue block3;
                        cacheEntry = cacheEntry2;
                        continue block3;
                    }
                }
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "loadSchemaResource", cacheEntry);
        }
        return cacheEntry;
    }

    private CacheEntry loadWSDLResource(String string) throws ResourceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "loadWSDLResource", (Object)string);
        }
        CacheEntry cacheEntry = null;
        ResourceTracker resourceTracker = new ResourceTracker(this.loader);
        WSDLResourceLoader wSDLResourceLoader = new WSDLResourceLoader(resourceTracker, this);
        List list = wSDLResourceLoader.loadWSDL(string);
        if (list != null && list.size() == 2) {
            cacheEntry = this.setupCache((ResourceSet)list.get(1), list.get(0), string, resourceTracker);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "loadWSDLResource", cacheEntry);
        }
        return cacheEntry;
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "@(#)SIB/ws/code/sib.mfp.sdo.impl/src/com/ibm/ws/sib/mfp/sdo/resource/ResourceCacheImpl.java, SIB.mfp, WAS602.SIB, o0610.11 1.4");
        }
    }

    private class CacheMonitor {
        private final TraceComponent nested_tc = SibTr.register(class$com$ibm$ws$sib$mfp$sdo$resource$ResourceCacheImpl$CacheMonitor == null ? (class$com$ibm$ws$sib$mfp$sdo$resource$ResourceCacheImpl$CacheMonitor = ResourceCacheImpl.class$("com.ibm.ws.sib.mfp.sdo.resource.ResourceCacheImpl$CacheMonitor")) : class$com$ibm$ws$sib$mfp$sdo$resource$ResourceCacheImpl$CacheMonitor, "SIBMfp", "com.ibm.ws.sib.mfp.CWSIFMessages");
        private long threshold = 30000L;
        private boolean checkInProgress;
        private long lastCheck;

        CacheMonitor() {
        }

        void setThreshold(long l) {
            if (this.nested_tc.isEntryEnabled()) {
                SibTr.entry(this.nested_tc, "setThreshold", new Long(l));
            }
            this.threshold = l;
            if (this.nested_tc.isEntryEnabled()) {
                SibTr.exit(this.nested_tc, "setThreshold");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean isValid(CacheEntry cacheEntry) {
            if (this.nested_tc.isEntryEnabled()) {
                SibTr.entry(this.nested_tc, "isValid", cacheEntry);
            }
            if (this.threshold < 0L) {
                if (this.nested_tc.isEntryEnabled()) {
                    SibTr.exit(this.nested_tc, "isValid", (Object)"Checking disabled");
                }
                return true;
            }
            long l = System.currentTimeMillis();
            Boolean bl = Boolean.TRUE;
            boolean bl2 = false;
            Object object = this;
            synchronized (object) {
                if (!this.checkInProgress && l - this.lastCheck > this.threshold) {
                    bl2 = true;
                    this.checkInProgress = true;
                }
            }
            if (bl2) {
                CacheMonitor cacheMonitor;
                try {
                    Object object2;
                    Object object3;
                    Object object4;
                    object = new HashMap();
                    Object object5 = ResourceCacheImpl.this.objectCache;
                    synchronized (object5) {
                        object4 = ResourceCacheImpl.this.objectCache.values().iterator();
                        while (object4.hasNext()) {
                            object3 = (CacheEntry)object4.next();
                            object2 = ((CacheEntry)object3).resourceNames.iterator();
                            while (object2.hasNext()) {
                                String string = (String)object2.next();
                                Long l2 = (Long)object.get(string);
                                if (l2 != null && ((CacheEntry)object3).creationTimestamp >= l2) continue;
                                object.put(string, ((CacheEntry)object3).creationTimestamp);
                            }
                        }
                    }
                    object5 = object.keySet().iterator();
                    while (object5.hasNext()) {
                        object4 = (String)object5.next();
                        object3 = (Long)object.get(object4);
                        object2 = ResourceCacheImpl.this.loader.getTimestamp((String)object4);
                        if (object2 != null && (Long)object2 <= (Long)object3) continue;
                        ResourceCacheImpl.this.clear();
                        bl = Boolean.FALSE;
                        break;
                    }
                    object4 = this;
                    synchronized (object4) {
                        this.lastCheck = System.currentTimeMillis();
                    }
                    Object var16_15 = null;
                    cacheMonitor = this;
                }
                catch (Throwable throwable) {
                    Object var16_16 = null;
                    CacheMonitor cacheMonitor2 = this;
                    synchronized (cacheMonitor2) {
                        this.checkInProgress = false;
                    }
                    throw throwable;
                }
                synchronized (cacheMonitor) {
                    this.checkInProgress = false;
                }
            }
            object = ResourceCacheImpl.this.objectCache;
            synchronized (object) {
                if (!ResourceCacheImpl.this.objectCache.containsValue(cacheEntry)) {
                    bl = Boolean.FALSE;
                }
            }
            if (this.nested_tc.isEntryEnabled()) {
                SibTr.exit(this.nested_tc, "isValid", bl);
            }
            return bl;
        }
    }

    private static class StopParsing
    extends SAXException {
        private static final long serialVersionUID = 1L;
        static final int UNKNOWN_RESOURCE = 0;
        static final int XSD_RESOURCE = 1;
        static final int WSDL_RESOURCE = 2;
        private int reason;

        StopParsing(int n) {
            this.reason = n;
        }

        int getReason() {
            return this.reason;
        }

        public synchronized Throwable fillInStackTrace() {
            return this;
        }
    }

    private static class ResourceHandler
    extends DefaultHandler {
        private static final TraceComponent nested_tc = SibTr.register(class$com$ibm$ws$sib$mfp$sdo$resource$ResourceCacheImpl$ResourceHandler == null ? (class$com$ibm$ws$sib$mfp$sdo$resource$ResourceCacheImpl$ResourceHandler = ResourceCacheImpl.class$("com.ibm.ws.sib.mfp.sdo.resource.ResourceCacheImpl$ResourceHandler")) : class$com$ibm$ws$sib$mfp$sdo$resource$ResourceCacheImpl$ResourceHandler, "com.ibm.ws.sib.mfp.CWSIFMessages", "com.ibm.ws.sib.mfp.CWSIFMessages");

        ResourceHandler() {
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            if (nested_tc.isEntryEnabled()) {
                SibTr.entry(nested_tc, "startElement", new Object[]{string, string2});
            }
            if ("http://www.w3.org/2001/XMLSchema".equals(string) && "schema".equals(string2)) {
                throw new StopParsing(1);
            }
            if ("http://schemas.xmlsoap.org/wsdl/".equals(string) && "definitions".equals(string2)) {
                throw new StopParsing(2);
            }
            throw new StopParsing(0);
        }
    }

    private static class CacheEntry {
        private static final TraceComponent nested_tc = SibTr.register(class$com$ibm$ws$sib$mfp$sdo$resource$ResourceCacheImpl$CacheEntry == null ? (class$com$ibm$ws$sib$mfp$sdo$resource$ResourceCacheImpl$CacheEntry = ResourceCacheImpl.class$("com.ibm.ws.sib.mfp.sdo.resource.ResourceCacheImpl$CacheEntry")) : class$com$ibm$ws$sib$mfp$sdo$resource$ResourceCacheImpl$CacheEntry, "com.ibm.ws.sib.mfp.CWSIFMessages", "com.ibm.ws.sib.mfp.CWSIFMessages");
        public Long creationTimestamp;
        public String locationURI;
        public String targetNamespace;
        public ResourceSet resourceSet;
        public Object payload;
        public List resourceNames;

        CacheEntry(String string, String string2, ResourceSet resourceSet, Object object, List list) {
            if (nested_tc.isEntryEnabled()) {
                SibTr.entry(nested_tc, "CacheEntry", new Object[]{string, string2, list});
            }
            this.creationTimestamp = new Long(System.currentTimeMillis());
            this.locationURI = string;
            this.targetNamespace = string2;
            this.resourceSet = resourceSet;
            this.payload = object;
            this.resourceNames = list;
            if (nested_tc.isEntryEnabled()) {
                SibTr.exit(nested_tc, "CacheEntry", this);
            }
        }
    }
}

