/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.mfp.sdo.mime.impl;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.sib.exception.SIMessageParseException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.mfp.sdo.mime.MimeElement;
import com.ibm.ws.sib.mfp.sdo.mime.MimeElementList;
import com.ibm.ws.sib.mfp.sdo.mime.MimeFactory;
import com.ibm.ws.sib.mfp.sdo.mime.impl.MergedInputStream;
import com.ibm.ws.sib.mfp.sdo.mime.impl.MimeElementImpl;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.sdo.DataMediatorException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.internet.HeaderTokenizer;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.ParseException;

public class MimeElementListImpl
extends Vector
implements MimeElementList {
    private static TraceComponent tc = SibTr.register(MimeElementListImpl.class, "SIBMfp", "com.ibm.ws.sib.mfp.CWSIFMessages");
    private static TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.mfp.CWSIFMessages");
    private static final long serialVersionUID = 2824740981983661863L;
    protected static final String TEXT_XML = "text/xml";
    protected static final String MULTIPART_RELATED = "multipart/related";
    protected static final String IMAGE_JPEG = "image/jpeg";
    protected static final String CONTENT_TYPE_HEADER = "Content-Type";
    protected static final String CONTENT_ID_HEADER = "Content-ID";
    protected static final String CONTENT_TRANSFER_HEADER = "Content-Transfer-Encoding";
    protected static final String START_ELEMENT = "start";
    protected static final String BOUNDARY_ELEMENT = "boundary";
    protected static final String US_CODEPAGE = "US-ASCII";
    private String startID = null;
    private String boundaryMarker = null;
    protected MimeMessage msg = null;
    protected MimeMultipart mmp = null;

    public MimeElementListImpl(String string, byte[] byArray, int n, int n2) throws DataMediatorException {
        try {
            if (tc.isEntryEnabled()) {
                SibTr.entry(tc, "MimeElementListImpl", new Object[]{string, byArray, new Integer(n), new Integer(n2)});
            }
            this.constructMessage(string, byArray, n, n2);
            if (tc.isEntryEnabled()) {
                SibTr.exit(tc, "MimeElementListImpl", this);
            }
        }
        catch (DataMediatorException dataMediatorException) {
            FFDCFilter.processException((Throwable)dataMediatorException, (String)"com.ibm.ws.sib.mfp.sdo.mime.impl.MimeElementListImpl.MimeElementListImpl", (String)"120", (Object)this);
            if (tc.isEntryEnabled()) {
                SibTr.exit(tc, "MimeElementListImpl", dataMediatorException);
            }
            throw dataMediatorException;
        }
    }

    public MimeElementListImpl(String string) throws DataMediatorException {
        try {
            if (tc.isEntryEnabled()) {
                SibTr.entry(tc, "MimeElementListImpl", (Object)string);
            }
            this.boundaryMarker = string;
            if (this.boundaryMarker != null) {
                int n;
                String string2 = "Content-Type: multipart/related; boundary=\"" + this.boundaryMarker + "\"\n\n";
                string2 = string2 + "--" + this.boundaryMarker + "\n\n";
                string2 = string2 + "Content-Type: text/plain\n\ndummyElement\n\n";
                string2 = string2 + "--" + this.boundaryMarker + "--";
                byte[] byArray = string2.getBytes(US_CODEPAGE);
                this.constructMessage(null, byArray, 0, byArray.length);
                int n2 = this.size();
                for (n = 0; n < n2; ++n) {
                    this.remove(0);
                }
                n = this.mmp.getCount();
                for (int i = 0; i < n; ++i) {
                    this.mmp.removeBodyPart(0);
                }
                String string3 = this.msg.getHeader(CONTENT_TYPE_HEADER, null);
                this.msg.setContent((Multipart)this.mmp);
                this.msg.setHeader(CONTENT_TYPE_HEADER, string3);
            } else {
                this.msg = new MimeMessage((Session)null);
                this.mmp = new MimeMultipart("related");
                this.msg.setContent((Multipart)this.mmp);
            }
            this.configureElements();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            FFDCFilter.processException((Throwable)unsupportedEncodingException, (String)"com.ibm.ws.sib.mfp.sdo.mime.impl.MimeElementListImpl.MimeElementListImpl", (String)"212", (Object)this);
            DataMediatorException dataMediatorException = new DataMediatorException(unsupportedEncodingException.getMessage());
            dataMediatorException.initCause(unsupportedEncodingException);
        }
        catch (DataMediatorException dataMediatorException) {
            FFDCFilter.processException((Throwable)dataMediatorException, (String)"com.ibm.ws.sib.mfp.sdo.mime.impl.MimeElementListImpl.MimeElementListImpl", (String)"174", (Object)this);
            if (tc.isEntryEnabled()) {
                SibTr.exit(tc, "MimeElementListImpl", dataMediatorException);
            }
            throw dataMediatorException;
        }
        catch (MessagingException messagingException) {
            FFDCFilter.processException((Throwable)messagingException, (String)"com.ibm.ws.sib.mfp.sdo.mime.impl.MimeElementListImpl.MimeElementListImpl", (String)"169", (Object)this);
            DataMediatorException dataMediatorException = new DataMediatorException(messagingException.getMessage());
            dataMediatorException.initCause(messagingException);
            if (tc.isEntryEnabled()) {
                SibTr.exit(tc, "MimeElementListImpl", this);
            }
            throw dataMediatorException;
        }
    }

    private void constructMessage(String string, byte[] byArray, int n, int n2) throws DataMediatorException {
        try {
            if (tc.isEntryEnabled()) {
                SibTr.entry(tc, "constructMessage", new Object[]{string, byArray, new Integer(n), new Integer(n2)});
            }
            if (string != null && !"".equals(string) && !string.toLowerCase().startsWith(CONTENT_TYPE_HEADER.toLowerCase())) {
                String string2 = nls.getFormattedMessage("INVALID_ARGUMENT_CWSIF0381", new Object[]{string, "contentType", "createMimeMessageParser"}, "Invalid Argument to createMimeMessageParser");
                throw new DataMediatorException(string2);
            }
            if (byArray == null) {
                String string3 = nls.getFormattedMessage("INVALID_ARGUMENT_CWSIF0381", new Object[]{"<null>", "data", "createMimeMessageParser"}, "Invalid Argument to createMimeMessageParser");
                throw new DataMediatorException(string3);
            }
            if (string != null) {
                string = string + "\n\n";
            }
            MergedInputStream mergedInputStream = new MergedInputStream(string, new ByteArrayInputStream(byArray, n, n2));
            this.msg = new MimeMessage(null, (InputStream)mergedInputStream);
            this.configureElements();
        }
        catch (DataMediatorException dataMediatorException) {
            FFDCFilter.processException((Throwable)dataMediatorException, (String)"com.ibm.ws.sib.mfp.sdo.mime.impl.MimeElementListImpl.constructMessage", (String)"140", (Object)this);
            if (tc.isEntryEnabled()) {
                SibTr.exit(tc, "constructMessage", dataMediatorException);
            }
            throw dataMediatorException;
        }
        catch (MessagingException messagingException) {
            FFDCFilter.processException((Throwable)messagingException, (String)"com.ibm.ws.sib.mfp.sdo.mime.impl.MimeElementListImpl.constructMessage", (String)"116", (Object)this);
            DataMediatorException dataMediatorException = new DataMediatorException(messagingException.getMessage());
            dataMediatorException.initCause(messagingException);
            if (tc.isEntryEnabled()) {
                SibTr.exit(tc, "constructMessage", dataMediatorException);
            }
            throw dataMediatorException;
        }
    }

    public MimeElement getAttachment(String string) throws DataMediatorException {
        try {
            if (tc.isEntryEnabled()) {
                SibTr.entry(tc, "getAttachment", (Object)string);
            }
            if (string == null || "".equals(string)) {
                String string2 = nls.getFormattedMessage("INVALID_ARGUMENT_CWSIF0381", new Object[]{string, "contentID", "getAttachment"}, "Invalid Argument to getAttachment");
                throw new DataMediatorException(string2);
            }
            MimeElement mimeElement = null;
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                MimeElement mimeElement2 = (MimeElement)iterator.next();
                String string3 = mimeElement2.getContentID();
                if (tc.isDebugEnabled()) {
                    SibTr.debug(tc, "check: " + string3);
                }
                if (!string.equals(string3)) continue;
                mimeElement = mimeElement2;
            }
            if (tc.isEntryEnabled()) {
                SibTr.exit(tc, "getAttachment", mimeElement);
            }
            return mimeElement;
        }
        catch (DataMediatorException dataMediatorException) {
            FFDCFilter.processException((Throwable)dataMediatorException, (String)"com.ibm.ws.sib.mfp.sdo.mime.impl.MimeElementListImpl.getAttachment", (String)"200", (Object)this);
            if (tc.isEntryEnabled()) {
                SibTr.exit(tc, "getAttachment", dataMediatorException);
            }
            throw dataMediatorException;
        }
    }

    public MimeElement getStartPart() throws DataMediatorException {
        try {
            if (tc.isEntryEnabled()) {
                SibTr.entry(tc, "getStartPart");
            }
            MimeElement mimeElement = null;
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                MimeElement mimeElement2 = (MimeElement)iterator.next();
                if (tc.isDebugEnabled()) {
                    SibTr.debug(tc, "check: " + mimeElement2.getContentID());
                }
                if (!mimeElement2.isStart()) continue;
                mimeElement = mimeElement2;
            }
            if (tc.isEntryEnabled()) {
                SibTr.exit(tc, "getStartPart", mimeElement);
            }
            return mimeElement;
        }
        catch (DataMediatorException dataMediatorException) {
            FFDCFilter.processException((Throwable)dataMediatorException, (String)"com.ibm.ws.sib.mfp.sdo.mime.impl.MimeElementListImpl.getStartPart", (String)"245", (Object)this);
            if (tc.isEntryEnabled()) {
                SibTr.exit(tc, "getStartPart", dataMediatorException);
            }
            throw dataMediatorException;
        }
    }

    public byte[] flatten() throws DataMediatorException {
        try {
            if (tc.isEntryEnabled()) {
                SibTr.entry(tc, "flatten");
            }
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "size: " + this.size());
            }
            if (this.size() != 0) {
                try {
                    String[] stringArray;
                    Enumeration enumeration = this.msg.getAllHeaders();
                    Vector<String> vector = new Vector<String>();
                    while (enumeration.hasMoreElements()) {
                        stringArray = (String[])enumeration.nextElement();
                        vector.add(stringArray.getName());
                    }
                    stringArray = new String[vector.size()];
                    for (int i = 0; i < vector.size(); ++i) {
                        stringArray[i] = (String)vector.elementAt(i);
                    }
                    byte[] byArray = null;
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(500);
                    this.msg.writeTo((OutputStream)byteArrayOutputStream, stringArray);
                    byArray = byteArrayOutputStream.toByteArray();
                    if (tc.isDebugEnabled()) {
                        SibTr.bytes(tc, byArray);
                    }
                    if (tc.isEntryEnabled()) {
                        SibTr.exit(tc, "flatten");
                    }
                    return byArray;
                }
                catch (IOException iOException) {
                    FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.sib.mfp.sdo.mime.impl.MimeElementListImpl.flatten", (String)"283", (Object)this);
                    String string = nls.getFormattedMessage("UNABLE_TO_GET_CONTENT_CWSIF0382", new Object[]{"flatten"}, "IOException during flatten");
                    DataMediatorException dataMediatorException = new DataMediatorException(string);
                    dataMediatorException.initCause(iOException);
                    throw dataMediatorException;
                }
            }
            if (tc.isEntryEnabled()) {
                SibTr.exit(tc, "flatten", null);
            }
            return null;
        }
        catch (DataMediatorException dataMediatorException) {
            FFDCFilter.processException((Throwable)dataMediatorException, (String)"com.ibm.ws.sib.mfp.sdo.mime.impl.MimeElementListImpl.flatten", (String)"381", (Object)this);
            if (tc.isEntryEnabled()) {
                SibTr.exit(tc, "flatten", dataMediatorException);
            }
            throw dataMediatorException;
        }
        catch (MessagingException messagingException) {
            FFDCFilter.processException((Throwable)messagingException, (String)"com.ibm.ws.sib.mfp.sdo.mime.impl.MimeElementListImpl.flatten", (String)"299", (Object)this);
            DataMediatorException dataMediatorException = new DataMediatorException(messagingException.getMessage());
            dataMediatorException.initCause(messagingException);
            if (tc.isEntryEnabled()) {
                SibTr.exit(tc, "flatten", dataMediatorException);
            }
            throw dataMediatorException;
        }
    }

    public void setStartPart(MimeElement mimeElement) throws DataMediatorException {
        try {
            if (tc.isEntryEnabled()) {
                SibTr.entry(tc, "setStartPart", mimeElement);
            }
            if (mimeElement == null) {
                this.startID = null;
                String string = this.msg.getContentType();
                string = this.replaceHeaderFieldAttribute(string, START_ELEMENT, null);
                this.msg.setHeader(CONTENT_TYPE_HEADER, string);
            } else {
                this.startID = mimeElement.getContentID();
            }
            this.updateMimeHeaderDetails();
            if (tc.isEntryEnabled()) {
                SibTr.exit(tc, "setStartPart");
            }
        }
        catch (DataMediatorException dataMediatorException) {
            FFDCFilter.processException((Throwable)dataMediatorException, (String)"com.ibm.ws.sib.mfp.sdo.mime.impl.MimeElementListImpl.setStartPart", (String)"438", (Object)this);
            if (tc.isEntryEnabled()) {
                SibTr.exit(tc, "setStartPart", dataMediatorException);
            }
            throw dataMediatorException;
        }
        catch (MessagingException messagingException) {
            FFDCFilter.processException((Throwable)messagingException, (String)"com.ibm.ws.sib.mfp.sdo.mime.impl.MimeElementListImpl.setStartPart", (String)"344", (Object)this);
            DataMediatorException dataMediatorException = new DataMediatorException(messagingException.getMessage());
            dataMediatorException.initCause(messagingException);
            if (tc.isEntryEnabled()) {
                SibTr.exit(tc, "setStartPart", dataMediatorException);
            }
            throw dataMediatorException;
        }
    }

    public String getContentHeader() throws DataMediatorException {
        try {
            if (tc.isEntryEnabled()) {
                SibTr.entry(tc, "getContentHeader");
            }
            String string = this.msg.getHeader(CONTENT_TYPE_HEADER, null);
            string = "Content-Type: " + string;
            if (tc.isEntryEnabled()) {
                SibTr.exit(tc, "getContentHeader", (Object)string);
            }
            return string;
        }
        catch (MessagingException messagingException) {
            FFDCFilter.processException((Throwable)messagingException, (String)"com.ibm.ws.sib.mfp.sdo.mime.impl.MimeElementListImpl.getContentHeader", (String)"423", (Object)this);
            DataMediatorException dataMediatorException = new DataMediatorException(messagingException.getMessage());
            dataMediatorException.initCause(messagingException);
            if (tc.isEntryEnabled()) {
                SibTr.exit(tc, "getContentHeader", dataMediatorException);
            }
            throw dataMediatorException;
        }
    }

    public boolean add(Object object) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "add", object);
        }
        if (object instanceof MimeElementImpl) {
            boolean bl = super.add(object);
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "Added to list: " + bl);
            }
            if (bl) {
                try {
                    this.mmp.addBodyPart((BodyPart)((MimeElementImpl)object).getMimeBodyPart());
                    ((MimeElementImpl)object).setMimeElementList(this);
                }
                catch (MessagingException messagingException) {
                    FFDCFilter.processException((Throwable)messagingException, (String)"com.ibm.ws.sib.mfp.sdo.mime.impl.MimeElementListImpl.add", (String)"377", (Object)this);
                    super.remove(object);
                    bl = false;
                }
            }
            if (tc.isEntryEnabled()) {
                SibTr.exit(tc, "add", new Boolean(bl));
            }
            return bl;
        }
        String string = "null";
        if (object != null) {
            string = object.getClass().getName();
        }
        String string2 = nls.getFormattedMessage("UNSUPPORTED_ELEMENT_TYPE_CWSIF0383", new Object[]{string}, "Non-MimeElement parameter to list.add");
        IllegalArgumentException illegalArgumentException = new IllegalArgumentException(string2);
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "Wrong type of parameter supplied.", illegalArgumentException);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "add", illegalArgumentException);
        }
        throw illegalArgumentException;
    }

    public void add(int n, Object object) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "add(int, Object)", new Object[]{new Integer(n), object});
        }
        if (object instanceof MimeElementImpl) {
            super.add(n, object);
            try {
                this.mmp.addBodyPart((BodyPart)((MimeElementImpl)object).getMimeBodyPart(), n);
                ((MimeElementImpl)object).setMimeElementList(this);
            }
            catch (MessagingException messagingException) {
                FFDCFilter.processException((Throwable)messagingException, (String)"com.ibm.ws.sib.mfp.sdo.mime.impl.MimeElementListImpl.add", (String)"423", (Object)this);
                super.remove(object);
            }
        } else {
            String string = "null";
            if (object != null) {
                string = object.getClass().getName();
            }
            String string2 = nls.getFormattedMessage("UNSUPPORTED_ELEMENT_TYPE_CWSIF0383", new Object[]{string}, "Non-MimeElement parameter to list.add(int, Object)");
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException(string2);
            if (tc.isEntryEnabled()) {
                SibTr.exit(tc, "add(int, Object)", illegalArgumentException);
            }
            throw illegalArgumentException;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "add(int, Object)");
        }
    }

    public void clear() {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "clear");
        }
        for (int i = 0; i < this.size(); ++i) {
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "removing body part " + i);
            }
            try {
                this.mmp.removeBodyPart(0);
                continue;
            }
            catch (MessagingException messagingException) {
                FFDCFilter.processException((Throwable)messagingException, (String)"com.ibm.ws.sib.mfp.sdo.mime.impl.MimeElementListImpl.clear", (String)"456", (Object)this);
            }
        }
        super.clear();
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "clear");
        }
    }

    public synchronized Object remove(int n) {
        Object var2_2 = null;
        try {
            if (tc.isEntryEnabled()) {
                SibTr.entry(tc, "remove(int)", new Integer(n));
            }
            this.mmp.removeBodyPart(n);
            var2_2 = super.remove(n);
        }
        catch (MessagingException messagingException) {
            FFDCFilter.processException((Throwable)messagingException, (String)"com.ibm.ws.sib.mfp.sdo.mime.impl.MimeElementListImpl.remove", (String)"487", (Object)this);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "remove(int)", var2_2);
        }
        return var2_2;
    }

    public boolean remove(Object object) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "remove(Object)", object);
        }
        boolean bl = false;
        if (object instanceof MimeElementImpl) {
            try {
                this.mmp.removeBodyPart((BodyPart)((MimeElementImpl)object).getMimeBodyPart());
                bl = super.remove(object);
            }
            catch (MessagingException messagingException) {
                FFDCFilter.processException((Throwable)messagingException, (String)"com.ibm.ws.sib.mfp.sdo.mime.impl.MimeElementListImpl.remove", (String)"520", (Object)this);
            }
        } else if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "Parameter was not a MimeElementImpl object.");
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "remove(Object)", new Boolean(bl));
        }
        return bl;
    }

    public void configureElements() throws DataMediatorException {
        try {
            if (tc.isEntryEnabled()) {
                SibTr.entry(tc, "configureElements");
            }
            this.mmp = this.getMultiPartFromMessage();
            int n = this.mmp.getCount();
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "numElements");
            }
            for (int i = 0; i < n; ++i) {
                if (tc.isDebugEnabled()) {
                    SibTr.debug(tc, "Adding element " + i);
                }
                MimeBodyPart mimeBodyPart = (MimeBodyPart)this.mmp.getBodyPart(i);
                this.add(new MimeElementImpl(this, mimeBodyPart));
            }
            this.updateMimeHeaderDetails();
            if (tc.isEntryEnabled()) {
                SibTr.exit(tc, "configureElements");
            }
        }
        catch (DataMediatorException dataMediatorException) {
            FFDCFilter.processException((Throwable)dataMediatorException, (String)"com.ibm.ws.sib.mfp.sdo.mime.impl.MimeElementListImpl.configureElements", (String)"192", (Object)this);
            if (tc.isEntryEnabled()) {
                SibTr.exit(tc, "configureElements", dataMediatorException);
            }
            throw dataMediatorException;
        }
        catch (MessagingException messagingException) {
            FFDCFilter.processException((Throwable)messagingException, (String)"com.ibm.ws.sib.mfp.sdo.mime.impl.MimeElementListImpl.configureElements", (String)"745", (Object)this);
            DataMediatorException dataMediatorException = new DataMediatorException(messagingException.getMessage());
            dataMediatorException.initCause(messagingException);
            if (tc.isEntryEnabled()) {
                SibTr.exit(tc, "configureElements", dataMediatorException);
            }
            throw dataMediatorException;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected MimeMultipart getMultiPartFromMessage() throws DataMediatorException {
        MimeMultipart mimeMultipart;
        try {
            try {
                if (tc.isEntryEnabled()) {
                    SibTr.entry(tc, "getMultiPartFromMessage");
                }
                if (tc.isDebugEnabled()) {
                    SibTr.debug(tc, "initial mmp: " + this.mmp);
                }
                if (this.mmp == null) {
                    if (!this.msg.isMimeType(MULTIPART_RELATED)) {
                        String string = nls.getFormattedMessage("NON_MULTIPART_MESSAGE_CWSIF0384", new Object[]{this.msg.getContentType()}, "non-multipart/related message");
                        DataMediatorException dataMediatorException = new DataMediatorException(string);
                        throw dataMediatorException;
                    }
                    try {
                        this.mmp = (MimeMultipart)this.msg.getContent();
                    }
                    catch (IOException iOException) {
                        FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.sib.mfp.sdo.mime.impl.MimeElementListImpl.getMultiPartFromMessage", (String)"609", (Object)this);
                        String string = nls.getFormattedMessage("UNABLE_TO_GET_CONTENT_CWSIF0382", new Object[]{"getMultiPartFromMessage"}, "IOException during getMultiPartFromMessage");
                        DataMediatorException dataMediatorException = new DataMediatorException(string);
                        dataMediatorException.initCause(iOException);
                        throw dataMediatorException;
                    }
                }
                mimeMultipart = this.mmp;
                Object var5_10 = null;
            }
            catch (DataMediatorException dataMediatorException) {
                FFDCFilter.processException((Throwable)dataMediatorException, (String)"com.ibm.ws.sib.mfp.sdo.mime.impl.MimeElementListImpl.getMultiPartFromMessage", (String)"815", (Object)this);
                throw dataMediatorException;
            }
            catch (MessagingException messagingException) {
                FFDCFilter.processException((Throwable)messagingException, (String)"com.ibm.ws.sib.mfp.sdo.mime.impl.MimeElementListImpl.getMultiPartFromMessage", (String)"815", (Object)this);
                DataMediatorException dataMediatorException = new DataMediatorException(messagingException.getMessage());
                dataMediatorException.initCause(messagingException);
                throw dataMediatorException;
            }
        }
        catch (Throwable throwable) {
            Object var5_11 = null;
            if (!tc.isEntryEnabled()) throw throwable;
            SibTr.exit(tc, "getMultiPartFromMessage", this.mmp);
            throw throwable;
        }
        if (!tc.isEntryEnabled()) return mimeMultipart;
        SibTr.exit(tc, "getMultiPartFromMessage", this.mmp);
        return mimeMultipart;
    }

    protected Object decodeFromInputStream(String string, InputStream inputStream) throws IOException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "decodeFromInputStream", new Object[]{string, inputStream});
        }
        byte[] byArray = new byte[inputStream.available()];
        inputStream.read(byArray);
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "decodeFromInputStream", byArray);
        }
        return byArray;
    }

    protected boolean isFirstPart(MimeElementImpl mimeElementImpl) throws DataMediatorException {
        boolean bl;
        try {
            if (tc.isEntryEnabled()) {
                SibTr.entry(tc, "isFirstPart", mimeElementImpl);
            }
            boolean bl2 = false;
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "startID: " + this.startID);
            }
            if (this.startID == null) {
                if (mimeElementImpl == this.get(0)) {
                    bl2 = true;
                }
            } else {
                String string = mimeElementImpl.getContentID();
                if (string != null) {
                    string = MimeElementListImpl.stripChevrons(string);
                }
                if (this.startID.equals(string)) {
                    bl2 = true;
                }
            }
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "returns: " + bl2);
            }
            bl = bl2;
            Object var5_6 = null;
        }
        catch (DataMediatorException dataMediatorException) {
            try {
                FFDCFilter.processException((Throwable)dataMediatorException, (String)"com.ibm.ws.sib.mfp.sdo.mime.impl.MimeElementListImpl.isFirstPart", (String)"909", (Object)this);
                throw dataMediatorException;
            }
            catch (Throwable throwable) {
                block13: {
                    Object var5_7 = null;
                    if (!tc.isEntryEnabled()) break block13;
                    SibTr.exit(tc, "isFirstPart");
                }
                throw throwable;
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "isFirstPart");
        }
        return bl;
    }

    private void updateMimeHeaderDetails() throws DataMediatorException {
        try {
            String[] stringArray;
            if (tc.isEntryEnabled()) {
                SibTr.entry(tc, "updateMimeHeaderDetails");
            }
            if ((stringArray = this.msg.getHeader(CONTENT_TYPE_HEADER)) == null) {
                stringArray = new String[]{MULTIPART_RELATED};
            } else if (stringArray.length != 1) {
                String string = nls.getFormattedMessage("CONTENT_HEADER_CARDINALITY_CWSIF0385", new Object[]{new Integer(stringArray.length)}, "multiple content-type headers");
                DataMediatorException dataMediatorException = new DataMediatorException(string);
                if (tc.isDebugEnabled()) {
                    SibTr.debug(tc, "Too many Content-Type headers: " + stringArray.length);
                }
                if (tc.isEntryEnabled()) {
                    SibTr.exit(tc, "updateMimeHeaderDetails", dataMediatorException);
                }
                throw dataMediatorException;
            }
            String string = stringArray[0];
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "startID: " + this.startID);
            }
            if (this.startID == null) {
                this.startID = this.parseHeaderFieldAttribute(string, START_ELEMENT);
                this.startID = MimeElementListImpl.stripChevrons(this.startID);
            } else {
                string = this.replaceHeaderFieldAttribute(string, START_ELEMENT, "<" + this.startID + ">");
                this.msg.setHeader(CONTENT_TYPE_HEADER, string);
            }
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "boundaryMarker: " + this.boundaryMarker);
            }
            if (this.boundaryMarker == null) {
                this.boundaryMarker = this.parseHeaderFieldAttribute(string, BOUNDARY_ELEMENT);
            } else {
                string = this.replaceHeaderFieldAttribute(string, BOUNDARY_ELEMENT, this.boundaryMarker);
                this.msg.setHeader(CONTENT_TYPE_HEADER, string);
            }
            this.msg.saveChanges();
            if (tc.isEntryEnabled()) {
                SibTr.exit(tc, "updateMimeHeaderDetails");
            }
        }
        catch (MessagingException messagingException) {
            FFDCFilter.processException((Throwable)messagingException, (String)"com.ibm.ws.sib.mfp.sdo.mime.impl.MimeElementListImpl.updateMimeHeaderDetails", (String)"771", (Object)this);
            DataMediatorException dataMediatorException = new DataMediatorException(messagingException.getMessage());
            dataMediatorException.initCause(messagingException);
            if (tc.isEntryEnabled()) {
                SibTr.exit(tc, "updateMimeHeaderDetails", dataMediatorException);
            }
            throw dataMediatorException;
        }
    }

    protected String parseHeaderFieldAttribute(String string, String string2) throws ParseException {
        try {
            if (tc.isEntryEnabled()) {
                SibTr.entry(tc, "parseHeaderFieldAttribute", new Object[]{string, string2});
            }
            String string3 = null;
            if (string.indexOf(string2) != -1) {
                HeaderTokenizer headerTokenizer = new HeaderTokenizer(string);
                HeaderTokenizer.Token token = null;
                while ((token = headerTokenizer.next()).getType() != -4) {
                    if (tc.isDebugEnabled()) {
                        SibTr.debug(tc, "token: " + token.getValue());
                    }
                    if (!(string2 + "=").equals(token.getValue())) continue;
                    token = headerTokenizer.next();
                    string3 = token.getValue();
                    break;
                }
            }
            if (tc.isEntryEnabled()) {
                SibTr.exit(tc, "parseHeaderFieldAttribute", string3);
            }
            return string3;
        }
        catch (ParseException parseException) {
            FFDCFilter.processException((Throwable)parseException, (String)"com.ibm.ws.sib.mfp.sdo.mime.impl.MimeElementListImpl.parseHeaderFieldAttribute", (String)"832", (Object)this);
            if (tc.isEntryEnabled()) {
                SibTr.exit(tc, "parseHeaderFieldAttribute", (Object)parseException);
            }
            throw parseException;
        }
    }

    protected String replaceHeaderFieldAttribute(String string, String string2, String string3) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "replaceHeaderFieldAttribute", new Object[]{string, string2, string3});
        }
        if (string.indexOf(string2) != -1) {
            int n = string.indexOf(string2);
            int n2 = string.indexOf(" ", n);
            String string4 = string.substring(0, n);
            if (n2 != -1) {
                string4 = string4 + string.substring(n2 + 1);
            }
            string = string4;
        }
        if (string3 != null) {
            if (!string.trim().endsWith(";")) {
                string = string + "; ";
            }
            string = string + string2 + "=\"" + string3 + "\"";
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "replaceHeaderFieldAttribute", (Object)string);
        }
        return string;
    }

    protected static String stripChevrons(String string) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "stripChevrons", (Object)string);
        }
        if (string != null && string.startsWith("<") && string.endsWith(">")) {
            string = string.substring(1, string.length() - 1);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "stripChevrons", (Object)string);
        }
        return string;
    }

    public boolean addAll(Collection collection) {
        throw new UnsupportedOperationException();
    }

    public boolean addAll(int n, Collection collection) {
        throw new UnsupportedOperationException();
    }

    public boolean removeAll(Collection collection) {
        throw new UnsupportedOperationException();
    }

    public Object set(int n, Object object) {
        throw new UnsupportedOperationException();
    }

    public boolean retainAll(Collection collection) {
        throw new UnsupportedOperationException();
    }

    public List subList(int n, int n2) {
        throw new UnsupportedOperationException();
    }

    public MimeElementList copy() {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "copy");
        }
        MimeElementList mimeElementList = null;
        try {
            MimeElement mimeElement = this.getStartPart();
            mimeElementList = MimeFactory.createEmptyMimeMessageParser(this.boundaryMarker);
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                MimeElement mimeElement2 = (MimeElement)iterator.next();
                MimeElement mimeElement3 = mimeElement2.copy();
                mimeElementList.add(mimeElement3);
                if (null == mimeElement || !mimeElement2.equals(mimeElement)) continue;
                mimeElementList.setStartPart(mimeElement3);
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.sib.mfp.sdo.mime.impl.MimeElementListImpl.copy", (String)"1312", (Object)this);
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "Failed to copy MimeElementList: " + exception);
            }
            String string = nls.getFormattedMessage("ELEMENT_COPY_ERROR_CWSIF0373", new Object[]{exception}, "A problem was encountered during the copying of the MimeElementList");
            throw new SIMessageParseException(string, exception);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "copy");
        }
        return mimeElementList;
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "Source info: @(#)SIB/ws/code/sib.mfp.sdo.impl/src/com/ibm/ws/sib/mfp/sdo/mime/impl/MimeElementListImpl.java, SIB.mfp, WAS602.SIB, o0610.11 1.16");
        }
    }
}

