/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.mfp.sdo.mediators;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.mfp.sdo.resource.ResourceCache;
import com.ibm.ws.sib.mfp.sdo.resource.ResourceCacheFactory;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.sdo.DataMediator;
import com.ibm.wsspi.sib.sdo.DataMediatorException;
import commonj.sdo.DataGraph;
import commonj.sdo.DataObject;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.ExtendedMetaData;

class BlobDataMediator
implements DataMediator {
    private static TraceComponent tc = SibTr.register(BlobDataMediator.class, "SIBMfp", "com.ibm.ws.sib.mfp.CWSIFMessages");
    private static TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.mfp.CWSIFMessages");
    private String format;

    BlobDataMediator(String string) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "<init>", (Object)string);
        }
        this.format = string;
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "<init>");
        }
    }

    public DataGraph createDataGraph() {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "createDataGraph", (Object)this.format);
        }
        ResourceCacheFactory resourceCacheFactory = ResourceCacheFactory.getInstance();
        ResourceCache resourceCache = resourceCacheFactory.getSdoRepositoryCache();
        DataGraph dataGraph = resourceCache.createDataGraph(null);
        DataObject dataObject = dataGraph.createRootObject("com.ibm.ws.sib.mfp/blob", "");
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "createDataGraph");
        }
        return dataGraph;
    }

    public DataObject read(byte[] byArray, int n, int n2) throws DataMediatorException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "read");
        }
        DataObject dataObject = null;
        try {
            byte[] byArray2 = new byte[n2];
            System.arraycopy(byArray, n, byArray2, 0, n2);
            ResourceCacheFactory resourceCacheFactory = ResourceCacheFactory.getInstance();
            ResourceCache resourceCache = resourceCacheFactory.getSdoRepositoryCache();
            dataObject = resourceCache.createDataObject("com.ibm.ws.sib.mfp/blob", "", null);
            dataObject.setBytes("blob", byArray2);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.sib.mfp.sdo.mediators.BlobDataMediator.read", (String)"111", (Object)this);
            String string = nls.getFormattedMessage("BLOB_PARSE_FAILURE_CWSIF0251", new Object[]{exception}, "Blob data mediator read failure.");
            throw new DataMediatorException(string, exception);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "read");
        }
        return dataObject;
    }

    public int getLength(DataObject dataObject, DataMediator.State state) throws DataMediatorException {
        byte[] byArray;
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "getLength");
        }
        try {
            if (state != null && state.value != null) {
                byArray = (byte[])state.value;
            } else {
                byArray = this.getBlob(dataObject);
                if (state != null) {
                    state.value = byArray;
                }
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.sib.mfp.sdo.mediators.BlobDataMediator.getLength", (String)"138", (Object)this);
            String string = nls.getFormattedMessage("BLOB_LENGTH_FAILURE_CWSIF0252", new Object[]{exception}, "Blob data mediator getLength failure.");
            throw new DataMediatorException(string, exception);
        }
        int n = 0;
        if (byArray != null) {
            n = byArray.length;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "getLength", new Integer(n));
        }
        return n;
    }

    public int write(DataObject dataObject, byte[] byArray, int n, int n2, DataMediator.State state) throws DataMediatorException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "write");
        }
        int n3 = 0;
        try {
            byte[] byArray2 = state != null && state.value != null ? (byte[])state.value : this.getBlob(dataObject);
            if (byArray2 != null) {
                n3 = byArray2.length;
            }
            System.arraycopy(byArray2, 0, byArray, n, n3);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.sib.mfp.sdo.mediators.BlobDataMediator.write", (String)"168", (Object)this);
            String string = nls.getFormattedMessage("BLOB_WRITE_FAILURE_CWSIF0253", new Object[]{exception}, "Blob data mediator write failure.");
            throw new DataMediatorException(string, exception);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "write", new Integer(n3));
        }
        return n3;
    }

    public byte[] getBlob(DataObject dataObject) throws DataMediatorException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "getBlob");
        }
        ExtendedMetaData extendedMetaData = ExtendedMetaData.INSTANCE;
        EClass eClass = ((EObject)dataObject).eClass();
        String string = extendedMetaData.getNamespace(eClass.getEPackage());
        String string2 = extendedMetaData.getName((EClassifier)eClass);
        if (!"com.ibm.ws.sib.mfp/blob".equals(string) || !"".equals(string2)) {
            String string3 = nls.getFormattedMessage("BLOB_MODEL_FAILURE_CWSIF0254", new Object[]{string2, string}, "Incorrect message model.");
            throw new DataMediatorException(string3);
        }
        byte[] byArray = dataObject.getBytes("blob");
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "getBlob");
        }
        return byArray;
    }

    public DataObject readTransform(byte[] byArray, String string) throws DataMediatorException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "readTransform");
        }
        DataObject dataObject = this.read(byArray, 0, byArray.length);
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "readTransform");
        }
        return dataObject;
    }

    public byte[] writeTransform(DataObject dataObject, String string) throws DataMediatorException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "writeTransform");
        }
        DataMediator.State state = new DataMediator.State();
        int n = this.getLength(dataObject, state);
        byte[] byArray = new byte[n];
        this.write(dataObject, byArray, 0, n, state);
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "writeTransform");
        }
        return byArray;
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "Source info: @(#)SIB/ws/code/sib.mfp.sdo.impl/src/com/ibm/ws/sib/mfp/sdo/mediators/BlobDataMediator.java, SIB.mfp, WAS602.SIB, o0610.11 1.21");
        }
    }
}

