/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.mfp.sdo.jms;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.mfp.JmsBodyType;
import com.ibm.ws.sib.mfp.jmf.JMFRegistry;
import com.ibm.ws.sib.mfp.jmf.JMFSchema;
import com.ibm.ws.sib.mfp.jmf.JMFType;
import com.ibm.ws.sib.mfp.sdo.jms.JmsInstanceFactory;
import com.ibm.ws.sib.mfp.sdo.resource.ResourceCache;
import com.ibm.ws.sib.mfp.sdo.resource.ResourceCacheFactory;
import com.ibm.ws.sib.mfp.sdo.resource.ResourceException;
import com.ibm.ws.sib.mfp.sdo.resource.XSDMetaData;
import com.ibm.ws.sib.mfp.sdo.tools.EcoreConverter;
import com.ibm.ws.sib.mfp.sdo.util.Privileged;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sdo.config.repository.SDORepository;
import com.ibm.wsspi.sib.sdo.SystemSDORepository;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EPackage;

public class JmsModelGenerator {
    private static TraceComponent tc = SibTr.register(JmsModelGenerator.class, "SIBMfp", "com.ibm.ws.sib.mfp.CWSIFMessages");
    private static EPackage jmsPackage;
    private static EClass textModel;
    private static EClass bytesModel;
    private static EClass objectModel;
    private static EClass streamModel;
    private static EClass mapModel;
    private static JMFSchema textSchema;
    private static JMFSchema bytesSchema;
    private static JMFSchema objectSchema;
    private static JMFSchema streamSchema;
    private static JMFSchema mapSchema;
    static final String MFP_SCHEMA_URI = "com.ibm.ws.sib.mfp/schema";
    static final String MFP_SCHEMA_PKG = "com.ibm.ws.sib.mfp.schema";
    static final String MFP_JMS_PREFIX = "jms";
    public static String JMS_DOMAIN;
    public static String JMS_FORMAT;
    public static String JMS_FORMAT_BYTES;
    public static String JMS_FORMAT_TEXT;
    public static String JMS_FORMAT_OBJECT;
    public static String JMS_FORMAT_STREAM;
    public static String JMS_FORMAT_MAP;
    public static final String JMS_PAYLOAD_SCHEMA_NAMESPACE = "http://www.ibm.com/xmlns/prod/websphere/messaging/jms";
    protected static EDataType longEDatatype;
    protected static EDataType intEDatatype;
    protected static EDataType shortEDatatype;
    protected static EDataType byteEDatatype;
    protected static EDataType booleanEDatatype;
    protected static EDataType floatEDatatype;
    protected static EDataType doubleEDatatype;
    protected static EDataType stringEDatatype;
    protected static EDataType byteArrayEDatatype;
    protected static EDataType characterEDatatype;
    protected static Map allowedSimpleTypes;

    public static void init() {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "init");
        }
        Class clazz = JmsModelGenerator.class;
        URL uRL = Privileged.getResource(clazz, "schema/JmsBodyModels.xsd");
        SystemSDORepository systemSDORepository = SDORepository.instance();
        systemSDORepository.registerEphemeralResource(uRL, MFP_SCHEMA_URI);
        try {
            ResourceCacheFactory resourceCacheFactory = ResourceCacheFactory.getInstance();
            ResourceCache resourceCache = resourceCacheFactory.getSdoRepositoryCache();
            jmsPackage = resourceCache.getEcoreModel(MFP_SCHEMA_URI, MFP_SCHEMA_URI);
            JmsInstanceFactory.init(jmsPackage);
            jmsPackage.setEFactoryInstance((EFactory)new JmsInstanceFactory());
        }
        catch (ResourceException resourceException) {
            FFDCFilter.processException((Throwable)resourceException, (String)"com.ibm.ws.sib.mfp.sdo.jms.JmsModelGenerator.init", (String)"139");
            throw new RuntimeException(resourceException);
        }
        mapModel = null;
        streamModel = null;
        objectModel = null;
        bytesModel = null;
        textModel = null;
        mapSchema = null;
        streamSchema = null;
        objectSchema = null;
        bytesSchema = null;
        textSchema = null;
        JmsModelGenerator.initPayloadModel();
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "init");
        }
    }

    private static void initPayloadModel() {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "initPayloadModel");
        }
        URL uRL = Privileged.getResource(JmsModelGenerator.class, "schema/JmsPayloadModels.xsd");
        SystemSDORepository systemSDORepository = SDORepository.instance();
        systemSDORepository.registerEphemeralResource(uRL, JMS_PAYLOAD_SCHEMA_NAMESPACE);
        ResourceCacheFactory resourceCacheFactory = ResourceCacheFactory.getInstance();
        ResourceCache resourceCache = resourceCacheFactory.getSdoRepositoryCache();
        XSDMetaData xSDMetaData = new XSDMetaData(resourceCache);
        allowedSimpleTypes = new HashMap();
        try {
            longEDatatype = (EDataType)xSDMetaData.getGlobalType("long", "http://www.w3.org/2001/XMLSchema", null);
            allowedSimpleTypes.put("long", longEDatatype);
            intEDatatype = (EDataType)xSDMetaData.getGlobalType("int", "http://www.w3.org/2001/XMLSchema", null);
            allowedSimpleTypes.put("int", intEDatatype);
            shortEDatatype = (EDataType)xSDMetaData.getGlobalType("short", "http://www.w3.org/2001/XMLSchema", null);
            allowedSimpleTypes.put("short", shortEDatatype);
            byteEDatatype = (EDataType)xSDMetaData.getGlobalType("byte", "http://www.w3.org/2001/XMLSchema", null);
            allowedSimpleTypes.put("byte", byteEDatatype);
            booleanEDatatype = (EDataType)xSDMetaData.getGlobalType("boolean", "http://www.w3.org/2001/XMLSchema", null);
            allowedSimpleTypes.put("boolean", booleanEDatatype);
            floatEDatatype = (EDataType)xSDMetaData.getGlobalType("float", "http://www.w3.org/2001/XMLSchema", null);
            allowedSimpleTypes.put("float", floatEDatatype);
            doubleEDatatype = (EDataType)xSDMetaData.getGlobalType("double", "http://www.w3.org/2001/XMLSchema", null);
            allowedSimpleTypes.put("double", doubleEDatatype);
            stringEDatatype = (EDataType)xSDMetaData.getGlobalType("string", "http://www.w3.org/2001/XMLSchema", null);
            allowedSimpleTypes.put("string", stringEDatatype);
            byteArrayEDatatype = (EDataType)xSDMetaData.getGlobalType("hexBinary", "http://www.w3.org/2001/XMLSchema", null);
            allowedSimpleTypes.put("hexBinary", byteArrayEDatatype);
            characterEDatatype = (EDataType)xSDMetaData.getGlobalType("character", JMS_PAYLOAD_SCHEMA_NAMESPACE, JMS_PAYLOAD_SCHEMA_NAMESPACE);
            allowedSimpleTypes.put("character", characterEDatatype);
        }
        catch (ResourceException resourceException) {
            FFDCFilter.processException((Throwable)resourceException, (String)"com.ibm.ws.sib.mfp.sdo.jms.JmsModelGenerator.initPayloadModel", (String)"208");
            throw new RuntimeException(resourceException);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "initPayloadModel");
        }
    }

    public static EPackage getJmsPackage() {
        return jmsPackage;
    }

    public static EClass getEcoreModel(JmsBodyType jmsBodyType) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "getEcoreModel", jmsBodyType);
        }
        EClass eClass = null;
        switch (jmsBodyType.toInt()) {
            case 1: {
                eClass = JmsModelGenerator.getBytesModel();
                break;
            }
            case 5: {
                eClass = JmsModelGenerator.getTextModel();
                break;
            }
            case 3: {
                eClass = JmsModelGenerator.getObjectModel();
                break;
            }
            case 4: {
                eClass = JmsModelGenerator.getStreamModel();
                break;
            }
            case 2: {
                eClass = JmsModelGenerator.getMapModel();
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "getEcoreModel");
        }
        return eClass;
    }

    public static JmsBodyType getBodyType(String string) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "getBodyType", (Object)string);
        }
        JmsBodyType jmsBodyType = null;
        if (string.equals(JMS_FORMAT_BYTES)) {
            jmsBodyType = JmsBodyType.BYTES;
        } else if (string.equals(JMS_FORMAT_TEXT)) {
            jmsBodyType = JmsBodyType.TEXT;
        } else if (string.equals(JMS_FORMAT_OBJECT)) {
            jmsBodyType = JmsBodyType.OBJECT;
        } else if (string.equals(JMS_FORMAT_STREAM)) {
            jmsBodyType = JmsBodyType.STREAM;
        } else if (string.equals(JMS_FORMAT_MAP)) {
            jmsBodyType = JmsBodyType.MAP;
        } else if (string.equals(JMS_FORMAT)) {
            jmsBodyType = JmsBodyType.NULL;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "getBodyType");
        }
        return jmsBodyType;
    }

    public static JmsBodyType getBodyType(int n) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "getBodyType", (Object)Integer.toString(n));
        }
        JmsBodyType jmsBodyType = null;
        switch (n) {
            case 0: {
                jmsBodyType = JmsBodyType.BYTES;
                break;
            }
            case 1: {
                jmsBodyType = JmsBodyType.TEXT;
                break;
            }
            case 2: {
                jmsBodyType = JmsBodyType.OBJECT;
                break;
            }
            case 3: {
                jmsBodyType = JmsBodyType.STREAM;
                break;
            }
            case 4: {
                jmsBodyType = JmsBodyType.MAP;
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "getBodyType");
        }
        return jmsBodyType;
    }

    public static String getJmsFormat(EClass eClass) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "getJmsFormat");
        }
        String string = null;
        if (eClass == textModel) {
            string = JMS_FORMAT_TEXT;
        } else if (eClass == bytesModel) {
            string = JMS_FORMAT_BYTES;
        } else if (eClass == objectModel) {
            string = JMS_FORMAT_OBJECT;
        } else if (eClass == streamModel) {
            string = JMS_FORMAT_STREAM;
        } else if (eClass == mapModel) {
            string = JMS_FORMAT_MAP;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "getJmsFormat");
        }
        return string;
    }

    public static synchronized EClass getBytesModel() {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "getBytesModel");
        }
        if (bytesModel == null) {
            EPackage ePackage = JmsModelGenerator.getJmsPackage();
            EClass eClass = (EClass)ePackage.getEClassifier("JmsBytesBody");
            bytesSchema = JmsModelGenerator.convertAndCheckJmfSchema(eClass);
            bytesModel = eClass;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "getBytesModel");
        }
        return bytesModel;
    }

    public static synchronized EClass getTextModel() {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "getTextModel");
        }
        if (textModel == null) {
            EPackage ePackage = JmsModelGenerator.getJmsPackage();
            EClass eClass = (EClass)ePackage.getEClassifier("JmsTextBody");
            textSchema = JmsModelGenerator.convertAndCheckJmfSchema(eClass);
            textModel = eClass;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "getTextModel");
        }
        return textModel;
    }

    public static synchronized EClass getObjectModel() {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "getObjectModel");
        }
        if (objectModel == null) {
            EPackage ePackage = JmsModelGenerator.getJmsPackage();
            EClass eClass = (EClass)ePackage.getEClassifier("JmsObjectBody");
            objectSchema = JmsModelGenerator.convertAndCheckJmfSchema(eClass);
            objectModel = eClass;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "getObjectModel");
        }
        return objectModel;
    }

    public static synchronized EClass getStreamModel() {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "getStreamModel");
        }
        if (streamModel == null) {
            EPackage ePackage = JmsModelGenerator.getJmsPackage();
            EClass eClass = (EClass)ePackage.getEClassifier("JmsStreamBody");
            streamSchema = JmsModelGenerator.convertAndCheckJmfSchema(eClass);
            streamModel = eClass;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "getStreamModel");
        }
        return streamModel;
    }

    public static synchronized EClass getMapModel() {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "getMapModel");
        }
        if (mapModel == null) {
            EPackage ePackage = JmsModelGenerator.getJmsPackage();
            EClass eClass = (EClass)ePackage.getEClassifier("JmsMapBody");
            mapSchema = JmsModelGenerator.convertAndCheckJmfSchema(eClass);
            mapModel = eClass;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "getMapModel");
        }
        return mapModel;
    }

    public static JMFSchema getBytesSchema() {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "getBytesSchema");
        }
        if (bytesSchema == null) {
            JmsModelGenerator.getBytesModel();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "getBytesSchema");
        }
        return bytesSchema;
    }

    public static JMFSchema getTextSchema() {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "getTextSchema");
        }
        if (textSchema == null) {
            JmsModelGenerator.getTextModel();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "getTextSchema");
        }
        return textSchema;
    }

    public static JMFSchema getObjectSchema() {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "getObjectSchema");
        }
        if (objectSchema == null) {
            JmsModelGenerator.getObjectModel();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "getObjectSchema");
        }
        return objectSchema;
    }

    public static JMFSchema getStreamSchema() {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "getStreamSchema");
        }
        if (streamSchema == null) {
            JmsModelGenerator.getStreamModel();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "getStreamSchema");
        }
        return streamSchema;
    }

    public static JMFSchema getMapSchema() {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "getMapSchema");
        }
        if (mapSchema == null) {
            JmsModelGenerator.getMapModel();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "getMapSchema");
        }
        return mapSchema;
    }

    private static JMFSchema convertAndCheckJmfSchema(EClass eClass) {
        JMFType jMFType = EcoreConverter.convert(eClass, false, false);
        JMFSchema jMFSchema = JMFRegistry.instance.createJMFSchema(jMFType);
        try {
            String string = eClass.getEPackage().getName() + "." + eClass.getName() + "Access";
            Class<?> clazz = Class.forName(string);
            JMFSchema jMFSchema2 = (JMFSchema)clazz.getField("schema").get(null);
            if (!jMFSchema.equals(jMFSchema2)) {
                if (tc.isDebugEnabled()) {
                    SibTr.debug(tc, "Incorrect schema generated: " + jMFSchema.getJMFType());
                }
                throw new Exception("JMFSchema mismatch for: " + eClass.getName());
            }
            JMFRegistry.instance.register(jMFSchema);
            jMFSchema = JMFRegistry.instance.retrieve(eClass);
            if (jMFSchema == null) {
                if (tc.isDebugEnabled()) {
                    SibTr.debug(tc, "Unable to find updated schema: " + eClass.getName());
                }
                throw new Exception("JMFSchema not found for: " + eClass.getName());
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.sib.mfp.sdo.jms.JmsModelGenerator.convertAndCheckJmfSchema", (String)"525");
        }
        return jMFSchema;
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "@(#)SIB/ws/code/sib.mfp.sdo.impl/src/com/ibm/ws/sib/mfp/sdo/jms/JmsModelGenerator.java, SIB.mfp, WAS602.SIB, o0610.11 1.21");
        }
        JmsModelGenerator.init();
        JMS_DOMAIN = "JMS";
        JMS_FORMAT = JMS_DOMAIN + ":";
        JMS_FORMAT_BYTES = JMS_FORMAT + "bytes";
        JMS_FORMAT_TEXT = JMS_FORMAT + "text";
        JMS_FORMAT_OBJECT = JMS_FORMAT + "object";
        JMS_FORMAT_STREAM = JMS_FORMAT + "stream";
        JMS_FORMAT_MAP = JMS_FORMAT + "map";
    }
}

