/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.mfp.sdo.jms;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.mfp.JmsBodyType;
import com.ibm.ws.sib.mfp.MfpConstants;
import com.ibm.ws.sib.mfp.jmf.JMFException;
import com.ibm.ws.sib.mfp.jmf.JMFNativePart;
import com.ibm.ws.sib.mfp.sdo.jms.JmsDataMediator;
import com.ibm.ws.sib.mfp.sdo.jms.JmsInstanceFactory;
import com.ibm.ws.sib.mfp.sdo.jms.JmsModelGenerator;
import com.ibm.ws.sib.mfp.sdo.jms.JmsStreamHandler;
import com.ibm.ws.sib.mfp.sdo.resource.ResourceCache;
import com.ibm.ws.sib.mfp.sdo.resource.ResourceCacheFactory;
import com.ibm.ws.sib.mfp.sdo.resource.ResourceNotFoundException;
import com.ibm.ws.sib.mfp.sdo.sdooverjmf.SDOoverJMF;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.sdo.DataMediator;
import com.ibm.wsspi.sib.sdo.DataMediatorException;
import commonj.sdo.DataGraph;
import commonj.sdo.DataObject;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Iterator;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.util.ExtendedMetaData;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.DefaultHandler;

class JmsDataMediatorImpl
implements JmsDataMediator,
DataMediator {
    private static TraceComponent tc = SibTr.register(JmsDataMediatorImpl.class, "SIBMfp", "com.ibm.ws.sib.mfp.CWSIFMessages");
    private static TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.mfp.CWSIFMessages");
    private String format;

    public JmsDataMediatorImpl(String string) throws DataMediatorException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "JmsDataMediatorImpl", (Object)string);
        }
        if (JmsModelGenerator.getBodyType(string) == null) {
            ResourceNotFoundException resourceNotFoundException = new ResourceNotFoundException("Unknown type: " + string, null);
            throw new DataMediatorException("Incorrect JMS format type: " + string, resourceNotFoundException);
        }
        this.format = string;
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "JmsDataMediatorImpl");
        }
    }

    public DataObject parse(JMFNativePart jMFNativePart, JmsBodyType jmsBodyType) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "parse");
        }
        EClass eClass = JmsModelGenerator.getEcoreModel(jmsBodyType);
        DataObject dataObject = (DataObject)SDOoverJMF.getDataObject(jMFNativePart);
        if (jmsBodyType == JmsBodyType.STREAM) {
            EObject eObject = (EObject)dataObject.getDataObject("data");
            eObject.eAdapters().add((Object)new JmsInstanceFactory.StreamValuePoliceman());
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "parse");
        }
        return dataObject;
    }

    public JMFNativePart write(DataObject dataObject) throws DataMediatorException {
        JMFNativePart jMFNativePart;
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "write");
        }
        try {
            jMFNativePart = SDOoverJMF.getNativePart((EObject)dataObject);
            if (jMFNativePart == null) {
                jMFNativePart = SDOoverJMF.transcribe((EObject)dataObject, false);
            }
        }
        catch (JMFException jMFException) {
            FFDCFilter.processException((Throwable)jMFException, (String)"com.ibm.ws.sib.mfp.sdo.jms.JmsDataMediatorImpl.write", (String)"149");
            if (tc.isEntryEnabled()) {
                SibTr.exit(tc, "write", (Object)"DataMediatorException");
            }
            throw new DataMediatorException("Cannot write message data.", jMFException);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "write");
        }
        return jMFNativePart;
    }

    public void verify(DataObject dataObject, String string) throws DataMediatorException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "verify");
        }
        EPackage ePackage = JmsModelGenerator.getJmsPackage();
        EClass eClass = ((EObject)dataObject).eClass();
        if (!ePackage.getEClassifiers().contains((Object)eClass)) {
            if (tc.isEntryEnabled()) {
                SibTr.exit(tc, "verify", (Object)"DataMediatorException");
            }
            throw new DataMediatorException("DataObject does not have JMS Ecore model: " + eClass.getName());
        }
        String string2 = JmsModelGenerator.getJmsFormat(eClass);
        if (string2 == null || !string.startsWith(string2)) {
            if (tc.isEntryEnabled()) {
                SibTr.exit(tc, "verify", (Object)"DataMediatorException");
            }
            throw new DataMediatorException("Format string is invalid for a JMS message: " + string);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "verify");
        }
    }

    public DataGraph createDataGraph() throws DataMediatorException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "createDataGraph");
        }
        DataGraph dataGraph = this.createDataGraph(this.format);
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "createDataGraph");
        }
        return dataGraph;
    }

    private DataGraph createDataGraph(String string) throws DataMediatorException {
        JmsBodyType jmsBodyType;
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "createDataGraph", (Object)string);
        }
        if ((jmsBodyType = JmsModelGenerator.getBodyType(string)) == null) {
            if (tc.isEntryEnabled()) {
                SibTr.exit(tc, "createDataGraph", (Object)"DataMediatorException");
            }
            throw new DataMediatorException("Incorrect JMS message type: " + string);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "createDataGraph");
        }
        return this.createDataGraph(jmsBodyType);
    }

    private DataGraph createDataGraph(JmsBodyType jmsBodyType) throws DataMediatorException {
        EClass eClass;
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "createDataGraph", jmsBodyType);
        }
        if ((eClass = JmsModelGenerator.getEcoreModel(jmsBodyType)) == null) {
            if (tc.isEntryEnabled()) {
                SibTr.exit(tc, "createDataGraph", (Object)"DataMediatorException");
            }
            throw new DataMediatorException("Incorrect JMS body type: " + jmsBodyType);
        }
        ResourceCacheFactory resourceCacheFactory = ResourceCacheFactory.getInstance();
        ResourceCache resourceCache = resourceCacheFactory.getSdoRepositoryCache();
        String string = ExtendedMetaData.INSTANCE.getNamespace(eClass.getEPackage());
        DataGraph dataGraph = resourceCache.createDataGraph(null);
        DataObject dataObject = dataGraph.createRootObject(string, eClass.getName());
        dataObject.createDataObject("data");
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "createDataGraph", dataGraph);
        }
        return dataGraph;
    }

    public DataObject read(byte[] byArray, int n, int n2) throws DataMediatorException {
        throw new UnsupportedOperationException();
    }

    public int write(DataObject dataObject, byte[] byArray, int n, int n2, DataMediator.State state) throws DataMediatorException {
        throw new UnsupportedOperationException();
    }

    public int getLength(DataObject dataObject, DataMediator.State state) throws DataMediatorException {
        throw new UnsupportedOperationException();
    }

    public DataObject readTransform(byte[] byArray, String string) throws DataMediatorException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "readTransform", (Object)string);
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "Trying to convert to " + this.format);
        }
        JmsBodyType jmsBodyType = JmsModelGenerator.getBodyType(this.format);
        DataObject dataObject = null;
        if (jmsBodyType != JmsBodyType.NULL) {
            DataGraph dataGraph = this.createDataGraph(jmsBodyType);
            dataObject = dataGraph.getRootObject();
            switch (jmsBodyType.toInt()) {
                case 1: {
                    dataObject.setBytes("data/value", byArray);
                    break;
                }
                case 5: {
                    try {
                        dataObject.setString("data/value", new String(byArray, "UTF8"));
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        FFDCFilter.processException((Throwable)unsupportedEncodingException, (String)"com.ibm.ws.sib.mfp.sdo.jms.JmsDataMediatorImpl.readTransform", (String)"283", (Object)this);
                    }
                    break;
                }
                case 3: {
                    dataObject.setBytes("data/value", byArray);
                    break;
                }
                case 4: {
                    this.readStream(byArray, dataGraph);
                    break;
                }
                case 2: {
                    if (tc.isEntryEnabled()) {
                        SibTr.exit(tc, "readTransform", (Object)"UnsupportedOperationException");
                    }
                    throw new UnsupportedOperationException("JMS:Map messages are not supported");
                }
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "readTransform");
        }
        return dataObject;
    }

    private void readStream(byte[] byArray, DataGraph dataGraph) throws DataMediatorException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "readStream", new Object[]{byArray, dataGraph});
        }
        try {
            JmsStreamHandler jmsStreamHandler = new JmsStreamHandler(dataGraph);
            SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
            sAXParserFactory.setNamespaceAware(true);
            SAXParser sAXParser = sAXParserFactory.newSAXParser();
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            sAXParser.parse((InputStream)byteArrayInputStream, (DefaultHandler)jmsStreamHandler);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            FFDCFilter.processException((Throwable)parserConfigurationException, (String)"com.ibm.ws.sib.mfp.sdo.jms.JmsDataMediatorImpl.readStream", (String)"329", (Object)this);
            if (tc.isEntryEnabled()) {
                SibTr.exit(tc, "readStream", (Object)"DataMediatorException");
            }
            throw new DataMediatorException("Error in configuring parser while attempting to parse a JMS stream message payload", parserConfigurationException);
        }
        catch (SAXException sAXException) {
            FFDCFilter.processException((Throwable)sAXException, (String)"com.ibm.ws.sib.mfp.sdo.jms.JmsDataMediatorImpl.readStream", (String)"333", (Object[])new Object[]{MfpConstants.DM_BUFFER, byArray, new Integer(0), new Integer(byArray.length)});
            if (tc.isEntryEnabled()) {
                SibTr.exit(tc, "readStream", (Object)"DataMediatorException");
            }
            throw new DataMediatorException("Error while attempting to parse a JMS stream message payload", sAXException);
        }
        catch (IOException iOException) {
            FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.sib.mfp.sdo.jms.JmsDataMediatorImpl.readStream", (String)"341", (Object)this);
            if (tc.isEntryEnabled()) {
                SibTr.exit(tc, "readStream", (Object)"DataMediatorException");
            }
            throw new DataMediatorException("An input/output error occurred while attempting to parse a JMS stream message payload", iOException);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "readStream");
        }
    }

    public byte[] writeTransform(DataObject dataObject, String string) throws DataMediatorException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "writeTransform", (Object)string);
        }
        JmsBodyType jmsBodyType = JmsModelGenerator.getBodyType(this.format);
        byte[] byArray = null;
        switch (jmsBodyType.toInt()) {
            case 0: {
                byArray = null;
                break;
            }
            case 3: {
                byte[] byArray2 = dataObject.getBytes("data/value");
                if (byArray2 == null) {
                    byArray = null;
                    break;
                }
                byArray = new byte[byArray2.length];
                System.arraycopy(byArray2, 0, byArray, 0, byArray2.length);
                break;
            }
            case 1: {
                byte[] byArray3 = dataObject.getBytes("data/value");
                if (byArray3 == null) {
                    byArray = null;
                    break;
                }
                byArray = new byte[byArray3.length];
                System.arraycopy(byArray3, 0, byArray, 0, byArray3.length);
                break;
            }
            case 5: {
                try {
                    String string2 = dataObject.getString("data/value");
                    if (string2 == null) {
                        byArray = null;
                        break;
                    }
                    byArray = string2.getBytes("UTF8");
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    FFDCFilter.processException((Throwable)unsupportedEncodingException, (String)"com.ibm.ws.sib.mfp.sdo.jms.JmsDataMediatorImpl.writeTransform", (String)"406", (Object)this);
                }
                break;
            }
            case 4: {
                byArray = this.writeStream(dataObject);
                break;
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "writeTransform");
        }
        return byArray;
    }

    private byte[] writeStream(DataObject dataObject) throws DataMediatorException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "writeStream", dataObject);
        }
        byte[] byArray = null;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        OutputFormat outputFormat = new OutputFormat();
        XMLSerializer xMLSerializer = new XMLSerializer((OutputStream)byteArrayOutputStream, outputFormat);
        ContentHandler contentHandler = null;
        try {
            contentHandler = xMLSerializer.asContentHandler();
        }
        catch (IOException iOException) {
            FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.sib.mfp.sdo.jms.JmsDataMediatorImpl.writeStream", (String)"443", (Object)this);
            if (tc.isEntryEnabled()) {
                SibTr.exit(tc, "writeStream", (Object)"DataMediatorException");
            }
            throw new DataMediatorException("An input/output error occurred while attempting to write a JMS stream message payload", iOException);
        }
        AttributesImpl attributesImpl = new AttributesImpl();
        attributesImpl.addAttribute(this.getXsiNSURI(), "type", "xsi:type", "CDATA", "");
        AttributesImpl attributesImpl2 = new AttributesImpl();
        AttributesImpl attributesImpl3 = null;
        EFactory eFactory = JmsModelGenerator.booleanEDatatype.getEPackage().getEFactoryInstance();
        EFactory eFactory2 = JmsModelGenerator.characterEDatatype.getEPackage().getEFactoryInstance();
        try {
            contentHandler.startDocument();
            contentHandler.startPrefixMapping("xs", this.getXsdNSURI());
            contentHandler.startPrefixMapping("xsi", this.getXsiNSURI());
            contentHandler.startPrefixMapping("wm", this.getStreamNSURI());
            DataObject dataObject2 = dataObject.getDataObject("data");
            contentHandler.startElement(this.getStreamNSURI(), "data", "wm:data", attributesImpl2);
            List list = dataObject2.getList("value");
            Iterator iterator = list.iterator();
            EFactory eFactory3 = null;
            AttributesImpl attributesImpl4 = null;
            EDataType eDataType = null;
            String string = this.getStreamNSURI();
            String string2 = "value";
            String string3 = "wm:value";
            while (iterator.hasNext()) {
                attributesImpl4 = attributesImpl;
                Object e = iterator.next();
                char[] cArray = null;
                if (e == null) {
                    if (attributesImpl3 == null) {
                        attributesImpl3 = new AttributesImpl();
                        attributesImpl3.addAttribute(this.getXsiNSURI(), "type", "xsi:nil", "CDATA", "true");
                    }
                    attributesImpl4 = attributesImpl3;
                    eFactory3 = eFactory;
                    eDataType = JmsModelGenerator.stringEDatatype;
                } else if (e instanceof Boolean) {
                    attributesImpl4.setValue(0, "xs:boolean");
                    cArray = eFactory.convertToString(JmsModelGenerator.booleanEDatatype, e).toCharArray();
                } else if (e instanceof Byte) {
                    attributesImpl4.setValue(0, "xs:byte");
                    cArray = eFactory.convertToString(JmsModelGenerator.byteEDatatype, e).toCharArray();
                } else if (e instanceof Short) {
                    attributesImpl4.setValue(0, "xs:short");
                    cArray = eFactory.convertToString(JmsModelGenerator.shortEDatatype, e).toCharArray();
                } else if (e instanceof Character) {
                    attributesImpl4.setValue(0, "wm:character");
                    cArray = new char[]{((Character)e).charValue()};
                } else if (e instanceof Integer) {
                    attributesImpl4.setValue(0, "xs:int");
                    cArray = eFactory.convertToString(JmsModelGenerator.intEDatatype, e).toCharArray();
                } else if (e instanceof Long) {
                    attributesImpl4.setValue(0, "xs:long");
                    cArray = eFactory.convertToString(JmsModelGenerator.longEDatatype, e).toCharArray();
                } else if (e instanceof Float) {
                    attributesImpl4.setValue(0, "xs:float");
                    cArray = eFactory.convertToString(JmsModelGenerator.floatEDatatype, e).toCharArray();
                } else if (e instanceof Double) {
                    attributesImpl4.setValue(0, "xs:double");
                    cArray = eFactory.convertToString(JmsModelGenerator.doubleEDatatype, e).toCharArray();
                } else if (e instanceof String) {
                    attributesImpl4 = attributesImpl2;
                    cArray = eFactory.convertToString(JmsModelGenerator.stringEDatatype, e).toCharArray();
                } else if (e instanceof byte[]) {
                    attributesImpl4.setValue(0, "xs:hexBinary");
                    cArray = eFactory.convertToString(JmsModelGenerator.byteArrayEDatatype, e).toCharArray();
                } else {
                    DataMediatorException dataMediatorException = new DataMediatorException("Unexpected element type in JMS stream message");
                    FFDCFilter.processException((Throwable)dataMediatorException, (String)"com.ibm.ws.sib.mfp.sdo.jms.JmsDataMediatorImpl.writeStream", (String)"567", (Object)this);
                    if (tc.isEntryEnabled()) {
                        SibTr.exit(tc, "writeStream", (Object)"DataMediatorException");
                    }
                    throw dataMediatorException;
                }
                contentHandler.startElement(string, string2, string3, attributesImpl4);
                if (cArray != null) {
                    contentHandler.characters(cArray, 0, cArray.length);
                }
                contentHandler.endElement(string, string2, string3);
            }
            contentHandler.endElement(this.getStreamNSURI(), "data", "wm:data");
            contentHandler.endPrefixMapping("wm");
            contentHandler.endPrefixMapping("xsi");
            contentHandler.endPrefixMapping("xs");
            xMLSerializer.endDocument();
        }
        catch (SAXException sAXException) {
            FFDCFilter.processException((Throwable)sAXException, (String)"com.ibm.ws.sib.mfp.sdo.jms.JmsDataMediatorImpl.writeStream", (String)"589", (Object)this);
            if (tc.isEntryEnabled()) {
                SibTr.exit(tc, "writeStream", (Object)"DataMediatorException");
            }
            throw new DataMediatorException("Error in writing JMS stream message payload to bytes", sAXException);
        }
        byArray = byteArrayOutputStream.toByteArray();
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "writeStream", byArray);
        }
        return byArray;
    }

    private String getXsiNSURI() {
        return "http://www.w3.org/2001/XMLSchema-instance";
    }

    private String getXsdNSURI() {
        return "http://www.w3.org/2001/XMLSchema";
    }

    private String getStreamNSURI() {
        return "http://www.ibm.com/xmlns/prod/websphere/messaging/jms";
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "Source info: @(#)SIB/ws/code/sib.mfp.sdo.impl/src/com/ibm/ws/sib/mfp/sdo/jms/JmsDataMediatorImpl.java, SIB.mfp, WAS602.SIB, o0610.11 1.5");
        }
    }
}

