/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.mfp.sdo.bean;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.mfp.sdo.bean.BeanDataMediatorImpl;
import com.ibm.ws.sib.mfp.sdo.bean.BeanFormatDescriptor;
import com.ibm.ws.sib.mfp.sdo.bean.TypeMap;
import com.ibm.ws.sib.mfp.sdo.resource.ResourceCache;
import com.ibm.ws.sib.mfp.sdo.resource.ResourceException;
import com.ibm.ws.sib.mfp.sdo.resource.WSDLMetaData;
import com.ibm.ws.sib.mfp.sdo.resource.XSDMetaData;
import com.ibm.ws.sib.mfp.sdo.soap.SOAPDataMediatorImpl;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.sdo.DataMediatorException;
import commonj.sdo.DataObject;
import commonj.sdo.Property;
import commonj.sdo.Type;
import java.util.Iterator;
import java.util.Map;
import javax.wsdl.Binding;
import javax.wsdl.BindingOperation;
import javax.wsdl.Fault;
import javax.wsdl.Message;
import javax.wsdl.Operation;
import javax.xml.namespace.QName;
import javax.xml.rpc.soap.SOAPFaultException;
import javax.xml.soap.Detail;
import org.apache.xerces.dom.DOMImplementationImpl;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.sdo.EProperty;
import org.eclipse.emf.ecore.sdo.EType;
import org.eclipse.emf.ecore.sdo.util.SDOUtil;
import org.w3c.dom.Node;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSSerializer;

public class FaultParser {
    private XSDMetaData xsdMetaData;
    private BeanDataMediatorImpl beanDataMediator;
    private SOAPDataMediatorImpl soapDataMediator;
    private static TraceComponent tc = SibTr.register(FaultParser.class, "SIBMfp", "com.ibm.ws.sib.mfp.CWSIFMessages");
    private static TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.mfp.CWSIFMessages");

    FaultParser(BeanDataMediatorImpl beanDataMediatorImpl, SOAPDataMediatorImpl sOAPDataMediatorImpl) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "<init>");
        }
        this.xsdMetaData = beanDataMediatorImpl.getXSDMetaData();
        this.beanDataMediator = beanDataMediatorImpl;
        this.soapDataMediator = sOAPDataMediatorImpl;
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "<init>");
        }
    }

    DataObject parseFault(Exception exception, BeanFormatDescriptor beanFormatDescriptor, TypeMap typeMap) throws DataMediatorException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "parseFault", new Object[]{exception, beanFormatDescriptor, typeMap});
        }
        DataObject dataObject = null;
        try {
            dataObject = exception instanceof SOAPFaultException ? this.parseSOAPFault((SOAPFaultException)exception, beanFormatDescriptor) : this.parseServiceSpecificFault(exception, beanFormatDescriptor, typeMap);
        }
        catch (Exception exception2) {
            FFDCFilter.processException((Throwable)exception2, (String)"com.ibm.ws.sib.mfp.sdo.bean.FaultParser.parseFault", (String)"127", (Object)this);
        }
        if (dataObject == null) {
            dataObject = this.parseBasicFault(exception, beanFormatDescriptor);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "parseFault", dataObject);
        }
        return dataObject;
    }

    private DataObject parseServiceSpecificFault(Exception exception, BeanFormatDescriptor beanFormatDescriptor, TypeMap typeMap) throws DataMediatorException {
        WSDLMetaData wSDLMetaData;
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "parseServiceSpecificFault", new Object[]{exception, beanFormatDescriptor, typeMap});
        }
        DataObject dataObject = null;
        EProperty eProperty = null;
        EProperty eProperty2 = null;
        QName qName = null;
        try {
            wSDLMetaData = this.beanDataMediator.getWSDLMetaData();
            Binding binding = wSDLMetaData.getBinding(beanFormatDescriptor);
            Iterator iterator = binding.getBindingOperations().iterator();
            while (eProperty == null && iterator.hasNext()) {
                BindingOperation bindingOperation = (BindingOperation)iterator.next();
                Operation operation = bindingOperation.getOperation();
                if (!bindingOperation.getName().equals(beanFormatDescriptor.getOperationName())) continue;
                Map map = bindingOperation.getBindingFaults();
                Iterator iterator2 = map.keySet().iterator();
                while (eProperty == null && iterator2.hasNext()) {
                    EType eType;
                    Class clazz;
                    String string = (String)iterator2.next();
                    Fault fault = operation.getFault(string);
                    Message message = fault.getMessage();
                    QName qName2 = message.getQName();
                    ResourceCache resourceCache = this.beanDataMediator.getResourceCache();
                    EPackage ePackage = resourceCache.getEcoreModel(qName2.getNamespaceURI(), beanFormatDescriptor.getLocation());
                    EClass eClass = wSDLMetaData.getMessage(ePackage, qName2.getLocalPart());
                    EStructuralFeature eStructuralFeature = (EStructuralFeature)eClass.getEAllStructuralFeatures().get(0);
                    if (eStructuralFeature.getEType() instanceof EClass) {
                        eClass = (EClass)eStructuralFeature.getEType();
                        eProperty2 = SDOUtil.adaptProperty((EStructuralFeature)eStructuralFeature);
                    }
                    if ((clazz = typeMap.mapModelType(eType = SDOUtil.adaptType((EClassifier)eClass))) != null && clazz.isInstance(exception)) {
                        beanFormatDescriptor.setMessageName(string);
                        EStructuralFeature eStructuralFeature2 = wSDLMetaData.getBodyFeature(beanFormatDescriptor);
                        eProperty = SDOUtil.adaptProperty((EStructuralFeature)eStructuralFeature2);
                        qName = qName2;
                        continue;
                    }
                    eProperty2 = null;
                }
            }
        }
        catch (ResourceException resourceException) {
            FFDCFilter.processException((Throwable)resourceException, (String)"com.ibm.ws.sib.mfp.sdo.bean.FaultParser.parseServiceSpecificFault", (String)"214", (Object)this);
        }
        if (eProperty != null) {
            dataObject = this.createFaultBody(beanFormatDescriptor);
            wSDLMetaData = dataObject.getDataObject("info");
            wSDLMetaData = wSDLMetaData.getDataObject("body");
            wSDLMetaData.set("faultcode", qName);
            wSDLMetaData.setString("faultstring", exception.getClass().getName());
            wSDLMetaData = wSDLMetaData.createDataObject("detail");
            wSDLMetaData = wSDLMetaData.createDataObject((Property)eProperty);
            if (eProperty2 != null) {
                wSDLMetaData = wSDLMetaData.createDataObject((Property)eProperty2);
            }
            this.beanDataMediator.parseComplexType(exception, (DataObject)wSDLMetaData);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "parseServiceSpecificFault", dataObject);
        }
        return dataObject;
    }

    private DataObject parseBasicFault(Exception exception, BeanFormatDescriptor beanFormatDescriptor) throws DataMediatorException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "parseBasicFault", new Object[]{exception, beanFormatDescriptor});
        }
        QName qName = new QName(beanFormatDescriptor.getServiceNamespace(), beanFormatDescriptor.getServiceName());
        DataObject dataObject = this.createFaultBody(beanFormatDescriptor);
        DataObject dataObject2 = dataObject.getDataObject("info");
        dataObject2 = dataObject2.getDataObject("body");
        dataObject2.set("faultcode", (Object)qName);
        dataObject2.setString("faultstring", exception.getClass().getName());
        if (dataObject.isSet("info/operationName")) {
            dataObject.unset("info/operationName");
        }
        if (dataObject.isSet("info/messageName")) {
            dataObject.unset("info/messageName");
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "parseBasicFault", dataObject);
        }
        return dataObject;
    }

    private DataObject parseSOAPFault(SOAPFaultException sOAPFaultException, BeanFormatDescriptor beanFormatDescriptor) throws DataMediatorException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "parseSOAPFault");
        }
        DataObject dataObject = this.createFaultBody(beanFormatDescriptor);
        DataObject dataObject2 = dataObject.getDataObject("info");
        DataObject dataObject3 = dataObject2.getDataObject("body");
        dataObject3.set("faultcode", (Object)sOAPFaultException.getFaultCode());
        dataObject3.set("faultstring", (Object)sOAPFaultException.getFaultString());
        dataObject3.set("faultactor", (Object)sOAPFaultException.getFaultActor());
        Detail detail = sOAPFaultException.getDetail();
        if (null != detail) {
            dataObject3.createDataObject("detail");
            this.instantiateDetailDO(dataObject2, detail);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "parseSOAPFault");
        }
        return dataObject;
    }

    private void instantiateDetailDO(DataObject dataObject, Detail detail) throws DataMediatorException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "instantiateDetailDO");
        }
        byte[] byArray = null;
        try {
            DOMImplementationImpl dOMImplementationImpl = new DOMImplementationImpl();
            DOMImplementationLS dOMImplementationLS = (DOMImplementationLS)dOMImplementationImpl;
            LSSerializer lSSerializer = dOMImplementationLS.createLSSerializer();
            byArray = lSSerializer.writeToString((Node)detail).getBytes("UTF-8");
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.sib.mfp.sdo.bean.FaultParser.instantiateDetailDO", (String)"334", (Object)this, (Object[])new Object[]{dataObject.getString("operationName"), dataObject.getString("messageName")});
            String string = nls.getFormattedMessage("FAULT_PARSE_FAILURE_CWSIF0337", new Object[]{dataObject.getString("operationName"), dataObject.getString("messageName")}, "Fault parse failure");
            throw new DataMediatorException(string, exception);
        }
        this.soapDataMediator.readDetail(dataObject, byArray, 0, byArray.length);
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "instantiateDetailDO");
        }
    }

    private DataObject createFaultBody(BeanFormatDescriptor beanFormatDescriptor) throws DataMediatorException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "createFaultBody");
        }
        String string = "SOAPFaultBody";
        EClassifier eClassifier = null;
        DataObject dataObject = null;
        DataObject dataObject2 = null;
        try {
            dataObject = this.beanDataMediator.getResourceCache().createDataObject("http://www.ibm.com/ns/2004/05/webservices/messagemodel", "", null);
            dataObject2 = dataObject.createDataObject("Info");
            if (beanFormatDescriptor.getMessageName() != null) {
                dataObject2.setString("operationName", beanFormatDescriptor.getOperationName());
                dataObject2.setString("messageName", beanFormatDescriptor.getMessageName());
            }
            dataObject2.setString("messageType", beanFormatDescriptor.getMessageType());
            eClassifier = this.xsdMetaData.getGlobalType(string, "http://www.ibm.com/ns/2004/05/webservices/messagemodel", "http://www.ibm.com/ns/2004/05/webservices/messagemodel");
            EType eType = SDOUtil.adaptType((EClassifier)eClassifier);
            Property property = dataObject2.getType().getProperty("body");
            dataObject2.createDataObject(property, (Type)eType);
        }
        catch (ResourceException resourceException) {
            FFDCFilter.processException((Throwable)resourceException, (String)"com.ibm.ws.sib.mfp.sdo.bean.FaultParser.createFaultBody", (String)"404", (Object)this, (Object[])new Object[]{string, "http://www.ibm.com/ns/2004/05/webservices/messagemodel", "http://www.ibm.com/ns/2004/05/webservices/messagemodel"});
            String string2 = nls.getFormattedMessage("FAULT_PARSE_FAILURE_CWSIF0330", new Object[]{string, "http://www.ibm.com/ns/2004/05/webservices/messagemodel", "http://www.ibm.com/ns/2004/05/webservices/messagemodel"}, "Fault parse failure");
            throw new DataMediatorException(string2, resourceException);
        }
        return dataObject;
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "Source info: @(#)SIB/ws/code/sib.mfp.sdo.impl/src/com/ibm/ws/sib/mfp/sdo/bean/FaultParser.java, SIB.mfp, WAS602.SIB, o0610.11 1.11");
        }
    }
}

