/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.mfp.mqinterop.impl;

import com.ibm.ws.sib.mfp.mqinterop.impl.BufferedField;
import com.ibm.ws.sib.mfp.mqinterop.impl.BufferedHeader;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;

class ShortField
extends BufferedField {
    final short defaultValue;

    public ShortField(String string, int n) {
        this(string, n, 0);
    }

    public ShortField(String string, int n, short s) {
        super(string, n);
        this.defaultValue = s;
    }

    public int getFieldType() {
        return 2;
    }

    public int read(BufferedHeader bufferedHeader, DataInput dataInput, int n, int n2) throws IOException {
        this.setShortValue(bufferedHeader, dataInput.readShort());
        return this.size(bufferedHeader);
    }

    public int write(BufferedHeader bufferedHeader, DataOutput dataOutput, int n, int n2) throws IOException {
        if (this.isReversed(n)) {
            dataOutput.writeShort(ShortField.reverse(this.getShortValue(bufferedHeader)));
        } else {
            dataOutput.writeShort(this.getShortValue(bufferedHeader));
        }
        return this.size(bufferedHeader);
    }

    public int size(BufferedHeader bufferedHeader) {
        return 2;
    }

    public Object getValue(BufferedHeader bufferedHeader) {
        return new Short(this.getShortValue(bufferedHeader));
    }

    public void setValue(BufferedHeader bufferedHeader, Object object) {
        this.setShortValue(bufferedHeader, object != null ? (Short)object : this.defaultValue);
    }

    public short getShortValue(BufferedHeader bufferedHeader) {
        ByteBuffer byteBuffer = this.getBuffer(bufferedHeader);
        return byteBuffer == null ? this.defaultValue : byteBuffer.getShort();
    }

    public void setShortValue(BufferedHeader bufferedHeader, short s) {
        this.getBuffer(bufferedHeader, this.size(bufferedHeader)).putShort(s);
    }

    public int getIntValue(BufferedHeader bufferedHeader) {
        return this.getShortValue(bufferedHeader);
    }

    public String toString() {
        return super.toString() + " (default: " + this.defaultValue + ')';
    }
}

