/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.mfp.mqinterop.impl;

import com.ibm.ws.sib.mfp.mqinterop.impl.BufferedHeader;
import com.ibm.ws.sib.mfp.mqinterop.impl.LongField;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

class LongFieldFixedByteOrder
extends LongField {
    final ByteOrder order;

    public LongFieldFixedByteOrder(String string, int n) {
        this(string, n, 0L, ByteOrder.nativeOrder());
    }

    public LongFieldFixedByteOrder(String string, int n, long l, ByteOrder byteOrder) {
        super(string, n, l);
        this.order = byteOrder;
    }

    public int write(BufferedHeader bufferedHeader, DataOutput dataOutput, int n, int n2) throws IOException {
        if (this.order == ByteOrder.LITTLE_ENDIAN) {
            dataOutput.writeLong(LongFieldFixedByteOrder.reverse(this.getLongValue(bufferedHeader)));
        } else {
            dataOutput.writeLong(this.getLongValue(bufferedHeader));
        }
        return this.size(bufferedHeader);
    }

    public long getLongValue(BufferedHeader bufferedHeader) {
        ByteBuffer byteBuffer = this.getBuffer(bufferedHeader);
        if (byteBuffer == null) {
            return this.defaultValue;
        }
        if (this.order == byteBuffer.order()) {
            return byteBuffer.getLong();
        }
        return LongFieldFixedByteOrder.reverse(byteBuffer.getLong());
    }

    public void setLongValue(BufferedHeader bufferedHeader, long l) {
        ByteBuffer byteBuffer = this.getBuffer(bufferedHeader, this.size(bufferedHeader));
        if (this.order == byteBuffer.order()) {
            byteBuffer.putLong(l);
        } else {
            byteBuffer.putLong(LongFieldFixedByteOrder.reverse(l));
        }
    }
}

