/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.mfp.mqinterop.impl;

import com.ibm.ws.sib.mfp.mqinterop.impl.BufferedHeader;
import com.ibm.ws.sib.mfp.mqinterop.impl.IntField;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

class IntFieldFixedByteOrder
extends IntField {
    final ByteOrder order;

    public IntFieldFixedByteOrder(String string, int n) {
        this(string, n, 0, ByteOrder.nativeOrder());
    }

    public IntFieldFixedByteOrder(String string, int n, int n2, ByteOrder byteOrder) {
        super(string, n, n2);
        this.order = byteOrder;
    }

    public int write(BufferedHeader bufferedHeader, DataOutput dataOutput, int n, int n2) throws IOException {
        if (this.order == ByteOrder.LITTLE_ENDIAN) {
            dataOutput.writeInt(IntFieldFixedByteOrder.reverse(this.getIntValue(bufferedHeader)));
        } else {
            dataOutput.writeInt(this.getIntValue(bufferedHeader));
        }
        return 4;
    }

    public int getIntValue(BufferedHeader bufferedHeader) {
        ByteBuffer byteBuffer = this.getBuffer(bufferedHeader);
        if (byteBuffer == null) {
            return this.defaultValue;
        }
        if (this.order != byteBuffer.order()) {
            return IntFieldFixedByteOrder.reverse(byteBuffer.getInt());
        }
        return byteBuffer.getInt();
    }

    public void setIntValue(BufferedHeader bufferedHeader, int n) {
        ByteBuffer byteBuffer = this.getBuffer(bufferedHeader, this.size(bufferedHeader));
        if (this.order != byteBuffer.order()) {
            byteBuffer.putInt(IntFieldFixedByteOrder.reverse(n));
        } else {
            byteBuffer.putInt(n);
        }
    }
}

