/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.mfp.mqinterop.impl;

import com.ibm.ws.sib.mfp.mqinterop.impl.BufferedField;
import com.ibm.ws.sib.mfp.mqinterop.impl.BufferedHeader;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.AbstractList;
import java.util.List;

class IntArrayField
extends BufferedField {
    final int length;

    public IntArrayField(String string, int n, int n2) {
        super(string, n);
        this.length = n2;
    }

    public int getFieldType() {
        return 20;
    }

    public int read(BufferedHeader bufferedHeader, DataInput dataInput, int n, int n2) throws IOException {
        return this.size(bufferedHeader);
    }

    public int write(BufferedHeader bufferedHeader, DataOutput dataOutput, int n, int n2) throws IOException {
        int[] nArray = this.getIntArrayValue(bufferedHeader);
        for (int i = 0; i < nArray.length; ++i) {
            dataOutput.writeInt(nArray[i]);
        }
        return nArray.length * 4;
    }

    public int size(BufferedHeader bufferedHeader) {
        if (bufferedHeader == null) {
            return 0;
        }
        return this.length(bufferedHeader) * 4;
    }

    public int[] getIntArrayValue(BufferedHeader bufferedHeader) {
        int[] nArray = new int[this.length(bufferedHeader)];
        ByteBuffer byteBuffer = this.getBuffer(bufferedHeader);
        if (byteBuffer != null) {
            for (int i = 0; i < nArray.length; ++i) {
                nArray[i] = byteBuffer.getInt();
            }
        }
        return nArray;
    }

    public void setIntArrayValue(BufferedHeader bufferedHeader, int[] nArray) {
        int[] nArray2 = nArray;
        ByteBuffer byteBuffer = this.getBuffer(bufferedHeader, nArray2.length * 4);
        for (int i = 0; i < nArray2.length; ++i) {
            byteBuffer.putInt(nArray2[i]);
        }
        if (this.length <= 0) {
            bufferedHeader.setIntValue(-this.length, nArray2.length);
        }
    }

    public Object getValue(BufferedHeader bufferedHeader) {
        final int[] nArray = this.getIntArrayValue(bufferedHeader);
        return new AbstractList(){

            public Object get(int n) {
                return new Integer(nArray[n]);
            }

            public int size() {
                return nArray.length;
            }
        };
    }

    public void setValue(BufferedHeader bufferedHeader, Object object) {
        Integer[] integerArray = ((List)object).toArray(new Integer[0]);
        ByteBuffer byteBuffer = this.getBuffer(bufferedHeader, integerArray.length * 4);
        for (int i = 0; i < integerArray.length; ++i) {
            byteBuffer.putInt(integerArray[i]);
        }
        if (this.length <= 0) {
            bufferedHeader.setIntValue(-this.length, integerArray.length);
        }
    }

    public int getIntValue(BufferedHeader bufferedHeader) {
        return 0;
    }

    public boolean isVariableSize() {
        return this.length <= 0;
    }

    int length(BufferedHeader bufferedHeader) {
        if (bufferedHeader == null) {
            return 0;
        }
        if (this.length > 0) {
            return this.length;
        }
        return bufferedHeader.getIntValue(-this.length);
    }
}

