/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.mfp.mqinterop.impl;

import com.ibm.ws.sib.mfp.mqinterop.impl.BufferedField;
import com.ibm.ws.sib.mfp.mqinterop.impl.BufferedHeader;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;

class ByteArrayField
extends BufferedField {
    final int length;
    final int alignment;
    final int overhead;

    public ByteArrayField(String string, int n) {
        this(string, n, 0);
    }

    public ByteArrayField(String string, int n, int n2) {
        this(string, n, n2, 1, 0);
    }

    public ByteArrayField(String string, int n, int n2, int n3, int n4) {
        super(string, n);
        this.length = n2;
        this.alignment = n3;
        this.overhead = n4;
    }

    public int getFieldType() {
        return 11;
    }

    public int read(BufferedHeader bufferedHeader, DataInput dataInput, int n, int n2) throws IOException {
        byte[] byArray = new byte[this.size(bufferedHeader)];
        dataInput.readFully(byArray);
        this.setBytesValue(bufferedHeader, byArray);
        return byArray.length;
    }

    public int write(BufferedHeader bufferedHeader, DataOutput dataOutput, int n, int n2) throws IOException {
        int n3;
        byte[] byArray = (byte[])this.getValue(bufferedHeader);
        if (byArray.length >= (n3 = this.size(bufferedHeader))) {
            dataOutput.write(byArray, 0, n3);
        } else {
            dataOutput.write(byArray);
            for (int i = byArray.length; i < n3; ++i) {
                dataOutput.write(0);
            }
        }
        return n3;
    }

    public int size(BufferedHeader bufferedHeader) {
        if (this.length > 0) {
            return this.length;
        }
        if (bufferedHeader == null) {
            return 0;
        }
        return bufferedHeader.getIntValue(-this.length) - this.overhead;
    }

    public Object getValue(BufferedHeader bufferedHeader) {
        int n = this.size(bufferedHeader);
        byte[] byArray = new byte[n > 0 ? n : 0];
        ByteBuffer byteBuffer = this.getBuffer(bufferedHeader);
        if (byteBuffer != null && n > 0) {
            byteBuffer.get(byArray);
        }
        return byArray;
    }

    public void setValue(BufferedHeader bufferedHeader, Object object) {
        this.setBytesValue(bufferedHeader, (byte[])object);
    }

    public void setBytesValue(BufferedHeader bufferedHeader, byte[] byArray) {
        int n;
        if (this.length > 0) {
            if (byArray == null) {
                byArray = new byte[this.length];
            }
            n = this.length;
        } else {
            if (byArray == null) {
                byArray = new byte[]{};
            }
            n = this.paddedLength(byArray.length);
        }
        ByteBuffer byteBuffer = this.getBuffer(bufferedHeader, n);
        if (byArray.length >= n) {
            byteBuffer.put(byArray, 0, n);
        } else {
            byteBuffer.put(byArray);
            for (int i = byArray.length; i < n; ++i) {
                byteBuffer.put((byte)0);
            }
        }
        if (this.length <= 0) {
            bufferedHeader.setIntValue(-this.length, n + this.overhead);
        }
    }

    public int getIntValue(BufferedHeader bufferedHeader) {
        byte[] byArray = (byte[])this.getValue(bufferedHeader);
        if (byArray != null && byArray.length >= 4) {
            return (byArray[0] & 0xFF) << 24 | (byArray[1] & 0xFF) << 16 | (byArray[2] & 0xFF) << 8 | byArray[3] & 0xFF;
        }
        return 0;
    }

    public boolean isVariableSize() {
        return this.length <= 0;
    }

    private int paddedLength(int n) {
        int n2 = n % this.alignment;
        return n + (n2 == 0 ? 0 : this.alignment - n2);
    }

    public String toString() {
        return super.toString() + " (length: " + this.length + ')';
    }
}

